/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.reporters;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.tasks.Fingerprinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.ArtifactManager;
import jenkins.util.BuildListenerAdapter;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.ResultsReporter;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.w3c.dom.Element;

public class GeneratedArtifactsReporter
implements ResultsReporter {
    private static final Logger LOGGER = Logger.getLogger(MavenSpyLogProcessor.class.getName());

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        Run run = (Run)context.get(Run.class);
        ArtifactManager artifactManager = run.pickArtifactManager();
        Launcher launcher = (Launcher)context.get(Launcher.class);
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        List<MavenSpyLogProcessor.MavenArtifact> mavenArtifacts = this.listArtifacts(mavenSpyLogsElt);
        List<MavenSpyLogProcessor.MavenArtifact> attachedMavenArtifacts = this.listAttachedArtifacts(mavenSpyLogsElt);
        ArrayList<MavenSpyLogProcessor.MavenArtifact> join = new ArrayList<MavenSpyLogProcessor.MavenArtifact>();
        join.addAll(mavenArtifacts);
        join.addAll(attachedMavenArtifacts);
        HashMap<String, String> artifactsToArchive = new HashMap<String, String>();
        HashMap<String, String> artifactsToFingerPrint = new HashMap<String, String>();
        for (MavenSpyLogProcessor.MavenArtifact mavenArtifact : join) {
            try {
                if (StringUtils.isEmpty((String)mavenArtifact.file)) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    listener.getLogger().println("[withMaven] Can't archive maven artifact with no file attached: " + mavenArtifact);
                    continue;
                }
                String artifactPathInArchiveZone = mavenArtifact.groupId.replace('.', '/') + "/" + mavenArtifact.artifactId + "/" + mavenArtifact.version + "/" + mavenArtifact.getFileName();
                String artifactPathInWorkspace = XmlUtils.getPathInWorkspace(mavenArtifact.file, workspace);
                if (StringUtils.isEmpty((String)artifactPathInWorkspace)) {
                    listener.error("[withMaven] Invalid path in the workspace (" + workspace.getRemote() + ") for artifact " + mavenArtifact);
                    continue;
                }
                FilePath artifactFilePath = new FilePath(workspace, artifactPathInWorkspace);
                if (artifactFilePath.exists()) {
                    listener.getLogger().println("[withMaven] Archive " + artifactPathInWorkspace + " under " + artifactPathInArchiveZone);
                    artifactsToArchive.put(artifactPathInArchiveZone, artifactPathInWorkspace);
                    String artifactDigest = artifactFilePath.digest();
                    artifactsToFingerPrint.put(artifactPathInArchiveZone, artifactDigest);
                    continue;
                }
                listener.getLogger().println("[withMaven] FAILURE to archive " + artifactPathInWorkspace + " under " + artifactPathInArchiveZone + ", file not found");
            }
            catch (IOException | RuntimeException e) {
                listener.error("[withMaven] WARNING: Exception archiving and fingerprinting " + mavenArtifact + ", skip archiving of the artifacts");
                e.printStackTrace(listener.getLogger());
                listener.getLogger().flush();
            }
        }
        artifactManager.archive(workspace, launcher, (BuildListener)new BuildListenerAdapter(listener), artifactsToArchive);
        Fingerprinter.FingerprintAction fingerprintAction = (Fingerprinter.FingerprintAction)run.getAction(Fingerprinter.FingerprintAction.class);
        if (fingerprintAction == null) {
            run.addAction((Action)new Fingerprinter.FingerprintAction(run, artifactsToFingerPrint));
        } else {
            fingerprintAction.add(artifactsToFingerPrint);
        }
    }

    @Nonnull
    public List<MavenSpyLogProcessor.MavenArtifact> listArtifacts(Element mavenSpyLogs) {
        ArrayList<MavenSpyLogProcessor.MavenArtifact> result = new ArrayList<MavenSpyLogProcessor.MavenArtifact>();
        for (Element projectSucceededElt : XmlUtils.getExecutionEvents(mavenSpyLogs, "ProjectSucceeded")) {
            Element projectElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "project");
            MavenSpyLogProcessor.MavenArtifact projectArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenSpyLogProcessor.MavenArtifact pomArtifact = new MavenSpyLogProcessor.MavenArtifact();
            pomArtifact.groupId = projectArtifact.groupId;
            pomArtifact.artifactId = projectArtifact.artifactId;
            pomArtifact.version = projectArtifact.version;
            pomArtifact.type = "pom";
            pomArtifact.extension = "pom";
            pomArtifact.file = projectElt.getAttribute("file");
            result.add(pomArtifact);
            Element artifactElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "artifact");
            MavenSpyLogProcessor.MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(artifactElt);
            if ("pom".equals(mavenArtifact.type)) continue;
            Element fileElt = XmlUtils.getUniqueChildElementOrNull(artifactElt, "file");
            if (fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                LOGGER.log(Level.WARNING, "listArtifacts: Project " + projectArtifact + ":  no associated file found for " + mavenArtifact + " in " + XmlUtils.toString(artifactElt));
            }
            mavenArtifact.file = StringUtils.trim((String)fileElt.getTextContent());
            result.add(mavenArtifact);
        }
        return result;
    }

    @Nonnull
    public List<MavenSpyLogProcessor.MavenArtifact> listAttachedArtifacts(Element mavenSpyLogs) {
        ArrayList<MavenSpyLogProcessor.MavenArtifact> result = new ArrayList<MavenSpyLogProcessor.MavenArtifact>();
        for (Element projectSucceededElt : XmlUtils.getExecutionEvents(mavenSpyLogs, "ProjectSucceeded")) {
            Element projectElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "project");
            MavenSpyLogProcessor.MavenArtifact projectArtifact = XmlUtils.newMavenArtifact(projectElt);
            Element attachedArtifactsParentElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "attachedArtifacts");
            List<Element> attachedArtifactsElts = XmlUtils.getChildrenElements(attachedArtifactsParentElt, "artifact");
            for (Element attachedArtifactElt : attachedArtifactsElts) {
                MavenSpyLogProcessor.MavenArtifact attachedMavenArtifact = XmlUtils.newMavenArtifact(attachedArtifactElt);
                Element fileElt = XmlUtils.getUniqueChildElementOrNull(attachedArtifactElt, "file");
                if (fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                    LOGGER.log(Level.WARNING, "Project " + projectArtifact + ", no associated file found for attached artifact " + attachedMavenArtifact + " in " + XmlUtils.toString(attachedArtifactElt));
                }
                attachedMavenArtifact.file = StringUtils.trim((String)fileElt.getTextContent());
                result.add(attachedMavenArtifact);
            }
        }
        return result;
    }
}

