/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.reporters;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitResultArchiver;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.ResultsReporter;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.w3c.dom.Element;

public class JunitTestsReporter
implements ResultsReporter {
    private static final Logger LOGGER = Logger.getLogger(JunitTestsReporter.class.getName());

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        List<Element> sureFireTestEvents = XmlUtils.getExecutionEvents(mavenSpyLogsElt, "org.apache.maven.plugins", "maven-surefire-plugin", "test");
        if (sureFireTestEvents.isEmpty()) {
            LOGGER.log(Level.FINE, "No org.apache.maven.plugins:maven-surefire-plugin:test execution found");
            return;
        }
        try {
            Class.forName("hudson.tasks.junit.JUnitResultArchiver");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] Jenkins ");
            listener.hyperlink("http://wiki.jenkins-ci.org/display/JENKINS/JUnit+Plugin", "JUnit Plugin");
            listener.getLogger().println(" not found, don't display org.apache.maven.plugins:maven-surefire-plugin:test results in pipeline screen.");
            return;
        }
        for (Element sureFireTestEvent : sureFireTestEvents) {
            String surefireEventType = sureFireTestEvent.getAttribute("type");
            if (!surefireEventType.equals("MojoSucceeded") && !surefireEventType.equals("MojoFailed")) continue;
            Element pluginElt = XmlUtils.getUniqueChildElement(sureFireTestEvent, "plugin");
            Element reportsDirectoryElt = XmlUtils.getUniqueChildElementOrNull(pluginElt, "reportsDirectory");
            Element projectElt = XmlUtils.getUniqueChildElement(sureFireTestEvent, "project");
            MavenSpyLogProcessor.MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenSpyLogProcessor.PluginInvocation pluginInvocation = XmlUtils.newPluginInvocation(pluginElt);
            if (reportsDirectoryElt == null) {
                listener.getLogger().println("[withMaven] No <reportsDirectory> element found for <plugin> in " + XmlUtils.toString(sureFireTestEvent));
                continue;
            }
            String reportsDirectory = reportsDirectoryElt.getTextContent().trim();
            if (reportsDirectory.contains("${project.build.directory}")) {
                String projectBuildDirectory = XmlUtils.getProjectBuildDirectory(projectElt);
                if (projectBuildDirectory == null || projectBuildDirectory.isEmpty()) {
                    listener.getLogger().println("[withMaven] '${project.build.directory}' found for <project> in " + XmlUtils.toString(sureFireTestEvent));
                    continue;
                }
                reportsDirectory = reportsDirectory.replace("${project.build.directory}", projectBuildDirectory);
            } else if (reportsDirectory.contains("${basedir}")) {
                String baseDir = projectElt.getAttribute("baseDir");
                if (baseDir.isEmpty()) {
                    listener.getLogger().println("[withMaven] '${basedir}' found for <project> in " + XmlUtils.toString(sureFireTestEvent));
                    continue;
                }
                reportsDirectory = reportsDirectory.replace("${basedir}", baseDir);
            }
            reportsDirectory = XmlUtils.getPathInWorkspace(reportsDirectory, workspace);
            String testResults = reportsDirectory + "/*.xml";
            listener.getLogger().println("[withMaven] Archive test results for Maven artifact " + mavenArtifact.toString() + " generated by " + pluginInvocation + ": " + testResults);
            JUnitResultArchiver archiver = new JUnitResultArchiver(testResults);
            archiver.setAllowEmptyResults(true);
            try {
                archiver.perform(run, workspace, launcher, listener);
            }
            catch (Exception e) {
                listener.error("[withMaven] Silently ignore exception archiving JUnit results for Maven artifact " + mavenArtifact.toString() + " generated by " + pluginInvocation + ": " + e);
                LOGGER.log(Level.WARNING, "Exception processing " + XmlUtils.toString(sureFireTestEvent), e);
            }
        }
    }
}

