/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.tasks.Maven;
import hudson.tasks._maven.MavenConsoleAnnotator;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.maven.GlobalMavenSettingsConfig;
import org.jenkinsci.plugins.configfiles.maven.MavenSettingsConfig;
import org.jenkinsci.plugins.configfiles.maven.security.CredentialsHelper;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.WithMavenStep;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Contextual fields used only in start(); no onResume needed")
class WithMavenStepExecution
extends StepExecution {
    private static final long serialVersionUID = 1L;
    private static final String MAVEN_HOME = "MAVEN_HOME";
    private static final String M2_HOME = "M2_HOME";
    private static final String MAVEN_OPTS = "MAVEN_OPTS";
    private static final Logger LOGGER = Logger.getLogger(WithMavenStepExecution.class.getName());
    private final transient WithMavenStep step;
    private final transient TaskListener listener;
    private final transient FilePath ws;
    private final transient Launcher launcher;
    private final transient EnvVars env;
    private transient EnvVars envOverride;
    private final transient Run<?, ?> build;
    private transient Computer computer;
    private transient FilePath tempBinDir;
    private transient BodyExecution body;
    private boolean withContainer;
    private transient PrintStream console;

    WithMavenStepExecution(StepContext context, WithMavenStep step) throws Exception {
        super(context);
        this.step = step;
        this.listener = (TaskListener)context.get(TaskListener.class);
        this.ws = (FilePath)context.get(FilePath.class);
        this.launcher = (Launcher)context.get(Launcher.class);
        this.env = (EnvVars)context.get(EnvVars.class);
        this.build = (Run)context.get(Run.class);
    }

    public boolean start() throws Exception {
        this.envOverride = new EnvVars();
        this.console = this.listener.getLogger();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Maven: {0}", this.step.getMaven());
            LOGGER.log(Level.FINE, "Jdk: {0}", this.step.getJdk());
            LOGGER.log(Level.FINE, "MavenOpts: {0}", this.step.getMavenOpts());
            LOGGER.log(Level.FINE, "Settings Config: {0}", this.step.getMavenSettingsConfig());
            LOGGER.log(Level.FINE, "Settings FilePath: {0}", this.step.getMavenSettingsFilePath());
            LOGGER.log(Level.FINE, "Global settings Config: {0}", this.step.getGlobalMavenSettingsConfig());
            LOGGER.log(Level.FINE, "Global settings FilePath: {0}", this.step.getGlobalMavenSettingsFilePath());
        }
        this.getComputer();
        this.withContainer = this.detectWithContainer();
        this.setupJDK();
        this.setupMaven();
        ConsoleLogFilter consFilter = BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)((ConsoleLogFilter)this.getContext().get(ConsoleLogFilter.class)), (ConsoleLogFilter)new MavenConsoleFilter(this.getComputer().getDefaultCharset().name()));
        EnvironmentExpander envEx = EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(this.envOverride));
        this.body = this.getContext().newBodyInvoker().withContexts(new Object[]{envEx, consFilter}).withCallback((BodyExecutionCallback)new Callback(this.tempBinDir)).start();
        return false;
    }

    private boolean detectWithContainer() {
        Launcher launcher1 = this.launcher;
        while (launcher1 instanceof Launcher.DecoratedLauncher) {
            if (launcher1.getClass().getName().contains("WithContainerStep")) {
                LOGGER.fine("Step running within docker.image()");
                return true;
            }
            launcher1 = ((Launcher.DecoratedLauncher)launcher1).getInner();
        }
        return false;
    }

    private void setupJDK() throws AbortException, IOException, InterruptedException {
        if (!StringUtils.isEmpty((String)this.step.getJdk())) {
            if (!this.withContainer) {
                JDK jdk = Jenkins.getActiveInstance().getJDK(this.step.getJdk());
                if (jdk == null) {
                    throw new AbortException("Could not find the JDK installation: " + this.step.getJdk() + ". Make sure it is configured on the Global Tool Configuration page");
                }
                Node node = this.getComputer().getNode();
                if (node == null) {
                    throw new AbortException("Could not obtain the Node for the computer: " + this.getComputer().getName());
                }
                jdk = jdk.forNode(node, this.listener).forEnvironment(this.env);
                jdk.buildEnvVars(this.envOverride);
            } else {
                LOGGER.log(Level.FINE, "Ignoring JDK installation parameter: {0}", this.step.getJdk());
                this.console.println("WARNING: Step running within docker.image() tool installations are not available see https://issues.jenkins-ci.org/browse/JENKINS-36159. You have specified a JDK installation, which will be ignored.");
            }
        }
    }

    private void setupMaven() throws AbortException, IOException, InterruptedException {
        String mvnExecPath = this.obtainMavenExec();
        this.tempBinDir = WithMavenStepExecution.tempDir(this.ws).child("withMaven" + Util.getDigestOf((String)UUID.randomUUID().toString()).substring(0, 8));
        this.tempBinDir.mkdirs();
        this.envOverride.put("PATH+MAVEN", this.tempBinDir.getRemote());
        LOGGER.log(Level.FINE, "Using temp dir: {0}", this.tempBinDir.getRemote());
        if (mvnExecPath == null) {
            throw new AbortException("Couldn\u2019t find any maven executable");
        }
        FilePath mvnExec = new FilePath(this.ws.getChannel(), mvnExecPath);
        FilePath mavenSpyJarPath = this.setupMavenSpy();
        String content = this.mavenWrapperContent(mvnExec, this.setupSettingFile(), this.setupGlobalSettingFile(), this.setupMavenLocalRepo(), mavenSpyJarPath);
        this.createWrapperScript(this.tempBinDir, mvnExec.getName(), content);
        if (!StringUtils.isEmpty((String)this.step.getMavenOpts())) {
            String mavenOpts = this.envOverride.expand(this.env.expand(this.step.getMavenOpts()));
            String mavenOpsOriginal = (String)this.env.get((Object)MAVEN_OPTS);
            if (mavenOpsOriginal != null) {
                mavenOpts = mavenOpts + " " + mavenOpsOriginal;
            }
            this.envOverride.put(MAVEN_OPTS, mavenOpts.replaceAll("[\t\r\n]+", " "));
        }
    }

    private FilePath setupMavenSpy() throws IOException, InterruptedException {
        InputStream in;
        if (this.tempBinDir == null) {
            throw new IllegalStateException("tempBinDir not defined");
        }
        String MAVEN_SPY_JAR_URL = "org.jenkinsci.plugins.pipeline.maven.mavenSpyJarUrl";
        String mavenSpyJarUrl = System.getProperty("org.jenkinsci.plugins.pipeline.maven.mavenSpyJarUrl");
        if (mavenSpyJarUrl == null) {
            String embeddedMavenSpyJarPath = "META-INF/lib/pipeline-maven-spy.jar";
            LOGGER.log(Level.FINE, "Load embedded maven spy jar '" + embeddedMavenSpyJarPath + "'");
            Class<WithMavenStepExecution> clazz = WithMavenStepExecution.class;
            ClassLoader classLoader = clazz.getClassLoader();
            LOGGER.log(Level.FINE, "Load " + embeddedMavenSpyJarPath + " using classloader " + classLoader.getClass() + ": " + classLoader);
            in = classLoader.getResourceAsStream(embeddedMavenSpyJarPath);
            if (in == null) {
                CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                String msg = "Embedded maven spy jar not found at " + embeddedMavenSpyJarPath + " in the pipeline-maven-plugin classpath. Maven Spy Jar URL can be defined with the system property: '" + "org.jenkinsci.plugins.pipeline.maven.mavenSpyJarUrl" + "'Classloader " + classLoader.getClass() + ": " + classLoader + ". Class " + clazz.getName() + " loaded from " + (codeSource == null ? "#unknown#" : codeSource.getLocation());
                throw new IllegalStateException(msg);
            }
        } else {
            LOGGER.log(Level.FINE, "Load maven spy jar provided by system property 'org.jenkinsci.plugins.pipeline.maven.mavenSpyJarUrl': " + mavenSpyJarUrl);
            in = new URL(mavenSpyJarUrl).openStream();
        }
        FilePath mavenSpyJarFilePath = this.tempBinDir.child("pipeline-maven-spy.jar");
        mavenSpyJarFilePath.copyFrom(in);
        return mavenSpyJarFilePath;
    }

    private String obtainMavenExec() throws AbortException, IOException, InterruptedException {
        Maven.MavenInstallation mi = null;
        String mvnExecPath = null;
        LOGGER.fine("Setting up maven");
        String mavenName = this.step.getMaven();
        if (!StringUtils.isEmpty((String)mavenName)) {
            if (!this.withContainer) {
                LOGGER.log(Level.FINE, "Maven Installation parameter: {0}", mavenName);
                for (Maven.MavenInstallation i : WithMavenStepExecution.getMavenInstallations()) {
                    if (mavenName == null || !mavenName.equals(i.getName())) continue;
                    mi = i;
                    LOGGER.log(Level.FINE, "Found maven installation on {0}", mi.getHome());
                    break;
                }
                if (mi == null) {
                    throw new AbortException("Could not find '" + mavenName + "' maven installation.");
                }
            } else {
                this.console.println("WARNING: Step running within docker.image() tool installations are not available see https://issues.jenkins-ci.org/browse/JENKINS-36159. You have specified a Maven installation, which will be ignored.");
                LOGGER.log(Level.FINE, "Ignoring Maven Installation parameter: {0}", mavenName);
            }
        }
        if (mi != null) {
            this.console.println("Using Maven Installation " + mi.getName());
            Node node = this.getComputer().getNode();
            if (node == null) {
                throw new AbortException("Could not obtain the Node for the computer: " + this.getComputer().getName());
            }
            mi = mi.forNode(node, this.listener).forEnvironment(this.env);
            mi.buildEnvVars(this.envOverride);
            mvnExecPath = mi.getExecutable(this.launcher);
        } else {
            LOGGER.fine("Searching for Maven on MAVEN_HOME and M2_HOME...");
            if (!this.withContainer) {
                LOGGER.fine("Using computer environment...");
                EnvVars agentEnv = this.getComputer().getEnvironment();
                LOGGER.log(Level.FINE, "Agent env: {0}", agentEnv);
                String mavenHome = (String)agentEnv.get((Object)MAVEN_HOME);
                if (mavenHome == null) {
                    mavenHome = (String)agentEnv.get((Object)M2_HOME);
                }
                if (mavenHome != null) {
                    LOGGER.log(Level.FINE, "Found maven installation on {0}", mavenHome);
                    mi = new Maven.MavenInstallation("Maven Auto-discovered", mavenHome, null);
                    mi.buildEnvVars(this.envOverride);
                    mvnExecPath = mi.getExecutable(this.launcher);
                }
            } else {
                LOGGER.fine("Calling printenv on docker container...");
                String mavenHome = this.readFromProcess("printenv", MAVEN_HOME);
                if (mavenHome == null) {
                    mavenHome = this.readFromProcess("printenv", M2_HOME);
                }
                if (mavenHome != null) {
                    LOGGER.log(Level.FINE, "Found maven installation on {0}", mavenHome);
                    mvnExecPath = mavenHome + "/bin/mvn";
                }
            }
        }
        if (mvnExecPath == null) {
            LOGGER.fine("No Maven Installation or MAVEN_HOME found, looking for mvn executable by using which/where command");
            if (Boolean.TRUE.equals(this.getComputer().isUnix())) {
                mvnExecPath = this.readFromProcess("/bin/sh", "-c", "which mvn");
            } else {
                mvnExecPath = this.readFromProcess("where", "mvn.cmd");
                if (mvnExecPath == null) {
                    mvnExecPath = this.readFromProcess("where", "mvn.bat");
                }
            }
        }
        if (mvnExecPath == null) {
            throw new AbortException("Could not find maven executable, please set up a Maven Installation or configure MAVEN_HOME environment variable");
        }
        LOGGER.log(Level.FINE, "Found exec for maven on: {0}", mvnExecPath);
        this.console.printf("Using maven exec: %s%n", mvnExecPath);
        return mvnExecPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFromProcess(String ... args) throws InterruptedException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Launcher.ProcStarter ps = this.launcher.launch();
            Proc p = this.launcher.launch(ps.cmds(args).stdout((OutputStream)baos));
            int exitCode = p.join();
            if (exitCode == 0) {
                String string2 = baos.toString(this.getComputer().getDefaultCharset().name()).replaceAll("[\t\r\n]+", " ").trim();
                return string2;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace(this.console.format("Error executing command '%s' : %s%n", Arrays.toString(args), e.getMessage()));
            return null;
        }
    }

    private String mavenWrapperContent(FilePath mvnExec, String settingsFile, String globalSettingsFile, String mavenLocalRepo, @Nullable FilePath mavenSpyJarPath) throws AbortException {
        String lineSep;
        ArgumentListBuilder argList = new ArgumentListBuilder(new String[]{mvnExec.getRemote()});
        boolean isUnix = Boolean.TRUE.equals(this.getComputer().isUnix());
        String string = lineSep = isUnix ? "\n" : "\r\n";
        if (!StringUtils.isEmpty((String)settingsFile)) {
            argList.add(new String[]{"--settings", settingsFile});
        }
        if (!StringUtils.isEmpty((String)globalSettingsFile)) {
            argList.add(new String[]{"--global-settings", globalSettingsFile});
        }
        if (!StringUtils.isEmpty((String)mavenLocalRepo)) {
            argList.addKeyValuePair(null, "maven.repo.local", mavenLocalRepo, false);
        }
        argList.add("--batch-mode");
        argList.add("--show-version");
        if (mavenSpyJarPath != null) {
            argList.add("-Dmaven.ext.class.path=\"" + mavenSpyJarPath.getRemote() + "\"");
            argList.add("-Dorg.jenkinsci.plugins.pipeline.maven.reportsFolder=\"" + this.tempBinDir.getRemote() + "\"");
        }
        StringBuilder c = new StringBuilder();
        if (isUnix) {
            c.append("#!/bin/sh -e").append(lineSep);
        } else {
            c.append("@echo off").append(lineSep);
        }
        c.append("echo ----- withMaven Wrapper script -----").append(lineSep);
        c.append(argList.toString()).append(isUnix ? " \"$@\"" : " %*").append(lineSep);
        String content = c.toString();
        LOGGER.log(Level.FINE, "Generated wrapper: {0}", content);
        return content;
    }

    private FilePath createWrapperScript(FilePath tempBinDir, String name, String content) throws IOException, InterruptedException {
        FilePath scriptFile = tempBinDir.child(name);
        scriptFile.write(content, this.getComputer().getDefaultCharset().name());
        scriptFile.chmod(493);
        return scriptFile;
    }

    private String setupMavenLocalRepo() throws IOException, InterruptedException {
        if (!StringUtils.isEmpty((String)this.step.getMavenLocalRepo())) {
            String expandedPath = this.envOverride.expand(this.env.expand(this.step.getMavenLocalRepo()));
            FilePath repoPath = new FilePath(this.ws, expandedPath);
            repoPath.mkdirs();
            return repoPath.getRemote();
        }
        return null;
    }

    private String setupSettingFile() throws IOException, InterruptedException {
        FilePath settingsDest = this.tempBinDir.child("settings.xml");
        if (!StringUtils.isEmpty((String)this.step.getMavenSettingsConfig())) {
            this.settingsFromConfig(this.step.getMavenSettingsConfig(), settingsDest);
            this.envOverride.put("MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        if (!StringUtils.isEmpty((String)this.step.getMavenSettingsFilePath())) {
            String settingsPath = this.envOverride.expand(this.env.expand(this.step.getMavenSettingsFilePath()));
            this.console.println("Setting up settings file " + settingsPath);
            FilePath settings = new FilePath(this.ws.getChannel(), settingsPath);
            if (settings.exists()) {
                this.console.format("Using settings from: %s on build agent%n", settingsPath);
                LOGGER.log(Level.FINE, "Copying file from build agent {0} to {1}", new Object[]{settings, settingsDest});
                settings.copyTo(settingsDest);
            } else {
                settings = new FilePath(new File(settingsPath));
                if (settings.exists()) {
                    this.console.format("Using settings from: %s on master%n", settingsPath);
                    LOGGER.log(Level.FINE, "Copying file from master to build agent {0} to {1}", new Object[]{settings, settingsDest});
                    settings.copyTo(settingsDest);
                } else {
                    throw new AbortException("Could not find file '" + settingsPath + "' on the build agent nor the master");
                }
            }
            this.envOverride.put("MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        return null;
    }

    private String setupGlobalSettingFile() throws IOException, InterruptedException {
        FilePath settingsDest = this.tempBinDir.child("globalSettings.xml");
        if (!StringUtils.isEmpty((String)this.step.getGlobalMavenSettingsConfig())) {
            this.globalSettingsFromConfig(this.step.getGlobalMavenSettingsConfig(), settingsDest);
            this.envOverride.put("GLOBAL_MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        if (!StringUtils.isEmpty((String)this.step.getGlobalMavenSettingsFilePath())) {
            String settingsPath = this.envOverride.expand(this.env.expand(this.step.getGlobalMavenSettingsFilePath()));
            this.console.println("Setting up global settings file " + settingsPath);
            FilePath settings = new FilePath(this.ws.getChannel(), settingsPath);
            if (settings.exists()) {
                this.console.format("Using global settings from: %s on build agent%n", settingsPath);
                LOGGER.log(Level.FINE, "Copying file from build agent {0} to {1}", new Object[]{settings, settingsDest});
                settings.copyTo(settingsDest);
            } else {
                settings = new FilePath(new File(settingsPath));
                if (settings.exists()) {
                    this.console.format("Using global settings from: %s on master%n", settingsPath);
                    LOGGER.log(Level.FINE, "Copying file from master to build agent {0} to {1}", new Object[]{settings, settingsDest});
                    settings.copyTo(settingsDest);
                } else {
                    throw new AbortException("Could not find file '" + settingsPath + "' on the build agent nor the master");
                }
            }
            this.envOverride.put("GLOBAL_MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        return null;
    }

    private void settingsFromConfig(String settingsConfigId, FilePath settingsFile) throws AbortException {
        Config c = ConfigFiles.getByIdOrNull(this.build, (String)settingsConfigId);
        if (c == null) {
            throw new AbortException("Could not find the Maven settings.xml config file id:" + settingsConfigId + ". Make sure it exists on Managed Files");
        }
        if (StringUtils.isBlank((String)c.content)) {
            throw new AbortException("Could not create Maven settings.xml config file id:" + settingsConfigId + ". Content of the file is empty");
        }
        MavenSettingsConfig config = c instanceof MavenSettingsConfig ? (MavenSettingsConfig)c : new MavenSettingsConfig(c.id, c.name, c.comment, c.content, MavenSettingsConfig.isReplaceAllDefault, null);
        Boolean isReplaceAll = config.getIsReplaceAll();
        this.console.println("Using settings config with name " + config.name);
        this.console.println("Replacing all maven server entries not found in credentials list is " + isReplaceAll);
        try {
            String fileContent = config.content;
            List serverCredentialMappings = config.getServerCredentialMappings();
            Map resolvedCredentials = CredentialsHelper.resolveCredentials(this.build, (List)serverCredentialMappings);
            if (!resolvedCredentials.isEmpty()) {
                ArrayList tempFiles = new ArrayList();
                fileContent = CredentialsHelper.fillAuthentication((String)fileContent, (Boolean)isReplaceAll, (Map)resolvedCredentials, (FilePath)this.tempBinDir, tempFiles);
            }
            settingsFile.write(fileContent, this.getComputer().getDefaultCharset().name());
            LOGGER.log(Level.FINE, "Created config file {0}", new Object[]{settingsFile});
        }
        catch (Exception e) {
            throw new IllegalStateException("the settings.xml could not be supplied for the current build: " + e.getMessage(), e);
        }
    }

    private void globalSettingsFromConfig(String globalSettingsConfigId, FilePath globalSettingsFile) throws AbortException {
        Config c = ConfigFiles.getByIdOrNull(this.build, (String)globalSettingsConfigId);
        if (c == null) {
            throw new AbortException("Could not find the Maven global settings.xml config file id:" + globalSettingsFile + ". Make sure it exists on Managed Files");
        }
        if (StringUtils.isBlank((String)c.content)) {
            throw new AbortException("Could not create Maven global settings.xml config file id:" + globalSettingsFile + ". Content of the file is empty");
        }
        GlobalMavenSettingsConfig config = c instanceof GlobalMavenSettingsConfig ? (GlobalMavenSettingsConfig)c : new GlobalMavenSettingsConfig(c.id, c.name, c.comment, c.content, MavenSettingsConfig.isReplaceAllDefault, null);
        Boolean isReplaceAll = config.getIsReplaceAll();
        this.console.println("Using global settings config with name " + config.name);
        this.console.println("Replacing all maven server entries not found in credentials list is " + isReplaceAll);
        try {
            String fileContent = config.content;
            List serverCredentialMappings = config.getServerCredentialMappings();
            Map resolvedCredentials = CredentialsHelper.resolveCredentials(this.build, (List)serverCredentialMappings);
            if (!resolvedCredentials.isEmpty()) {
                ArrayList tempFiles = new ArrayList();
                fileContent = CredentialsHelper.fillAuthentication((String)fileContent, (Boolean)isReplaceAll, (Map)resolvedCredentials, (FilePath)this.tempBinDir, tempFiles);
            }
            globalSettingsFile.write(fileContent, this.getComputer().getDefaultCharset().name());
            LOGGER.log(Level.FINE, "Created global config file {0}", new Object[]{globalSettingsFile});
        }
        catch (Exception e) {
            throw new IllegalStateException("the globalSettings.xml could not be supplied for the current build: " + e.getMessage(), e);
        }
    }

    private static Maven.MavenInstallation[] getMavenInstallations() {
        return ((Maven.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations();
    }

    public void stop(Throwable cause) throws Exception {
        if (this.body != null) {
            this.body.cancel(cause);
        }
    }

    @Nonnull
    private Computer getComputer() throws AbortException {
        if (this.computer != null) {
            return this.computer;
        }
        String node = null;
        Jenkins j = Jenkins.getActiveInstance();
        for (Computer c : j.getComputers()) {
            if (c.getChannel() != this.launcher.getChannel()) continue;
            node = c.getName();
            break;
        }
        if (node == null) {
            throw new AbortException("Could not find computer for the job");
        }
        this.computer = j.getComputer(node);
        if (this.computer == null) {
            throw new AbortException("No such computer " + node);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Computer: {0}", this.computer.getName());
            try {
                LOGGER.log(Level.FINE, "Env: {0}", this.computer.getEnvironment());
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return this.computer;
    }

    private static FilePath tempDir(FilePath ws) {
        return ws.sibling(ws.getName() + System.getProperty(WorkspaceList.class.getName(), "@") + "tmp");
    }

    private static class Callback
    extends BodyExecutionCallback.TailCall {
        private final FilePath tempBinDir;
        private final MavenSpyLogProcessor mavenSpyLogProcessor = new MavenSpyLogProcessor();
        private static final long serialVersionUID = 1L;

        public Callback(FilePath tempBinDir) {
            this.tempBinDir = tempBinDir;
        }

        protected void finished(StepContext context) throws Exception {
            this.mavenSpyLogProcessor.processMavenSpyLogs(context, this.tempBinDir);
            try {
                this.tempBinDir.deleteRecursive();
            }
            catch (IOException | InterruptedException e) {
                BuildListener listener = (BuildListener)context.get(BuildListener.class);
                try {
                    if (e instanceof IOException) {
                        Util.displayIOException((IOException)((IOException)e), (TaskListener)listener);
                    }
                    e.printStackTrace(listener.fatalError("Error deleting temporary files"));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> overrides;

        private ExpanderImpl(EnvVars overrides) {
            LOGGER.log(Level.FINE, "Overrides: " + overrides.toString());
            this.overrides = new HashMap<String, String>();
            for (Map.Entry entry : overrides.entrySet()) {
                this.overrides.put((String)entry.getKey(), (String)entry.getValue());
            }
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.overrideAll(this.overrides);
        }
    }

    private static class MavenConsoleFilter
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String charset;

        public MavenConsoleFilter(String charset) {
            this.charset = charset;
        }

        public OutputStream decorateLogger(AbstractBuild _ignore, OutputStream logger) throws IOException, InterruptedException {
            return new MavenConsoleAnnotator(logger, Charset.forName(this.charset));
        }
    }
}

