/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Fingerprinter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jenkins.model.ArtifactManager;
import jenkins.util.BuildListenerAdapter;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.maven.reporters.FindbugsAnalysisReporter;
import org.jenkinsci.plugins.pipeline.maven.reporters.JunitTestsReporter;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MavenSpyLogProcessor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MavenSpyLogProcessor.class.getName());
    protected final transient DocumentBuilder documentBuilder;

    public MavenSpyLogProcessor() {
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void processMavenSpyLogs(StepContext context, FilePath mavenSpyLogFolder) throws IOException, InterruptedException {
        FilePath[] mavenSpyLogsList = mavenSpyLogFolder.list("maven-spy-*.log");
        Run run = (Run)context.get(Run.class);
        ArtifactManager artifactManager = run.pickArtifactManager();
        Launcher launcher = (Launcher)context.get(Launcher.class);
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("listener is NULL");
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        for (FilePath mavenSpyLogs : mavenSpyLogsList) {
            try {
                LOGGER.log(Level.INFO, "Evaluate Maven Spy logs: " + mavenSpyLogs.getRemote());
                Element mavenSpyLogsElt = this.documentBuilder.parse(mavenSpyLogs.read()).getDocumentElement();
                List<MavenArtifact> mavenArtifacts = this.listArtifacts(mavenSpyLogsElt);
                List<MavenArtifact> attachedMavenArtifacts = this.listAttachedArtifacts(mavenSpyLogsElt);
                ArrayList<MavenArtifact> join = new ArrayList<MavenArtifact>();
                join.addAll(mavenArtifacts);
                join.addAll(attachedMavenArtifacts);
                HashMap<String, String> artifactsToArchive = new HashMap<String, String>();
                HashMap<String, String> artifactsToFingerPrint = new HashMap<String, String>();
                for (MavenArtifact mavenArtifact : join) {
                    if (StringUtils.isEmpty((String)mavenArtifact.file)) {
                        listener.error("Can't archive maven artifact with no file attached: " + mavenArtifact);
                        continue;
                    }
                    String artifactPathInArchiveZone = mavenArtifact.groupId.replace('.', '/') + "/" + mavenArtifact.artifactId + "/" + mavenArtifact.version + "/" + mavenArtifact.getFileName();
                    String artifactPathInWorkspace = XmlUtils.getPathInWorkspace(mavenArtifact.file, workspace);
                    if (StringUtils.isEmpty((String)artifactPathInWorkspace)) {
                        listener.error("Invalid path in the workspace (" + workspace.getRemote() + ") for artifact " + mavenArtifact);
                        continue;
                    }
                    listener.getLogger().println("Archive " + mavenArtifact + " under " + artifactPathInArchiveZone);
                    artifactsToArchive.put(artifactPathInArchiveZone, artifactPathInWorkspace);
                    FilePath artifactFilePath = new FilePath(workspace, artifactPathInWorkspace);
                    String artifactDigest = artifactFilePath.digest();
                    listener.getLogger().println("Archive " + mavenArtifact + " under " + artifactPathInArchiveZone + " has digest " + artifactDigest);
                    artifactsToFingerPrint.put(artifactPathInArchiveZone, artifactDigest);
                }
                artifactManager.archive(workspace, launcher, (BuildListener)new BuildListenerAdapter(listener), artifactsToArchive);
                Fingerprinter.FingerprintAction fingerprintAction = (Fingerprinter.FingerprintAction)run.getAction(Fingerprinter.FingerprintAction.class);
                if (fingerprintAction == null) {
                    run.addAction((Action)new Fingerprinter.FingerprintAction(run, artifactsToFingerPrint));
                } else {
                    fingerprintAction.add(artifactsToFingerPrint);
                }
                new JunitTestsReporter().process(context, mavenSpyLogsElt);
                new FindbugsAnalysisReporter().process(context, mavenSpyLogsElt);
            }
            catch (SAXException e) {
                listener.error("Exception parsing maven spy logs " + mavenSpyLogs + ", ignore file");
                e.printStackTrace(listener.getLogger());
            }
        }
    }

    @Nonnull
    public List<MavenArtifact> listArtifacts(Element mavenSpyLogs) {
        ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
        for (Element projectSucceededElt : XmlUtils.getExecutionEvents(mavenSpyLogs, "ProjectSucceeded")) {
            Element projectElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "project");
            MavenArtifact projectArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenArtifact pomArtifact = new MavenArtifact();
            pomArtifact.groupId = projectArtifact.groupId;
            pomArtifact.artifactId = projectArtifact.artifactId;
            pomArtifact.version = projectArtifact.version;
            pomArtifact.type = "pom";
            pomArtifact.file = projectElt.getAttribute("file");
            result.add(pomArtifact);
            Element artifactElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "artifact");
            MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(artifactElt);
            if ("pom".equals(mavenArtifact.type)) continue;
            Element fileElt = XmlUtils.getUniqueChildElementOrNull(artifactElt, "file");
            if (fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                LOGGER.log(Level.WARNING, "listArtifacts: Project " + projectArtifact + ":  no associated file found for " + mavenArtifact + " in " + XmlUtils.toString(artifactElt));
            }
            mavenArtifact.file = StringUtils.trim((String)fileElt.getTextContent());
            result.add(mavenArtifact);
        }
        return result;
    }

    @Nonnull
    public List<MavenArtifact> listAttachedArtifacts(Element mavenSpyLogs) {
        ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
        for (Element projectSucceededElt : XmlUtils.getExecutionEvents(mavenSpyLogs, "ProjectSucceeded")) {
            Element projectElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "project");
            MavenArtifact projectArtifact = XmlUtils.newMavenArtifact(projectElt);
            Element attachedArtifactsParentElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "attachedArtifacts");
            List<Element> attachedArtifactsElts = XmlUtils.getChildrenElements(attachedArtifactsParentElt, "artifact");
            for (Element attachedArtifactElt : attachedArtifactsElts) {
                MavenArtifact attachedMavenArtifact = XmlUtils.newMavenArtifact(attachedArtifactElt);
                Element fileElt = XmlUtils.getUniqueChildElementOrNull(attachedArtifactElt, "file");
                if (fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                    LOGGER.log(Level.WARNING, "Project " + projectArtifact + ", no associated file found for attached artifact " + attachedMavenArtifact + " in " + XmlUtils.toString(attachedArtifactElt));
                }
                attachedMavenArtifact.file = StringUtils.trim((String)fileElt.getTextContent());
                result.add(attachedMavenArtifact);
            }
        }
        return result;
    }

    public static class PluginInvocation {
        public String groupId;
        public String artifactId;
        public String version;
        public String goal;
        public String executionId;

        public String toString() {
            return "PluginInvocation{" + this.groupId + ":" + this.artifactId + ":" + this.version + "@" + this.goal + "  " + this.executionId + '}';
        }
    }

    public static class MavenArtifact {
        public String groupId;
        public String artifactId;
        public String version;
        public String type;
        public String classifier;
        public String file;

        String getFileName() {
            return this.artifactId + "-" + this.version + (this.classifier == null || this.classifier.isEmpty() ? "" : "-" + this.classifier) + "." + this.type;
        }

        public String toString() {
            return "MavenArtifact{" + this.groupId + ":" + this.artifactId + ":" + this.type + (this.classifier == null ? "" : ":" + this.classifier) + ":" + this.version + (this.file == null ? "" : " " + this.file) + '}';
        }
    }
}

