/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.FilePath;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenDependency;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.util.FileUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static final Logger LOGGER = Logger.getLogger(XmlUtils.class.getName());

    public static MavenArtifact newMavenArtifact(Element artifactElt) {
        MavenArtifact mavenArtifact = new MavenArtifact();
        XmlUtils.loadMavenArtifact(artifactElt, mavenArtifact);
        return mavenArtifact;
    }

    public static MavenDependency newMavenDependency(Element dependencyElt) {
        MavenDependency dependency = new MavenDependency();
        XmlUtils.loadMavenArtifact(dependencyElt, (MavenArtifact)dependency);
        dependency.setScope(dependencyElt.getAttribute("scope"));
        dependency.optional = Boolean.parseBoolean(dependencyElt.getAttribute("optional"));
        return dependency;
    }

    private static void loadMavenArtifact(Element artifactElt, MavenArtifact mavenArtifact) {
        String snapshot;
        mavenArtifact.setGroupId(artifactElt.getAttribute("groupId"));
        mavenArtifact.setArtifactId(artifactElt.getAttribute("artifactId"));
        mavenArtifact.setVersion(artifactElt.getAttribute("version"));
        mavenArtifact.setBaseVersion(artifactElt.getAttribute("baseVersion"));
        if (mavenArtifact.getBaseVersion() == null || mavenArtifact.getBaseVersion().isEmpty()) {
            mavenArtifact.setBaseVersion(mavenArtifact.getVersion());
        }
        mavenArtifact.setSnapshot((snapshot = artifactElt.getAttribute("snapshot")) != null && !snapshot.trim().isEmpty() ? Boolean.parseBoolean(artifactElt.getAttribute("snapshot")) : mavenArtifact.getBaseVersion().contains("SNAPSHOT"));
        mavenArtifact.setType(artifactElt.getAttribute("type"));
        if (mavenArtifact.getType() == null || mavenArtifact.getType().isEmpty()) {
            mavenArtifact.setType(artifactElt.getAttribute("packaging"));
        }
        mavenArtifact.setClassifier(artifactElt.hasAttribute("classifier") ? artifactElt.getAttribute("classifier") : null);
        mavenArtifact.setExtension(artifactElt.getAttribute("extension"));
    }

    public static MavenSpyLogProcessor.PluginInvocation newPluginInvocation(Element pluginInvocationElt) {
        MavenSpyLogProcessor.PluginInvocation pluginInvocation = new MavenSpyLogProcessor.PluginInvocation();
        pluginInvocation.groupId = pluginInvocationElt.getAttribute("groupId");
        pluginInvocation.artifactId = pluginInvocationElt.getAttribute("artifactId");
        pluginInvocation.version = pluginInvocationElt.getAttribute("version");
        pluginInvocation.goal = pluginInvocationElt.getAttribute("goal");
        pluginInvocation.executionId = pluginInvocationElt.getAttribute("executionId");
        return pluginInvocation;
    }

    @NonNull
    public static Element getUniqueChildElement(@NonNull Element element, @NonNull String childElementName) {
        Element child = XmlUtils.getUniqueChildElementOrNull(element, childElementName);
        if (child == null) {
            throw new IllegalStateException("No <" + childElementName + "> element found");
        }
        return child;
    }

    @Nullable
    public static Element getUniqueChildElementOrNull(@NonNull Element element, String ... childElementName) {
        Element result = element;
        for (String childEltName : childElementName) {
            List<Element> childElts = XmlUtils.getChildrenElements(result, childEltName);
            if (childElts.size() == 0) {
                return null;
            }
            if (childElts.size() > 1) {
                throw new IllegalStateException("More than 1 (" + childElts.size() + ") elements <" + childEltName + "> found in " + XmlUtils.toString(element));
            }
            result = childElts.get(0);
        }
        return result;
    }

    @NonNull
    public static List<Element> getChildrenElements(@NonNull Element element, @NonNull String childElementName) {
        NodeList childElts = element.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < childElts.getLength(); ++i) {
            Node node = childElts.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals(childElementName)) continue;
            result.add((Element)node);
        }
        return result;
    }

    @NonNull
    public static String toString(@Nullable Node node) {
        try {
            StringWriter out = new StringWriter();
            Transformer identityTransformer = TransformerFactory.newInstance().newTransformer();
            identityTransformer.transform(new DOMSource(node), new StreamResult(out));
            return out.toString();
        }
        catch (TransformerException e) {
            LOGGER.log(Level.WARNING, "Exception dumping node " + String.valueOf(node), e);
            return e.toString();
        }
    }

    @NonNull
    public static List<Element> getExecutionEvents(@NonNull Element mavenSpyLogs, String ... expectedType) {
        HashSet<String> expectedTypes = new HashSet<String>(Arrays.asList(expectedType));
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : XmlUtils.getChildrenElements(mavenSpyLogs, "ExecutionEvent")) {
            if (!expectedTypes.contains(element.getAttribute("type"))) continue;
            result.add(element);
        }
        return result;
    }

    @NonNull
    public static List<Element> getArtifactDeployedEvents(@NonNull Element mavenSpyLogs) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nodes = mavenSpyLogs.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Attr type;
            Element element;
            Node node = nodes.item(i);
            if (!(node instanceof Element) || !"RepositoryEvent".equals((element = (Element)node).getNodeName()) || null == (type = element.getAttributeNode("type")) || !"ARTIFACT_DEPLOYED".equals(type.getValue())) continue;
            elements.add(element);
        }
        return elements;
    }

    @Nullable
    public static Element getArtifactDeployedEvent(@NonNull List<Element> artifactDeployedEvents, @NonNull String filePath) {
        for (Element artifactDeployedEvent : artifactDeployedEvents) {
            String deployedArtifactFilePath;
            if (!"RepositoryEvent".equals(artifactDeployedEvent.getNodeName()) || !"ARTIFACT_DEPLOYED".equals(artifactDeployedEvent.getAttribute("type")) || !Objects.equals(filePath, deployedArtifactFilePath = XmlUtils.getUniqueChildElement(artifactDeployedEvent, "artifact").getAttribute("file"))) continue;
            return artifactDeployedEvent;
        }
        return null;
    }

    @NonNull
    public static List<Element> getExecutionEventsByPlugin(@NonNull Element mavenSpyLogs, String pluginGroupId, String pluginArtifactId, String pluginGoal, String ... eventType) {
        HashSet<String> eventTypes = new HashSet<String>(Arrays.asList(eventType));
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element executionEventElt : XmlUtils.getChildrenElements(mavenSpyLogs, "ExecutionEvent")) {
            Element pluginElt;
            if (!eventTypes.contains(executionEventElt.getAttribute("type")) || (pluginElt = XmlUtils.getUniqueChildElementOrNull(executionEventElt, "plugin")) == null || !pluginElt.getAttribute("groupId").equals(pluginGroupId) || !pluginElt.getAttribute("artifactId").equals(pluginArtifactId) || !pluginElt.getAttribute("goal").equals(pluginGoal)) continue;
            result.add(executionEventElt);
        }
        return result;
    }

    @NonNull
    public static List<String> getExecutedLifecyclePhases(@NonNull Element mavenSpyLogs) {
        ArrayList<String> lifecyclePhases = new ArrayList<String>();
        for (Element mojoSucceededEvent : XmlUtils.getExecutionEvents(mavenSpyLogs, "MojoSucceeded")) {
            Element pluginElement = XmlUtils.getUniqueChildElement(mojoSucceededEvent, "plugin");
            String lifecyclePhase = pluginElement.getAttribute("lifecyclePhase");
            if (lifecyclePhases.contains(lifecyclePhase)) continue;
            lifecyclePhases.add(lifecyclePhase);
        }
        return lifecyclePhases;
    }

    @Nullable
    public static String resolveMavenPlaceholders(Element targetElt, Element projectElt) {
        return XmlUtils.resolveMavenPlaceholders(targetElt.getTextContent().trim(), projectElt);
    }

    @Nullable
    public static String resolveMavenPlaceholders(String target, Element projectElt) {
        char separator;
        Object result = target;
        char c = separator = FileUtils.isWindows((String)result) ? (char)'\\' : '/';
        if (((String)result).contains("${project.build.directory}")) {
            String projectBuildDirectory = XmlUtils.getProjectBuildDirectory(projectElt);
            if (projectBuildDirectory == null || projectBuildDirectory.isEmpty()) {
                return null;
            }
            result = ((String)result).replace("${project.build.directory}", projectBuildDirectory);
        } else if (((String)result).contains("${project.reporting.outputDirectory}")) {
            String projectBuildDirectory = XmlUtils.getProjectBuildDirectory(projectElt);
            if (projectBuildDirectory == null || projectBuildDirectory.isEmpty()) {
                return null;
            }
            result = ((String)result).replace("${project.reporting.outputDirectory}", projectBuildDirectory + separator + "site");
        } else if (((String)result).contains("${basedir}")) {
            String baseDir = projectElt.getAttribute("baseDir");
            if (baseDir.isEmpty()) {
                return null;
            }
            result = ((String)result).replace("${basedir}", baseDir);
        } else if (!FileUtils.isAbsolutePath((String)result)) {
            String baseDir = projectElt.getAttribute("baseDir");
            if (baseDir.isEmpty()) {
                return null;
            }
            result = baseDir + separator + (String)result;
        }
        return result;
    }

    @NonNull
    public static String getPathInWorkspace(@NonNull String absoluteFilePath, @NonNull FilePath workspace) {
        String relativePath;
        Object sanitizedAbsoluteFilePath;
        boolean windows = FileUtils.isWindows(workspace);
        String workspaceRemote = workspace.getRemote();
        Object sanitizedWorkspaceRemote = windows ? workspaceRemote.replace('\\', '/') : workspaceRemote;
        Object object = sanitizedAbsoluteFilePath = windows ? absoluteFilePath.replace('\\', '/') : absoluteFilePath;
        if (workspaceRemote.startsWith("/var/") && absoluteFilePath.startsWith("/private/var/")) {
            sanitizedWorkspaceRemote = workspaceRemote;
            sanitizedAbsoluteFilePath = absoluteFilePath.substring("/private".length());
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)sanitizedAbsoluteFilePath, (CharSequence)sanitizedWorkspaceRemote)) {
            if (((String)sanitizedWorkspaceRemote).contains("/workspace/") && ((String)sanitizedAbsoluteFilePath).contains("/workspace/")) {
                sanitizedAbsoluteFilePath = "/workspace/" + StringUtils.substringAfter((String)sanitizedAbsoluteFilePath, (String)"/workspace/");
                sanitizedWorkspaceRemote = "/workspace/" + StringUtils.substringAfter((String)sanitizedWorkspaceRemote, (String)"/workspace/");
            } else if (((String)sanitizedWorkspaceRemote).endsWith("/workspace") && ((String)sanitizedAbsoluteFilePath).contains("/workspace/")) {
                sanitizedAbsoluteFilePath = "workspace/" + StringUtils.substringAfter((String)sanitizedAbsoluteFilePath, (String)"/workspace/");
                sanitizedWorkspaceRemote = "workspace/";
            } else {
                throw new IllegalArgumentException("Cannot relativize '" + absoluteFilePath + "' relatively to '" + workspace.getRemote() + "'");
            }
        }
        if ((relativePath = StringUtils.removeStartIgnoreCase((String)sanitizedAbsoluteFilePath, (String)sanitizedWorkspaceRemote)).startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if (windows) {
            relativePath = relativePath.replace('/', '\\');
        }
        LOGGER.log(Level.FINEST, "getPathInWorkspace({0}, {1}: {2}", new Object[]{absoluteFilePath, workspaceRemote, relativePath});
        return relativePath;
    }

    @Deprecated
    public static boolean isWindows(@NonNull FilePath path) {
        return FileUtils.isWindows(path);
    }

    @NonNull
    public static String getFileSeparatorOnRemote(@NonNull FilePath filePath) {
        int indexOfSlash = filePath.getRemote().indexOf(47);
        int indexOfBackSlash = filePath.getRemote().indexOf(92);
        if (indexOfSlash == -1) {
            return "\\";
        }
        if (indexOfBackSlash == -1) {
            return "/";
        }
        if (indexOfSlash < indexOfBackSlash) {
            return "/";
        }
        return "\\";
    }

    @Nullable
    public static String getProjectBuildDirectory(@NonNull Element projectElt) {
        Element build = XmlUtils.getUniqueChildElementOrNull(projectElt, "build");
        if (build == null) {
            return null;
        }
        return build.getAttribute("directory");
    }

    @NonNull
    public static String join(@NonNull Iterable<String> elements, @NonNull String delimiter) {
        StringBuilder result = new StringBuilder();
        Iterator<String> it = elements.iterator();
        while (it.hasNext()) {
            String element = it.next();
            result.append(element);
            if (!it.hasNext()) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    @NonNull
    public static List<MavenArtifact> listGeneratedArtifacts(Element mavenSpyLogs, boolean includeAttachedArtifacts) {
        List<Element> artifactDeployedEvents = XmlUtils.getArtifactDeployedEvents(mavenSpyLogs);
        ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
        for (Element projectSucceededElt : XmlUtils.getExecutionEvents(mavenSpyLogs, "ProjectSucceeded")) {
            Element projectElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "project");
            MavenArtifact projectArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenArtifact pomArtifact = new MavenArtifact();
            pomArtifact.setGroupId(projectArtifact.getGroupId());
            pomArtifact.setArtifactId(projectArtifact.getArtifactId());
            pomArtifact.setBaseVersion(projectArtifact.getBaseVersion());
            pomArtifact.setSnapshot(projectArtifact.isSnapshot());
            pomArtifact.setType("pom");
            pomArtifact.setExtension("pom");
            pomArtifact.setFile(projectElt.getAttribute("file"));
            Element artifactDeployedEvent = XmlUtils.getArtifactDeployedEvent(artifactDeployedEvents, pomArtifact.getFile());
            if (artifactDeployedEvent == null) {
                pomArtifact.setVersion(projectArtifact.getVersion());
            } else {
                pomArtifact.setVersion(XmlUtils.getUniqueChildElement(artifactDeployedEvent, "artifact").getAttribute("version"));
            }
            result.add(pomArtifact);
            Element artifactElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "artifact");
            MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(artifactElt);
            if (!"pom".equals(mavenArtifact.getType())) {
                Element fileElt = XmlUtils.getUniqueChildElementOrNull(artifactElt, "file");
                if (fileElt == null || fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINE, "listGeneratedArtifacts: Project " + String.valueOf(projectArtifact) + ":  no associated file found for " + String.valueOf(mavenArtifact) + " in " + XmlUtils.toString(artifactElt));
                    }
                } else {
                    mavenArtifact.setFile(fileElt.getTextContent().trim());
                    artifactDeployedEvent = XmlUtils.getArtifactDeployedEvent(artifactDeployedEvents, mavenArtifact.getFile());
                    if (artifactDeployedEvent != null) {
                        mavenArtifact.setVersion(XmlUtils.getUniqueChildElement(artifactDeployedEvent, "artifact").getAttribute("version"));
                        mavenArtifact.setRepositoryUrl(XmlUtils.getUniqueChildElement(artifactDeployedEvent, "repository").getAttribute("url"));
                    }
                }
                result.add(mavenArtifact);
            }
            if (!includeAttachedArtifacts) continue;
            Element attachedArtifactsParentElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "attachedArtifacts");
            List<Element> attachedArtifactsElts = XmlUtils.getChildrenElements(attachedArtifactsParentElt, "artifact");
            for (Element attachedArtifactElt : attachedArtifactsElts) {
                MavenArtifact attachedMavenArtifact = XmlUtils.newMavenArtifact(attachedArtifactElt);
                Element fileElt = XmlUtils.getUniqueChildElementOrNull(attachedArtifactElt, "file");
                if (fileElt == null || fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Project " + String.valueOf(projectArtifact) + ", no associated file found for attached artifact " + String.valueOf(attachedMavenArtifact) + " in " + XmlUtils.toString(attachedArtifactElt));
                    }
                } else {
                    attachedMavenArtifact.setFile(fileElt.getTextContent().trim());
                    Element attachedArtifactDeployedEvent = XmlUtils.getArtifactDeployedEvent(artifactDeployedEvents, attachedMavenArtifact.getFile());
                    if (attachedArtifactDeployedEvent != null) {
                        attachedMavenArtifact.setVersion(XmlUtils.getUniqueChildElement(attachedArtifactDeployedEvent, "artifact").getAttribute("version"));
                        attachedMavenArtifact.setRepositoryUrl(XmlUtils.getUniqueChildElement(attachedArtifactDeployedEvent, "repository").getAttribute("url"));
                    }
                }
                result.add(attachedMavenArtifact);
            }
        }
        return result;
    }

    public static final class RestrictiveEntityResolver
    implements EntityResolver {
        public static final RestrictiveEntityResolver INSTANCE = new RestrictiveEntityResolver();

        private RestrictiveEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            throw new SAXException("Refusing to resolve entity with publicId(" + publicId + ") and systemId (" + systemId + ")");
        }
    }
}

