/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.FilePath;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.TestDataPublisher;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.Messages;
import org.jenkinsci.plugins.pipeline.maven.publishers.JUnitUtils;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.w3c.dom.Element;

public class JunitTestsPublisher
extends MavenPublisher {
    private static final Logger LOGGER = Logger.getLogger(JunitTestsPublisher.class.getName());
    private static final String APACHE_GROUP_ID = "org.apache.maven.plugins";
    private static final String TYCHO_GROUP_ID = "org.eclipse.tycho";
    private static final String KARMA_GROUP_ID = "com.kelveden";
    private static final String FRONTEND_GROUP_ID = "com.github.eirslett";
    private static final String SUREFIRE_ID = "maven-surefire-plugin";
    private static final String FAILSAFE_ID = "maven-failsafe-plugin";
    private static final String TYCHO_ID = "tycho-surefire-plugin";
    private static final String KARMA_ID = "maven-karma-plugin";
    private static final String FRONTEND_ID = "frontend-maven-plugin";
    private static final String SUREFIRE_GOAL = "test";
    private static final String FAILSAFE_GOAL = "integration-test";
    private static final String TYCHO_GOAL = "test";
    private static final String KARMA_GOAL = "start";
    private static final String FRONTEND_GOAL = "karma";
    private static final long serialVersionUID = 1L;
    private boolean keepLongStdio;
    @CheckForNull
    private Double healthScaleFactor;
    private boolean ignoreAttachments;

    @DataBoundConstructor
    public JunitTestsPublisher() {
    }

    @Override
    public void process(@NonNull StepContext context, @NonNull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        try {
            Class.forName("hudson.tasks.junit.JUnitResultArchiver");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] Jenkins ");
            listener.hyperlink("http://wiki.jenkins-ci.org/display/JENKINS/JUnit+Plugin", "JUnit Plugin");
            listener.getLogger().print(" not found, don't display org.apache.maven.plugins:maven-surefire-plugin:test");
            listener.getLogger().println(" nor org.apache.maven.plugins:maven-failsafe-plugin:integration-test results in pipeline screen.");
            return;
        }
        List<Element> sureFireTestEvents = XmlUtils.getExecutionEventsByPlugin(mavenSpyLogsElt, APACHE_GROUP_ID, SUREFIRE_ID, "test", "MojoSucceeded", "MojoFailed");
        List<Element> failSafeTestEvents = XmlUtils.getExecutionEventsByPlugin(mavenSpyLogsElt, APACHE_GROUP_ID, FAILSAFE_ID, FAILSAFE_GOAL, "MojoSucceeded", "MojoFailed");
        List<Element> tychoTestEvents = XmlUtils.getExecutionEventsByPlugin(mavenSpyLogsElt, TYCHO_GROUP_ID, TYCHO_ID, "test", "MojoSucceeded", "MojoFailed");
        List<Element> karmaTestEvents = XmlUtils.getExecutionEventsByPlugin(mavenSpyLogsElt, KARMA_GROUP_ID, KARMA_ID, KARMA_GOAL, "MojoSucceeded", "MojoFailed");
        List<Element> frontendTestEvents = XmlUtils.getExecutionEventsByPlugin(mavenSpyLogsElt, FRONTEND_GROUP_ID, FRONTEND_ID, FRONTEND_GOAL, "MojoSucceeded", "MojoFailed");
        this.executeReporter(context, listener, sureFireTestEvents, "org.apache.maven.plugins:maven-surefire-plugin:test", "reportsDirectory");
        this.executeReporter(context, listener, failSafeTestEvents, "org.apache.maven.plugins:maven-failsafe-plugin:integration-test", "reportsDirectory");
        this.executeReporter(context, listener, tychoTestEvents, "org.apache.maven.plugins:tycho-surefire-plugin:test", "reportsDirectory");
        this.executeReporter(context, listener, karmaTestEvents, "com.kelveden:maven-karma-plugin:start", "reportsDirectory");
        this.executeReporter(context, listener, frontendTestEvents, "com.github.eirslett:frontend-maven-plugin:karma", "environmentVariables", "REPORTS_DIRECTORY");
    }

    private void executeReporter(StepContext context, TaskListener listener, List<Element> testEvents, String goal, String ... reportsDirElementNames) throws IOException, InterruptedException {
        PrintWriter err;
        if (testEvents.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] junitPublisher - No " + goal + " execution found");
            }
            return;
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        String fileSeparatorOnAgent = XmlUtils.getFileSeparatorOnRemote(workspace);
        ArrayList<CallSite> testResultsList = new ArrayList<CallSite>();
        for (Element testEvent : testEvents) {
            Element pluginElt = XmlUtils.getUniqueChildElement(testEvent, "plugin");
            Element reportsDirectoryElt = XmlUtils.getUniqueChildElementOrNull(pluginElt, reportsDirElementNames);
            Element projectElt = XmlUtils.getUniqueChildElement(testEvent, "project");
            MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenSpyLogProcessor.PluginInvocation pluginInvocation = XmlUtils.newPluginInvocation(pluginElt);
            if (reportsDirectoryElt == null) {
                listener.getLogger().println("[withMaven] No <" + Arrays.stream(reportsDirElementNames).collect(Collectors.joining(".")) + "> element found for <plugin> in " + XmlUtils.toString(testEvent));
                continue;
            }
            String reportsDirectory = XmlUtils.resolveMavenPlaceholders(reportsDirectoryElt, projectElt);
            if (reportsDirectory == null) {
                listener.getLogger().println("[withMaven] could not resolve placeholder '${project.build.directory}' or '${basedir}' in " + XmlUtils.toString(testEvent));
                continue;
            }
            reportsDirectory = XmlUtils.getPathInWorkspace(reportsDirectory, workspace);
            String testResults = reportsDirectory + fileSeparatorOnAgent + "*.xml";
            listener.getLogger().println("[withMaven] junitPublisher - Archive test results for Maven artifact " + mavenArtifact.getId() + " generated by " + pluginInvocation.getId() + ": " + testResults);
            if (testResultsList.contains(testResults)) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                listener.getLogger().println("[withMaven] junitPublisher - Ignore already added testResults " + testResults);
                continue;
            }
            testResultsList.add((CallSite)((Object)testResults));
        }
        String testResults = String.join((CharSequence)",", testResultsList);
        JUnitResultArchiver archiver = JUnitUtils.buildArchiver(testResults, this.keepLongStdio, this.healthScaleFactor);
        ArrayList<TestDataPublisher> testDataPublishers = new ArrayList<TestDataPublisher>();
        if (Boolean.TRUE.equals(this.ignoreAttachments)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] junitPublisher - Ignore junit test attachments");
            }
        } else {
            String attachmentsPublisherClassName = "hudson.plugins.junitattachments.AttachmentPublisher";
            try {
                TestDataPublisher attachmentPublisher = (TestDataPublisher)Class.forName(attachmentsPublisherClassName).newInstance();
                if (LOGGER.isLoggable(Level.FINE)) {
                    listener.getLogger().println("[withMaven] junitPublisher - Publish junit test attachments...");
                }
                testDataPublishers.add(attachmentPublisher);
            }
            catch (ClassNotFoundException e) {
                listener.getLogger().print("[withMaven] junitPublisher - Jenkins ");
                listener.hyperlink("https://plugins.jenkins.io/junit-attachments", "JUnit Attachments Plugin");
                listener.getLogger().println(" not found, can't publish test attachments.");
            }
            catch (IllegalAccessException | InstantiationException e) {
                err = listener.error("[withMaven] junitPublisher - Failure to publish test attachments, exception instantiating '" + attachmentsPublisherClassName + "'");
                e.printStackTrace(err);
            }
        }
        String flakyTestDataPublisherClassName = "com.google.jenkins.flakyTestHandler.plugin.JUnitFlakyTestDataPublisher";
        try {
            TestDataPublisher flakyTestPublisher = (TestDataPublisher)Class.forName(flakyTestDataPublisherClassName).newInstance();
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] junitPublisher - Publish JUnit flaky tests reports...");
            }
            testDataPublishers.add(flakyTestPublisher);
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] junitPublisher - Jenkins ");
            listener.hyperlink("https://plugins.jenkins.io/flaky-test-handler", "JUnit Flaky Test Handler Plugin");
            listener.getLogger().println(" not found, can't publish JUnit flaky tests reports.");
        }
        catch (IllegalAccessException | InstantiationException e) {
            err = listener.error("[withMaven] junitPublisher - Failure to publish flaky test reports, exception instantiating '" + flakyTestDataPublisherClassName + "'");
            e.printStackTrace(err);
        }
        if (!testDataPublishers.isEmpty()) {
            archiver.setTestDataPublishers(testDataPublishers);
        }
        JUnitUtils.archiveResults(context, archiver, testResults, "junitPublisher");
    }

    public boolean getIgnoreAttachments() {
        return this.ignoreAttachments;
    }

    @DataBoundSetter
    public void setIgnoreAttachments(boolean ignoreAttachments) {
        this.ignoreAttachments = ignoreAttachments;
    }

    public boolean isKeepLongStdio() {
        return this.keepLongStdio;
    }

    @DataBoundSetter
    public void setKeepLongStdio(boolean keepLongStdio) {
        this.keepLongStdio = keepLongStdio;
    }

    @CheckForNull
    public Double getHealthScaleFactor() {
        return this.healthScaleFactor;
    }

    @DataBoundSetter
    public void setHealthScaleFactor(@Nullable Double healthScaleFactor) {
        this.healthScaleFactor = healthScaleFactor;
    }

    @Override
    public String toString() {
        return "JunitTestsPublisher[disabled=" + this.isDisabled() + ",healthScaleFactor=" + String.valueOf(this.healthScaleFactor == null ? "" : this.healthScaleFactor) + ",keepLongStdio=" + this.keepLongStdio + ",ignoreAttachments=" + this.ignoreAttachments + "]";
    }

    @Symbol(value={"junitPublisher"})
    @OptionalExtension(requirePlugins={"junit"})
    public static class DescriptorImpl
    extends MavenPublisher.DescriptorImpl {
        @NonNull
        public String getDisplayName() {
            return Messages.publisher_junit_tests_description();
        }

        @Override
        public int ordinal() {
            return 10;
        }

        @Override
        @NonNull
        public String getSkipFileName() {
            return ".skip-publish-junit-results";
        }
    }
}

