/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.findbugs.FindBugsPublisher;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.Messages;
import org.jenkinsci.plugins.pipeline.maven.publishers.AbstractHealthAwarePublisher;
import org.jenkinsci.plugins.pipeline.maven.publishers.MavenPipelinePublisherException;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Element;

public class FindbugsAnalysisPublisher
extends AbstractHealthAwarePublisher {
    private static final Logger LOGGER = Logger.getLogger(FindbugsAnalysisPublisher.class.getName());
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public FindbugsAnalysisPublisher() {
    }

    @Override
    public void process(@NonNull StepContext context, @NonNull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        try {
            Class.forName("hudson.plugins.findbugs.FindBugsPublisher");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] Jenkins ");
            listener.hyperlink("https://wiki.jenkins-ci.org/display/JENKINS/FindBugs+Plugin", "FindBugs Plugin");
            listener.getLogger().println(" not found, don't display org.codehaus.mojo:findbugs-maven-plugin:findbugs results in pipeline screen.");
            return;
        }
        List<Element> findbugsEvents = XmlUtils.getExecutionEventsByPlugin(mavenSpyLogsElt, "org.codehaus.mojo", "findbugs-maven-plugin", "findbugs", "MojoSucceeded", "MojoFailed");
        if (findbugsEvents.isEmpty()) {
            LOGGER.log(Level.FINE, "No org.codehaus.mojo:findbugs-maven-plugin:findbugs execution found");
            return;
        }
        for (Element findBugsTestEvent : findbugsEvents) {
            Element pluginElt = XmlUtils.getUniqueChildElement(findBugsTestEvent, "plugin");
            Element xmlOutputDirectoryElt = XmlUtils.getUniqueChildElementOrNull(pluginElt, "xmlOutputDirectory");
            Element projectElt = XmlUtils.getUniqueChildElement(findBugsTestEvent, "project");
            MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenSpyLogProcessor.PluginInvocation pluginInvocation = XmlUtils.newPluginInvocation(pluginElt);
            if (xmlOutputDirectoryElt == null) {
                listener.getLogger().println("[withMaven] No <xmlOutputDirectoryElt> element found for <plugin> in " + XmlUtils.toString(findBugsTestEvent));
                continue;
            }
            String xmlOutputDirectory = XmlUtils.resolveMavenPlaceholders(xmlOutputDirectoryElt, projectElt);
            if (xmlOutputDirectory == null) {
                listener.getLogger().println("[withMaven] could not resolve placeholder '${project.build.directory}' or '${basedir}' in " + XmlUtils.toString(findBugsTestEvent));
                continue;
            }
            xmlOutputDirectory = XmlUtils.getPathInWorkspace(xmlOutputDirectory, workspace);
            String findBugsResultsFile = xmlOutputDirectory + "/findbugsXml.xml";
            listener.getLogger().println("[withMaven] findbugsPublisher - Archive FindBugs analysis results for Maven artifact " + mavenArtifact.toString() + " generated by " + String.valueOf(pluginInvocation) + ": " + findBugsResultsFile);
            FindBugsPublisher findBugsPublisher = new FindBugsPublisher();
            findBugsPublisher.setPattern(findBugsResultsFile);
            this.setHealthAwarePublisherAttributes(findBugsPublisher);
            try {
                findBugsPublisher.perform(run, workspace, launcher, listener);
            }
            catch (Exception e) {
                listener.error("[withMaven] findbugsPublisher - exception archiving FindBugs results for Maven artifact " + mavenArtifact.toString() + " generated by " + String.valueOf(pluginInvocation) + ": " + String.valueOf(e));
                LOGGER.log(Level.WARNING, "Exception processing " + XmlUtils.toString(findBugsTestEvent), e);
                throw new MavenPipelinePublisherException("findbugsPublisher", "archiving FindBugs results for Maven artifact " + mavenArtifact.getId() + " generated by " + pluginInvocation.getId(), e);
            }
        }
    }

    @Symbol(value={"findbugsPublisher"})
    @OptionalExtension(requirePlugins={"findbugs"})
    public static class DescriptorImpl
    extends AbstractHealthAwarePublisher.DescriptorImpl {
        @NonNull
        public String getDisplayName() {
            return Messages.publisher_findbugs_analysis_description();
        }

        @Override
        public int ordinal() {
            return 20;
        }

        @Override
        @NonNull
        public String getSkipFileName() {
            return ".skip-publish-findbugs-results";
        }
    }
}

