/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.console;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.PasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import hudson.util.Secret;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatterns;

public class MaskPasswordsConsoleLogFilter
extends ConsoleLogFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MaskPasswordsConsoleLogFilter.class.getName());
    private final Secret secretsAsRegexp;
    private final String charsetName;

    public MaskPasswordsConsoleLogFilter(@NonNull Collection<String> secrets, @NonNull String charsetName) {
        this.secretsAsRegexp = Secret.fromString((String)SecretPatterns.getAggregateSecretPattern(secrets).toString());
        this.charsetName = charsetName;
    }

    public OutputStream decorateLogger(Run build, OutputStream logger) throws IOException, InterruptedException {
        return new SecretPatterns.MaskingOutputStream(logger, () -> Pattern.compile(this.secretsAsRegexp.getPlainText()), this.charsetName);
    }

    @NonNull
    public static MaskPasswordsConsoleLogFilter newMaskPasswordsConsoleLogFilter(@NonNull Iterable<Credentials> credentials, @NonNull Charset charset) {
        Collection<String> secrets = MaskPasswordsConsoleLogFilter.toString(credentials);
        return new MaskPasswordsConsoleLogFilter(secrets, charset.name());
    }

    @NonNull
    protected static Collection<String> toString(@NonNull Iterable<Credentials> credentials) {
        ArrayList<String> result = new ArrayList<String>();
        for (Credentials creds : credentials) {
            if (creds instanceof UsernamePasswordCredentials) {
                UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)creds;
                if (usernamePasswordCredentials.isUsernameSecret()) {
                    result.add(usernamePasswordCredentials.getUsername());
                }
                result.add(usernamePasswordCredentials.getPassword().getPlainText());
                continue;
            }
            if (creds instanceof PasswordCredentials) {
                PasswordCredentials passwordCredentials = (PasswordCredentials)creds;
                result.add(passwordCredentials.getPassword().getPlainText());
                continue;
            }
            if (creds instanceof SSHUserPrivateKey) {
                SSHUserPrivateKey sshUserPrivateKey = (SSHUserPrivateKey)creds;
                Secret passphrase = sshUserPrivateKey.getPassphrase();
                if (passphrase == null) continue;
                result.add(passphrase.getPlainText());
                continue;
            }
            LOGGER.log(Level.FINE, "Skip masking of unsupported credentials type {0}: {1}", new Object[]{creds.getClass(), creds.getDescriptor().getDisplayName()});
        }
        return result;
    }
}

