/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.Messages;
import org.jenkinsci.plugins.pipeline.maven.publishers.JacocoReportPublisher;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MavenPublisherStrategy {
    IMPLICIT(Messages.publisher_strategy_implicit_description()){

        @Override
        @NonNull
        public List<MavenPublisher> buildPublishersList(@NonNull List<MavenPublisher> configuredPublishers, @NonNull TaskListener listener) {
            List<Object> globallyConfiguredPublishers;
            HashMap<String, MavenPublisher> configuredPublishersById = new HashMap<String, MavenPublisher>();
            for (MavenPublisher mavenPublisher : configuredPublishers) {
                if (mavenPublisher == null) continue;
                configuredPublishersById.put(mavenPublisher.getDescriptor().getId(), mavenPublisher);
            }
            HashMap<String, MavenPublisher> globallyConfiguredPublishersById = new HashMap<String, MavenPublisher>();
            GlobalPipelineMavenConfig globalPipelineMavenConfig = GlobalPipelineMavenConfig.get();
            List<Object> list = globallyConfiguredPublishers = globalPipelineMavenConfig == null ? Collections.emptyList() : globalPipelineMavenConfig.getPublisherOptions();
            if (globallyConfiguredPublishers == null) {
                globallyConfiguredPublishers = Collections.emptyList();
            }
            for (MavenPublisher mavenPublisher : globallyConfiguredPublishers) {
                globallyConfiguredPublishersById.put(mavenPublisher.getDescriptor().getId(), mavenPublisher);
            }
            HashMap<String, MavenPublisher> defaultPublishersById = new HashMap<String, MavenPublisher>();
            DescriptorExtensionList descriptorExtensionList = Jenkins.get().getDescriptorList(MavenPublisher.class);
            for (Descriptor descriptor : descriptorExtensionList) {
                try {
                    if (JacocoReportPublisher.DescriptorImpl.class.isAssignableFrom(descriptor.getClass())) {
                        listener.getLogger().println("[withMaven] JacocoPublisher is no longer implicitly used with `withMaven` step.\n[withMaven] Jacoco plugin has been deprecated and should not be used anymore.\n[withMaven] CoveragePublisher will be used instead.\n");
                        continue;
                    }
                    defaultPublishersById.put(descriptor.getId(), (MavenPublisher)descriptor.clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    PrintWriter error = listener.error("[withMaven] Exception instantiation default config for Maven Publisher '" + descriptor.getDisplayName() + "' / " + descriptor.getId() + ": " + String.valueOf(e));
                    e.printStackTrace(error);
                    error.close();
                    LOGGER.log(Level.WARNING, "Exception instantiating " + String.valueOf(descriptor.clazz) + ": " + String.valueOf(e), e);
                    e.printStackTrace();
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] Maven Publishers with configuration provided by the pipeline: " + String.valueOf(configuredPublishersById.values()));
                listener.getLogger().println("[withMaven] Maven Publishers with configuration defined globally: " + String.valueOf(globallyConfiguredPublishersById.values()));
                listener.getLogger().println("[withMaven] Maven Publishers with default configuration: " + String.valueOf(defaultPublishersById.values()));
            }
            ArrayList<MavenPublisher> results = new ArrayList<MavenPublisher>();
            for (Map.Entry entry : defaultPublishersById.entrySet()) {
                String publisherId = (String)entry.getKey();
                MavenPublisher publisher = this.buildConfiguredMavenPublisher((MavenPublisher)configuredPublishersById.get(publisherId), (MavenPublisher)globallyConfiguredPublishersById.get(publisherId), (MavenPublisher)entry.getValue(), listener);
                results.add(publisher);
            }
            Collections.sort(results);
            return results;
        }
    }
    ,
    EXPLICIT(Messages.publisher_strategy_explicit_description()){

        @Override
        @NonNull
        public List<MavenPublisher> buildPublishersList(@NonNull List<MavenPublisher> configuredPublishers, @NonNull TaskListener listener) {
            ArrayList<MavenPublisher> result = new ArrayList<MavenPublisher>();
            for (MavenPublisher publisher : configuredPublishers) {
                if (publisher == null) continue;
                result.add(publisher);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] Maven Publishers: " + String.valueOf(result));
            }
            return result;
        }
    };

    final String description;
    private static final Logger LOGGER;

    private MavenPublisherStrategy(String description) {
        this.description = description;
    }

    public MavenPublisher buildConfiguredMavenPublisher(@Nullable MavenPublisher pipelinePublisher, @Nullable MavenPublisher globallyConfiguredPublisher, @NonNull MavenPublisher defaultPublisher, @NonNull TaskListener listener) {
        String logMessage;
        MavenPublisher result;
        if (pipelinePublisher == null && globallyConfiguredPublisher == null) {
            result = defaultPublisher;
            logMessage = "default";
        } else if (pipelinePublisher == null && globallyConfiguredPublisher != null) {
            result = globallyConfiguredPublisher;
            logMessage = "globally";
        } else if (pipelinePublisher != null && globallyConfiguredPublisher == null) {
            result = pipelinePublisher;
            logMessage = "pipeline";
        } else if (pipelinePublisher != null && globallyConfiguredPublisher != null) {
            result = pipelinePublisher;
            logMessage = "pipeline";
            listener.getLogger().println("[withMaven] WARNING merging publisher configuration defined in the 'Global Tool Configuration' and at the pipeline level is not yet supported. Use pipeline level configuration for '" + result.getDescriptor().getDisplayName() + "'");
        } else {
            throw new IllegalStateException("Should not happen, workaround for Findbugs NP_NULL_ON_SOME_PATH above");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] Use " + logMessage + " defined publisher for '" + result.getDescriptor().getDisplayName() + "'");
        }
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    @NonNull
    public abstract List<MavenPublisher> buildPublishersList(@NonNull List<MavenPublisher> var1, @NonNull TaskListener var2);

    static {
        LOGGER = Logger.getLogger(MavenPublisherStrategy.class.getName());
    }
}

