/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.service;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCause;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCauseHelper;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.service.ServiceLogger;
import org.jenkinsci.plugins.pipeline.maven.trigger.WorkflowJobDependencyTrigger;

public class PipelineTriggerService {
    private static final Logger LOGGER = Logger.getLogger(PipelineTriggerService.class.getName());
    private final GlobalPipelineMavenConfig globalPipelineMavenConfig;

    public PipelineTriggerService(@NonNull GlobalPipelineMavenConfig globalPipelineMavenConfig) {
        this.globalPipelineMavenConfig = globalPipelineMavenConfig;
    }

    public Collection<String> triggerDownstreamPipelines(@NonNull String groupId, @NonNull String artifactId, @Nullable String baseVersion, @NonNull String version, @NonNull String type, @NonNull MavenDependencyCause cause, @NonNull ServiceLogger logger) {
        MavenArtifact mavenArtifact = new MavenArtifact();
        mavenArtifact.setGroupId(groupId);
        mavenArtifact.setArtifactId(artifactId);
        mavenArtifact.setBaseVersion(baseVersion);
        mavenArtifact.setVersion(version);
        mavenArtifact.setType(type);
        return this.triggerDownstreamPipelines(Collections.singleton(mavenArtifact), cause, logger);
    }

    public Collection<String> triggerDownstreamPipelines(@NonNull Collection<MavenArtifact> upstreamArtifacts, @NonNull MavenDependencyCause cause, @NonNull ServiceLogger logger) {
        if (!(cause instanceof Cause)) {
            throw new IllegalArgumentException("Given cause must extend hudson.model.Cause: " + cause);
        }
        if (cause.getMavenArtifacts() == null) {
            throw new IllegalArgumentException("given cause.mavenArtifacts cannot be null");
        }
        long startTimeInNanos = System.nanoTime();
        HashMap<MavenArtifact, SortedSet> downstreamPipelinesByArtifact = new HashMap<MavenArtifact, SortedSet>();
        for (MavenArtifact mavenArtifact : upstreamArtifacts) {
            PipelineMavenPluginDao dao = this.globalPipelineMavenConfig.getDao();
            SortedSet sortedSet = dao.listDownstreamJobs(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion(), mavenArtifact.getBaseVersion(), mavenArtifact.getType());
            downstreamPipelinesByArtifact.put(mavenArtifact, sortedSet);
        }
        TreeMap<String, Set> jobsToTrigger = new TreeMap<String, Set>();
        HashMap<String, Set> omittedPipelineTriggersByPipelineFullname = new HashMap<String, Set>();
        for (Map.Entry entry : downstreamPipelinesByArtifact.entrySet()) {
            MavenArtifact mavenArtifact = (MavenArtifact)entry.getKey();
            SortedSet downstreamPipelines = (SortedSet)entry.getValue();
            block4: for (String downstreamPipelineFullName : downstreamPipelines) {
                if (jobsToTrigger.containsKey(downstreamPipelineFullName)) {
                    Set mavenArtifacts;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Skip eligibility check of pipeline " + downstreamPipelineFullName + " for artifact " + mavenArtifact.getShortDescription() + ", eligibility already confirmed");
                    }
                    if ((mavenArtifacts = (Set)jobsToTrigger.get(downstreamPipelineFullName)) == null) {
                        logger.log(Level.INFO, "Invalid state, no artifacts found for pipeline '" + downstreamPipelineFullName + "' while evaluating " + mavenArtifact.getShortDescription());
                        continue;
                    }
                    mavenArtifacts.add(mavenArtifact);
                    continue;
                }
                Job downstreamPipeline = (Job)Jenkins.get().getItemByFullName(downstreamPipelineFullName, Job.class);
                if (downstreamPipeline == null || downstreamPipeline.getLastBuild() == null) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "Downstream pipeline " + downstreamPipelineFullName + " or downstream pipeline last build not found. Database synchronization issue or security restriction?");
                    continue;
                }
                int downstreamBuildNumber = downstreamPipeline.getLastBuild().getNumber();
                Map transitiveUpstreamPipelines = this.globalPipelineMavenConfig.getDao().listTransitiveUpstreamJobs(downstreamPipelineFullName, downstreamBuildNumber);
                for (String transitiveUpstreamPipelineName : transitiveUpstreamPipelines.keySet()) {
                    Job transitiveUpstreamPipeline = (Job)Jenkins.get().getItemByFullName(transitiveUpstreamPipelineName, Job.class);
                    if (transitiveUpstreamPipeline == null) continue;
                    if (transitiveUpstreamPipeline.isBuilding()) {
                        logger.log(Level.INFO, "Not triggering " + logger.modelHyperlinkNoteEncodeTo((Item)downstreamPipeline) + " because it has a dependency already building: " + logger.modelHyperlinkNoteEncodeTo((Item)transitiveUpstreamPipeline));
                        continue block4;
                    }
                    if (transitiveUpstreamPipeline.isInQueue()) {
                        logger.log(Level.INFO, "Not triggering " + logger.modelHyperlinkNoteEncodeTo((Item)downstreamPipeline) + " because it has a dependency already building or in queue: " + logger.modelHyperlinkNoteEncodeTo((Item)transitiveUpstreamPipeline));
                        continue block4;
                    }
                    if (!downstreamPipelines.contains(transitiveUpstreamPipelineName)) continue;
                    logger.log(Level.INFO, "Not triggering " + logger.modelHyperlinkNoteEncodeTo((Item)downstreamPipeline) + " because it has a dependency on a pipeline that will be triggered by this build: " + logger.modelHyperlinkNoteEncodeTo((Item)transitiveUpstreamPipeline));
                    omittedPipelineTriggersByPipelineFullname.computeIfAbsent(transitiveUpstreamPipelineName, p -> new TreeSet()).add(downstreamPipelineFullName);
                    continue block4;
                }
                if (!downstreamPipeline.isBuildable()) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "Skip triggering of non buildable (" + (String)(downstreamPipeline instanceof ParameterizedJobMixIn.ParameterizedJob ? "disabled: " + ((ParameterizedJobMixIn.ParameterizedJob)downstreamPipeline).isDisabled() + ", " : "") + "isHoldOffBuildUntilSave: " + downstreamPipeline.isHoldOffBuildUntilSave() + ") downstream pipeline " + downstreamPipeline.getFullName());
                    continue;
                }
                WorkflowJobDependencyTrigger workflowJobDependencyTrigger = this.globalPipelineMavenConfig.getPipelineTriggerService().getWorkflowJobDependencyTrigger((ParameterizedJobMixIn.ParameterizedJob)downstreamPipeline);
                if (workflowJobDependencyTrigger == null) {
                    LOGGER.log(Level.FINE, "Skip triggering of downstream pipeline {0}: dependency trigger not configured", new Object[]{downstreamPipeline.getFullName()});
                    continue;
                }
                boolean downstreamVisibleByUpstreamBuildAuth = this.globalPipelineMavenConfig.getPipelineTriggerService().isDownstreamVisibleByUpstreamBuildAuth((Item)downstreamPipeline);
                if (downstreamVisibleByUpstreamBuildAuth) {
                    Set mavenArtifacts = jobsToTrigger.computeIfAbsent(downstreamPipelineFullName, k -> new TreeSet());
                    if (mavenArtifacts.contains(mavenArtifact)) continue;
                    mavenArtifacts.add(mavenArtifact);
                    continue;
                }
                LOGGER.log(Level.FINE, "Skip triggering of {0} by {1}", new Object[]{downstreamPipeline.getFullName(), cause});
            }
        }
        ArrayList<String> triggeredPipelines = new ArrayList<String>();
        block6: for (Map.Entry entry : jobsToTrigger.entrySet()) {
            String downstreamJobFullName = (String)entry.getKey();
            Job downstreamJob = (Job)Jenkins.get().getItemByFullName(downstreamJobFullName, Job.class);
            if (downstreamJob == null) {
                logger.log(Level.INFO, "Illegal state: " + downstreamJobFullName + " not resolved");
                continue;
            }
            Set omittedPipelines = (Set)omittedPipelineTriggersByPipelineFullname.get(downstreamJobFullName);
            if (omittedPipelines == null) {
                omittedPipelines = Collections.emptySet();
            }
            cause.setOmittedPipelineFullNames(new ArrayList<String>(omittedPipelines));
            Run downstreamJobLastBuild = downstreamJob.getLastBuild();
            if (downstreamJobLastBuild != null) {
                List<MavenArtifact> matchingMavenDependencies = MavenDependencyCauseHelper.isSameCause(cause, downstreamJobLastBuild.getCauses());
                if (matchingMavenDependencies.isEmpty()) {
                    for (Map.Entry entry2 : omittedPipelineTriggersByPipelineFullname.entrySet()) {
                        if (!((Set)entry2.getValue()).contains(downstreamJobFullName)) continue;
                        Job transitiveDownstreamJob = (Job)Jenkins.get().getItemByFullName((String)entry.getKey(), Job.class);
                        logger.log(Level.INFO, "[withMaven] downstreamPipelineTriggerRunListener - Skip triggering downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + "because it will be triggered by transitive downstream " + transitiveDownstreamJob);
                        continue block6;
                    }
                } else {
                    downstreamJobLastBuild.addAction((Action)new CauseAction((Cause)cause));
                    logger.log(Level.INFO, "Skip scheduling downstream pipeline " + logger.modelHyperlinkNoteEncodeTo((Item)downstreamJob) + " as it was already triggered for Maven dependencies: " + matchingMavenDependencies.stream().map(mavenDependency -> mavenDependency == null ? null : mavenDependency.getShortDescription()).collect(Collectors.joining(", ")));
                    try {
                        downstreamJobLastBuild.save();
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, "Failure to update build " + downstreamJobLastBuild.getFullDisplayName() + ": " + e.toString());
                    }
                    continue;
                }
            }
            Queue.Item queuedItem = ParameterizedJobMixIn.scheduleBuild2((Job)downstreamJob, (int)-1, (Action[])new Action[]{new CauseAction((Cause)cause)});
            String dependenciesMessage = cause.getMavenArtifactsDescription();
            if (queuedItem == null) {
                logger.log(Level.INFO, "Skip triggering downstream pipeline " + logger.modelHyperlinkNoteEncodeTo((Item)downstreamJob) + " due to dependencies on " + dependenciesMessage + ", invocation rejected.");
                continue;
            }
            triggeredPipelines.add(downstreamJobFullName);
            logger.log(Level.FINE, "Triggering downstream pipeline " + logger.modelHyperlinkNoteEncodeTo((Item)downstreamJob) + "#" + downstreamJob.getNextBuildNumber() + " due to dependency on " + dependenciesMessage + " ...");
        }
        long l = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimeInNanos, TimeUnit.NANOSECONDS);
        if (l > TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS) || logger.isLoggable(Level.FINE)) {
            logger.log(Level.INFO, "triggerDownstreamPipelines completed in " + l + " ms");
        }
        return triggeredPipelines;
    }

    public void checkNoInfiniteLoopOfUpstreamCause(@NonNull Run initialBuild) throws IllegalStateException {
        Run currentBuild;
        LinkedList<Run> builds = new LinkedList<Run>(Collections.singleton(initialBuild));
        while ((currentBuild = (Run)builds.poll()) != null) {
            for (Cause cause : currentBuild.getCauses()) {
                Cause.UpstreamCause upstreamCause;
                Run upstreamBuild;
                if (!(cause instanceof Cause.UpstreamCause) || (upstreamBuild = (upstreamCause = (Cause.UpstreamCause)cause).getUpstreamRun()) == null) continue;
                if (Objects.equals(upstreamBuild.getParent().getFullName(), initialBuild.getParent().getFullName())) {
                    throw new IllegalStateException("Infinite loop of job triggers ");
                }
                builds.add(upstreamBuild);
            }
        }
    }

    @Nullable
    public WorkflowJobDependencyTrigger getWorkflowJobDependencyTrigger(@NonNull ParameterizedJobMixIn.ParameterizedJob parameterizedJob) {
        Map triggers = parameterizedJob.getTriggers();
        for (Object trigger : triggers.values()) {
            if (!(trigger instanceof WorkflowJobDependencyTrigger)) continue;
            return (WorkflowJobDependencyTrigger)((Object)trigger);
        }
        if (parameterizedJob.getParent() instanceof ComputedFolder) {
            ComputedFolder multiBranchProject = (ComputedFolder)parameterizedJob.getParent();
            for (Trigger trigger : multiBranchProject.getTriggers().values()) {
                if (!(trigger instanceof WorkflowJobDependencyTrigger)) continue;
                return (WorkflowJobDependencyTrigger)trigger;
            }
            if (multiBranchProject.getParent() instanceof ComputedFolder) {
                ComputedFolder grandParent = (ComputedFolder)multiBranchProject.getParent();
                Map grandParentTriggers = grandParent.getTriggers();
                for (Trigger trigger : grandParentTriggers.values()) {
                    if (!(trigger instanceof WorkflowJobDependencyTrigger)) continue;
                    return (WorkflowJobDependencyTrigger)trigger;
                }
            }
        }
        return null;
    }

    public boolean isUpstreamBuildVisibleByDownstreamBuildAuth(@NonNull Job<?, ?> upstreamPipeline, @NonNull Job<?, ?> downstreamPipeline) {
        Authentication downstreamPipelineAuth = Tasks.getAuthenticationOf((Queue.Task)((Queue.FlyweightTask)downstreamPipeline));
        try (ACLContext ignored = ACL.as((Authentication)downstreamPipelineAuth);){
            boolean result;
            Job upstreamPipelineObtainedAsImpersonated = this.getItemByFullName(upstreamPipeline.getFullName(), Job.class);
            boolean bl = result = upstreamPipelineObtainedAsImpersonated != null;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "isUpstreamBuildVisibleByDownstreamBuildAuth(upstreamPipeline: {0}, downstreamPipeline: {1}): downstreamPipelineAuth: {2}, upstreamPipelineObtainedAsImpersonated:{3}, result: {4}", new Object[]{upstreamPipeline.getFullName(), downstreamPipeline.getFullName(), downstreamPipelineAuth, upstreamPipelineObtainedAsImpersonated, result});
            }
            boolean bl2 = result;
            return bl2;
        }
    }

    public boolean isDownstreamVisibleByUpstreamBuildAuth(@NonNull Item downstreamPipeline) {
        boolean result = this.getItemByFullName(downstreamPipeline.getFullName(), Job.class) != null;
        LOGGER.log(Level.FINE, "isDownstreamVisibleByUpstreamBuildAuth({0}, auth: {1}): {2}", new Object[]{downstreamPipeline, Jenkins.getAuthentication(), result});
        return result;
    }

    @CheckForNull
    <T extends Item> T getItemByFullName(String fullName, Class<T> type) throws AccessDeniedException {
        return (T)Jenkins.get().getItemByFullName(fullName, type);
    }
}

