/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import jenkins.model.ArtifactManager;
import jenkins.util.BuildListenerAdapter;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class JenkinsMavenEventSpyLogsPublisher
implements Serializable {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(@NonNull StepContext context, @NonNull FilePath mavenSpyLogs) throws IOException, InterruptedException {
        Run run = (Run)context.get(Run.class);
        ArtifactManager artifactManager = run.pickArtifactManager();
        Launcher launcher = (Launcher)context.get(Launcher.class);
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        FilePath workspace = (FilePath)context.get(FilePath.class);
        FilePath tmpFile = new FilePath(workspace, "." + mavenSpyLogs.getName());
        try {
            mavenSpyLogs.copyTo(tmpFile);
            listener.getLogger().println("[withMaven] Archive " + mavenSpyLogs.getRemote() + " as " + mavenSpyLogs.getName());
            Map<String, String> mavenBuildLogs = Collections.singletonMap(mavenSpyLogs.getName(), tmpFile.getName());
            artifactManager.archive(workspace, launcher, (BuildListener)new BuildListenerAdapter(listener), mavenBuildLogs);
        }
        catch (Exception e) {
            PrintWriter errorWriter = listener.error("[withMaven] WARNING Exception archiving Maven build logs " + mavenSpyLogs + ", skip file. ");
            e.printStackTrace(errorWriter);
        }
        finally {
            boolean deleted = tmpFile.delete();
            if (!deleted) {
                listener.error("[withMaven] WARNING Failure to delete temporary file " + tmpFile);
            }
        }
    }
}

