/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.jgiven.JgivenReportGenerator;
import org.jenkinsci.plugins.pipeline.maven.MavenDependency;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.Messages;
import org.jenkinsci.plugins.pipeline.maven.publishers.DependenciesLister;
import org.jenkinsci.plugins.pipeline.maven.publishers.MavenPipelinePublisherException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Element;

public class JGivenTestsPublisher
extends MavenPublisher {
    public static final String REPORTS_DIR = "jgiven-reports";
    private static final Logger LOGGER = Logger.getLogger(JGivenTestsPublisher.class.getName());
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public JGivenTestsPublisher() {
    }

    @Override
    public void process(@NonNull StepContext context, @NonNull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        try {
            Class.forName("org.jenkinsci.plugins.jgiven.JgivenReportGenerator");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] jgivenPublisher - Jenkins ");
            listener.hyperlink("https://wiki.jenkins.io/display/JENKINS/JGiven+Plugin", "JGiven Plugin");
            listener.getLogger().println(" not found, do not archive jgiven reports.");
            return;
        }
        boolean foundJGivenDependency = false;
        List<MavenDependency> dependencies = DependenciesLister.listDependencies(mavenSpyLogsElt, LOGGER);
        for (MavenDependency dependency : dependencies) {
            if (!dependency.getArtifactId().contains("jgiven")) continue;
            foundJGivenDependency = true;
            break;
        }
        if (!foundJGivenDependency) {
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] jgivenPublisher - JGiven not found within your project dependencies, aborting.");
            }
            return;
        }
        String pattern = "**/jgiven-reports/*";
        FilePath[] paths = workspace.list("**/jgiven-reports/*");
        if (paths == null || paths.length == 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] jgivenPublisher - Pattern \"**/jgiven-reports/*\" does not match any file on workspace, aborting.");
            }
            return;
        }
        JgivenReportGenerator generator = new JgivenReportGenerator(new ArrayList());
        try {
            listener.getLogger().println("[withMaven] jgivenPublisher - Running JGiven report generator");
            generator.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            listener.error("[withMaven] jgivenPublisher - exception archiving JGiven reports: " + e);
            LOGGER.log(Level.WARNING, "Exception processing JGiven reports archiving", e);
            throw new MavenPipelinePublisherException("jgivenPublisher", "archiving JGiven reports", e);
        }
    }

    @Symbol(value={"jgivenPublisher"})
    @Extension
    public static class DescriptorImpl
    extends MavenPublisher.DescriptorImpl {
        @NonNull
        public String getDisplayName() {
            return Messages.publisher_jgiven_tests_description();
        }

        @Override
        public int ordinal() {
            return 20;
        }

        @Override
        @NonNull
        public String getSkipFileName() {
            return ".skip-publish-jgiven-results";
        }
    }
}

