/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.listeners;

import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;

public abstract class AbstractWorkflowRunListener
extends RunListener<Run<?, ?>> {
    protected boolean shouldRun(Run<?, ?> run, TaskListener listener) {
        if (!(run instanceof FlowExecutionOwner.Executable)) {
            return false;
        }
        return Optional.ofNullable(((FlowExecutionOwner.Executable)run).asFlowExecutionOwner()).map(owner -> {
            try {
                return owner.get();
            }
            catch (Exception ex) {
                listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Failure to introspect build steps: " + ex.toString());
                return null;
            }
        }).map(execution -> {
            DepthFirstScanner scanner = new DepthFirstScanner();
            return scanner.setup((Collection)execution.getCurrentHeads()) ? scanner : null;
        }).map(scanner -> scanner.spliterator()).map(iterator -> StreamSupport.stream(iterator, false)).flatMap(stream -> stream.filter(n -> "withMaven".equals(n.getDisplayFunctionName())).findAny()).isPresent();
    }
}

