/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import com.google.common.collect.ImmutableSet;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.JDK;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Maven;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.mvn.GlobalMavenConfig;
import jenkins.mvn.SettingsProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.maven.GlobalMavenSettingsConfig;
import org.jenkinsci.plugins.configfiles.maven.MavenSettingsConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisherStrategy;
import org.jenkinsci.plugins.pipeline.maven.Messages;
import org.jenkinsci.plugins.pipeline.maven.WithMavenStepExecution2;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WithMavenStep
extends Step {
    private String tempBinDir = "";
    private String mavenSettingsConfig;
    private String mavenSettingsFilePath = "";
    private String globalMavenSettingsConfig;
    private String globalMavenSettingsFilePath = "";
    private String maven;
    private String mavenOpts = "";
    private String jdk;
    private String mavenLocalRepo = "";
    private List<MavenPublisher> options = new ArrayList<MavenPublisher>();
    private MavenPublisherStrategy publisherStrategy = MavenPublisherStrategy.IMPLICIT;
    private Boolean traceability = null;

    @DataBoundConstructor
    public WithMavenStep() {
    }

    public String getTempBinDir() {
        return this.tempBinDir;
    }

    @DataBoundSetter
    public void setTempBinDir(String tempBinDir) {
        this.tempBinDir = tempBinDir;
    }

    public String getMavenSettingsConfig() {
        return this.mavenSettingsConfig;
    }

    @DataBoundSetter
    public void setMavenSettingsConfig(String mavenSettingsConfig) {
        this.mavenSettingsConfig = mavenSettingsConfig;
    }

    public String getMavenSettingsFilePath() {
        return this.mavenSettingsFilePath;
    }

    @DataBoundSetter
    public void setMavenSettingsFilePath(String mavenSettingsFilePath) {
        this.mavenSettingsFilePath = mavenSettingsFilePath;
    }

    public String getGlobalMavenSettingsConfig() {
        return this.globalMavenSettingsConfig;
    }

    @DataBoundSetter
    public void setGlobalMavenSettingsConfig(String globalMavenSettingsConfig) {
        this.globalMavenSettingsConfig = globalMavenSettingsConfig;
    }

    public String getGlobalMavenSettingsFilePath() {
        return this.globalMavenSettingsFilePath;
    }

    @DataBoundSetter
    public void setGlobalMavenSettingsFilePath(String globalMavenSettingsFilePath) {
        this.globalMavenSettingsFilePath = globalMavenSettingsFilePath;
    }

    public String getMaven() {
        return this.maven;
    }

    @DataBoundSetter
    public void setMaven(String maven) {
        this.maven = maven;
    }

    public String getMavenOpts() {
        return this.mavenOpts;
    }

    @DataBoundSetter
    public void setMavenOpts(String mavenOpts) {
        this.mavenOpts = mavenOpts;
    }

    public String getJdk() {
        return this.jdk;
    }

    @DataBoundSetter
    public void setJdk(String jdk) {
        this.jdk = jdk;
    }

    public String getMavenLocalRepo() {
        return this.mavenLocalRepo;
    }

    @DataBoundSetter
    public void setMavenLocalRepo(String mavenLocalRepo) {
        this.mavenLocalRepo = mavenLocalRepo;
    }

    public MavenPublisherStrategy getPublisherStrategy() {
        return this.publisherStrategy;
    }

    @DataBoundSetter
    public void setPublisherStrategy(MavenPublisherStrategy publisherStrategy) {
        this.publisherStrategy = publisherStrategy;
    }

    public Boolean isTraceability() {
        return this.traceability;
    }

    @DataBoundSetter
    public void setTraceability(Boolean traceability) {
        this.traceability = traceability;
    }

    public List<MavenPublisher> getOptions() {
        return this.options;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public DescriptorExtensionList<MavenPublisher, MavenPublisher.DescriptorImpl> getOptionsDescriptors() {
        return this.getDescriptor().getOptionsDescriptors();
    }

    @DataBoundSetter
    public void setOptions(List<MavenPublisher> options) {
        this.options = options;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new WithMavenStepExecution2(context, this);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public static final String FUNCTION_NAME = "withMaven";

        public String getFunctionName() {
            return FUNCTION_NAME;
        }

        public String getDisplayName() {
            return Messages.step_with_maven_description();
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class, Launcher.class, EnvVars.class, Run.class);
        }

        @Restricted(value={NoExternalUse.class})
        public SettingsProvider getDefaultSettingsProvider() {
            return GlobalMavenConfig.get().getSettingsProvider();
        }

        private Maven.DescriptorImpl getMavenDescriptor() {
            return (Maven.DescriptorImpl)Jenkins.get().getDescriptorByType(Maven.DescriptorImpl.class);
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillMavenItems(@AncestorInPath Item item) {
            ListBoxModel r = new ListBoxModel();
            if (item == null) {
                return r;
            }
            item.checkPermission(Item.EXTENDED_READ);
            r.add("--- " + Messages.settings_default_maven_description() + " ---", "");
            for (Maven.MavenInstallation installation : this.getMavenDescriptor().getInstallations()) {
                r.add(installation.getName());
            }
            return r;
        }

        private JDK.DescriptorImpl getJDKDescriptor() {
            return (JDK.DescriptorImpl)Jenkins.get().getDescriptorByType(JDK.DescriptorImpl.class);
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillJdkItems(@AncestorInPath Item item) {
            ListBoxModel r = new ListBoxModel();
            if (item == null) {
                return r;
            }
            item.checkPermission(Item.EXTENDED_READ);
            r.add("--- " + Messages.settings_default_jdk_description() + " ---", "");
            for (JDK installation : this.getJDKDescriptor().getInstallations()) {
                r.add(installation.getName());
            }
            return r;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillMavenSettingsConfigItems(@AncestorInPath Item item, @AncestorInPath ItemGroup context) {
            ListBoxModel r = new ListBoxModel();
            if (item == null) {
                return r;
            }
            item.checkPermission(Item.EXTENDED_READ);
            r.add("--- " + Messages.settings_default_settings_description() + " ---", "");
            for (Config config : ConfigFiles.getConfigsInContext((ItemGroup)context, MavenSettingsConfig.MavenSettingsConfigProvider.class)) {
                r.add(config.name, config.id);
            }
            return r;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillGlobalMavenSettingsConfigItems(@AncestorInPath Item item, @AncestorInPath ItemGroup context) {
            ListBoxModel r = new ListBoxModel();
            if (item == null) {
                return r;
            }
            item.checkPermission(Item.EXTENDED_READ);
            r.add("--- " + Messages.settings_default_settings_description() + " ---", "");
            for (Config config : ConfigFiles.getConfigsInContext((ItemGroup)context, GlobalMavenSettingsConfig.GlobalMavenSettingsConfigProvider.class)) {
                r.add(config.name, config.id);
            }
            return r;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillPublisherStrategyItems(@AncestorInPath Item item, @AncestorInPath ItemGroup context) {
            ListBoxModel r = new ListBoxModel();
            if (item == null) {
                return r;
            }
            item.checkPermission(Item.EXTENDED_READ);
            for (MavenPublisherStrategy publisherStrategy : MavenPublisherStrategy.values()) {
                r.add(publisherStrategy.getDescription(), publisherStrategy.name());
            }
            return r;
        }

        public DescriptorExtensionList<MavenPublisher, MavenPublisher.DescriptorImpl> getOptionsDescriptors() {
            return Jenkins.get().getDescriptorList(MavenPublisher.class);
        }
    }
}

