/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.Terminator;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.tools.ToolConfigurationCategory;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginNullDao;
import org.jenkinsci.plugins.pipeline.maven.service.PipelineTriggerService;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension(ordinal=50.0)
@Symbol(value={"pipelineMaven"})
public class GlobalPipelineMavenConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(GlobalPipelineMavenConfig.class.getName());
    private volatile transient PipelineMavenPluginDao dao;
    private transient PipelineTriggerService pipelineTriggerService;
    private boolean globalTraceability = false;
    private boolean triggerDownstreamUponResultSuccess = true;
    private boolean triggerDownstreamUponResultUnstable;
    private boolean triggerDownstreamUponResultFailure;
    private boolean triggerDownstreamUponResultNotBuilt;
    private boolean triggerDownstreamUponResultAborted;
    private String jdbcUrl;
    private String jdbcCredentialsId;
    private String properties;
    private String daoClass;
    private List<MavenPublisher> publisherOptions;

    @DataBoundConstructor
    public GlobalPipelineMavenConfig() {
        this.load();
    }

    public List<PipelineMavenPluginDao> getPipelineMavenPluginDaos() {
        return ExtensionList.lookup(PipelineMavenPluginDao.class);
    }

    public String getDaoClass() {
        return this.daoClass;
    }

    @DataBoundSetter
    public void setDaoClass(String daoClass) {
        this.daoClass = daoClass;
    }

    private Optional<PipelineMavenPluginDao> findDaoFromExtension(String daoClass) {
        return ExtensionList.lookup(PipelineMavenPluginDao.class).stream().filter(pipelineMavenPluginDao -> StringUtils.equals((String)pipelineMavenPluginDao.getClass().getName(), (String)daoClass)).findFirst();
    }

    public ToolConfigurationCategory getCategory() {
        return (ToolConfigurationCategory)GlobalConfigurationCategory.get(ToolConfigurationCategory.class);
    }

    @CheckForNull
    public List<MavenPublisher> getPublisherOptions() {
        return this.publisherOptions;
    }

    @DataBoundSetter
    public void setPublisherOptions(List<MavenPublisher> publisherOptions) {
        this.publisherOptions = publisherOptions;
    }

    public boolean isGlobalTraceability() {
        return this.globalTraceability;
    }

    @DataBoundSetter
    public void setGlobalTraceability(boolean globalTraceability) {
        this.globalTraceability = globalTraceability;
    }

    public boolean isTriggerDownstreamUponResultSuccess() {
        return this.triggerDownstreamUponResultSuccess;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultSuccess(boolean triggerDownstreamUponResultSuccess) {
        this.triggerDownstreamUponResultSuccess = triggerDownstreamUponResultSuccess;
    }

    public boolean isTriggerDownstreamUponResultUnstable() {
        return this.triggerDownstreamUponResultUnstable;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultUnstable(boolean triggerDownstreamUponResultUnstable) {
        this.triggerDownstreamUponResultUnstable = triggerDownstreamUponResultUnstable;
    }

    public boolean isTriggerDownstreamUponResultFailure() {
        return this.triggerDownstreamUponResultFailure;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultFailure(boolean triggerDownstreamUponResultFailure) {
        this.triggerDownstreamUponResultFailure = triggerDownstreamUponResultFailure;
    }

    public boolean isTriggerDownstreamUponResultNotBuilt() {
        return this.triggerDownstreamUponResultNotBuilt;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultNotBuilt(boolean triggerDownstreamUponResultNotBuilt) {
        this.triggerDownstreamUponResultNotBuilt = triggerDownstreamUponResultNotBuilt;
    }

    public boolean isTriggerDownstreamUponResultAborted() {
        return this.triggerDownstreamUponResultAborted;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultAborted(boolean triggerDownstreamUponResultAborted) {
        this.triggerDownstreamUponResultAborted = triggerDownstreamUponResultAborted;
    }

    public synchronized String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @DataBoundSetter
    public synchronized void setJdbcUrl(String jdbcUrl) {
        if (!Objects.equals(jdbcUrl, this.jdbcUrl)) {
            this.closeDatasource();
        }
        this.jdbcUrl = jdbcUrl;
    }

    public synchronized String getJdbcCredentialsId() {
        return this.jdbcCredentialsId;
    }

    public synchronized String getProperties() {
        return this.properties;
    }

    @DataBoundSetter
    public synchronized void setProperties(String properties) {
        if (!Objects.equals(properties, this.properties)) {
            this.closeDatasource();
        }
        this.properties = properties;
    }

    @DataBoundSetter
    public synchronized void setJdbcCredentialsId(String jdbcCredentialsId) {
        if (!Objects.equals(jdbcCredentialsId, this.jdbcCredentialsId)) {
            this.closeDatasource();
        }
        this.jdbcCredentialsId = jdbcCredentialsId;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        if (!StringUtils.equals((String)json.getString("daoClass"), (String)this.daoClass)) {
            this.closeDatasource();
            this.dao = null;
        }
        req.bindJSON((Object)this, json);
        this.publisherOptions = req.bindJSONToList(MavenPublisher.class, json.get("publisherOptions"));
        this.save();
        return true;
    }

    public String getDaoPrettyString() {
        return this.dao != null ? this.dao.toPrettyString() : "Dao Not Ready yet";
    }

    @NonNull
    public synchronized PipelineMavenPluginDao getDao() {
        if (this.dao != null) {
            return this.dao;
        }
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            throw new IllegalStateException("Request to get DAO whilst Jenkins is shutting down or starting up");
        }
        if (j.isTerminating()) {
            throw new IllegalStateException("Request to get DAO whilst Jenkins is terminating");
        }
        Optional<PipelineMavenPluginDao> optionalPipelineMavenPluginDao = this.findDaoFromExtension(this.getDaoClass());
        if (optionalPipelineMavenPluginDao.isPresent()) {
            PipelineMavenPluginDao.Builder.Config config = new PipelineMavenPluginDao.Builder.Config().credentialsId(this.jdbcCredentialsId).jdbcUrl(this.jdbcUrl).properties(this.properties);
            this.dao = optionalPipelineMavenPluginDao.get().getBuilder().build(config);
        } else {
            LOGGER.info("cannot configure any dao so use the default null values one");
            this.dao = new PipelineMavenPluginNullDao();
        }
        return this.dao;
    }

    @NonNull
    public synchronized PipelineTriggerService getPipelineTriggerService() {
        if (this.pipelineTriggerService == null) {
            this.pipelineTriggerService = new PipelineTriggerService(this);
        }
        return this.pipelineTriggerService;
    }

    @NonNull
    public Set<Result> getTriggerDownstreamBuildsResultsCriteria() {
        HashSet<Result> result = new HashSet<Result>(5);
        if (this.triggerDownstreamUponResultSuccess) {
            result.add(Result.SUCCESS);
        }
        if (this.triggerDownstreamUponResultUnstable) {
            result.add(Result.UNSTABLE);
        }
        if (this.triggerDownstreamUponResultAborted) {
            result.add(Result.ABORTED);
        }
        if (this.triggerDownstreamUponResultNotBuilt) {
            result.add(Result.NOT_BUILT);
        }
        if (this.triggerDownstreamUponResultFailure) {
            result.add(Result.FAILURE);
        }
        return result;
    }

    @Nullable
    public static GlobalPipelineMavenConfig get() {
        return (GlobalPipelineMavenConfig)((Object)GlobalConfiguration.all().get(GlobalPipelineMavenConfig.class));
    }

    public ListBoxModel doFillJdbcCredentialsIdItems() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return new StandardListBoxModel().includeEmptyValue().withMatching(CredentialsMatchers.always(), (Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST));
    }

    @POST
    public FormValidation doValidateJdbcConnection(@QueryParameter String jdbcUrl, @QueryParameter String properties, @QueryParameter String jdbcCredentialsId, @QueryParameter String daoClass) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Optional<PipelineMavenPluginDao> optionalPipelineMavenPluginDao = this.findDaoFromExtension(daoClass);
        if (optionalPipelineMavenPluginDao.isEmpty()) {
            return FormValidation.ok((String)"OK");
        }
        if (StringUtils.isBlank((String)jdbcUrl)) {
            jdbcUrl = optionalPipelineMavenPluginDao.get().getDefaultJdbcUrl();
        }
        try {
            PipelineMavenPluginDao.Builder.Config config = new PipelineMavenPluginDao.Builder.Config().credentialsId(jdbcCredentialsId).jdbcUrl(jdbcUrl).properties(properties);
            return optionalPipelineMavenPluginDao.get().getBuilder().validateConfiguration(config);
        }
        catch (Exception e) {
            return FormValidation.error((Throwable)e, (String)e.getMessage());
        }
    }

    @Terminator
    public synchronized void closeDatasource() {
        if (this.dao != null) {
            try {
                this.dao.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Exception closing the DAO", e);
            }
            finally {
                this.dao = null;
            }
        }
    }
}

