/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.service;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Item;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pipeline.maven.service.ServiceLogger;

public class ServiceLoggerImpl
implements ServiceLogger {
    private final Logger logger = Logger.getLogger(ServiceLoggerImpl.class.getName());
    @NonNull
    private final PrintStream stdOut;
    @NonNull
    private final PrintStream stdErr;
    @Nullable
    String prefix;

    public ServiceLoggerImpl(@NonNull PrintStream stdOut, @NonNull PrintStream stdErr, @Nullable String prefix) {
        this.stdOut = stdOut;
        this.stdErr = stdErr;
        this.prefix = prefix;
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    @Override
    public void log(Level level, String message) {
        if (!this.isLoggable(level)) {
            return;
        }
        StringBuilder messageToWrite = new StringBuilder();
        if (this.prefix != null && !this.prefix.isEmpty()) {
            messageToWrite.append(this.prefix).append(" ");
        }
        messageToWrite.append(level).append(" ").append(message);
        this.stdOut.println(messageToWrite.toString());
    }

    @Override
    public String modelHyperlinkNoteEncodeTo(@Nullable Item item) {
        return item == null ? "#null#" : item.getFullDisplayName();
    }
}

