/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenDependency;

public class MavenReport
implements RunAction2,
SimpleBuildStep.LastBuildAction,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = Logger.getLogger(MavenReport.class.getName());
    private transient Run run;
    private transient List<MavenArtifact> generatedArtifacts;

    public MavenReport(@NonNull Run run) {
        this.run = run;
    }

    public synchronized void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public synchronized void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public synchronized Collection<? extends Action> getProjectActions() {
        return this.run.getParent().getLastSuccessfulBuild().getActions(MavenReport.class);
    }

    public synchronized Collection<MavenArtifact> getGeneratedArtifacts() {
        if (this.generatedArtifacts == null) {
            List<MavenArtifact> generatedArtifacts = GlobalPipelineMavenConfig.get().getDao().getGeneratedArtifacts(this.run.getParent().getFullName(), this.run.getNumber());
            if (this.run.getResult() == null) {
                LOGGER.log(Level.FINE, "Load generated artifacts for build {0}#{1} but don't cache them as the build is not finished: {2} entries", new Object[]{this.run.getParent().getName(), this.run.getNumber(), generatedArtifacts.size()});
            } else {
                LOGGER.log(Level.FINE, "Load generated artifacts for build {0}#{1} and cache them: {2}\u00a0entries", new Object[]{this.run.getParent().getName(), this.run.getNumber(), generatedArtifacts.size()});
                this.generatedArtifacts = generatedArtifacts;
            }
            return generatedArtifacts;
        }
        LOGGER.log(Level.FINE, "Use cached generated artifacts for build {0}#{1}: {2}\u00a0entries", new Object[]{this.run.getParent().getName(), this.run.getNumber(), this.generatedArtifacts.size()});
        return this.generatedArtifacts;
    }

    @CheckForNull
    private static Job<?, ?> getJob(String fullName) {
        try {
            return (Job)Jenkins.get().getItemByFullName(fullName, Job.class);
        }
        catch (RuntimeException x) {
            if (x.getClass().getSimpleName().startsWith("AccessDeniedException")) {
                return null;
            }
            throw x;
        }
    }

    public synchronized Collection<Job> getDownstreamJobs() {
        List downstreamJobFullNames = GlobalPipelineMavenConfig.get().getDao().listDownstreamJobsByArtifact(this.run.getParent().getFullName(), this.run.getNumber()).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return downstreamJobFullNames.stream().map(jobFullName -> {
            if (jobFullName == null) {
                return null;
            }
            return MavenReport.getJob(jobFullName);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public synchronized SortedMap<MavenArtifact, Collection<Job>> getDownstreamJobsByArtifact() {
        Map<MavenArtifact, SortedSet<String>> downstreamJobsByArtifact = GlobalPipelineMavenConfig.get().getDao().listDownstreamJobsByArtifact(this.run.getParent().getFullName(), this.run.getNumber());
        TreeMap<MavenArtifact, Collection<Job>> result = new TreeMap<MavenArtifact, Collection<Job>>();
        for (Map.Entry<MavenArtifact, SortedSet<String>> entry : downstreamJobsByArtifact.entrySet()) {
            MavenArtifact mavenArtifact = entry.getKey();
            SortedSet<String> downstreamJobFullNames = entry.getValue();
            result.put(mavenArtifact, downstreamJobFullNames.stream().map(jobFullName -> {
                if (jobFullName == null) {
                    return null;
                }
                return MavenReport.getJob(jobFullName);
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return result;
    }

    public synchronized Collection<Run> getUpstreamBuilds() {
        Map<String, Integer> upstreamJobs = GlobalPipelineMavenConfig.get().getDao().listUpstreamJobs(this.run.getParent().getFullName(), this.run.getNumber());
        return upstreamJobs.entrySet().stream().map(entry -> {
            if (entry == null) {
                return null;
            }
            Job<?, ?> job = MavenReport.getJob((String)entry.getKey());
            if (job == null) {
                return null;
            }
            Run run = job.getBuildByNumber(((Integer)entry.getValue()).intValue());
            return run;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public synchronized Collection<MavenArtifact> getDeployedArtifacts() {
        return this.getGeneratedArtifacts().stream().filter(mavenArtifact -> mavenArtifact != null && mavenArtifact.isDeployed()).collect(Collectors.toList());
    }

    public synchronized Collection<MavenDependency> getDependencies() {
        return GlobalPipelineMavenConfig.get().getDao().listDependencies(this.run.getParent().getFullName(), this.run.getNumber());
    }

    public synchronized Run getRun() {
        return this.run;
    }

    @CheckForNull
    public String getIconFileName() {
        return "/plugin/pipeline-maven/images/24x24/apache-maven.png";
    }

    @CheckForNull
    public String getDisplayName() {
        return "Maven";
    }

    @CheckForNull
    public String getUrlName() {
        return "maven";
    }
}

