/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.FingerprintMap;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Fingerprinter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenDependency;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.publishers.DependenciesLister;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.w3c.dom.Element;

public class DependenciesFingerprintPublisher
extends MavenPublisher {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(DependenciesFingerprintPublisher.class.getName());
    private boolean includeSnapshotVersions = true;
    private boolean includeReleaseVersions;
    private boolean includeScopeCompile = true;
    private boolean includeScopeRuntime = true;
    private boolean includeScopeTest;
    private boolean includeScopeProvided = true;

    @DataBoundConstructor
    public DependenciesFingerprintPublisher() {
    }

    protected Set<String> getIncludedScopes() {
        TreeSet<String> includedScopes = new TreeSet<String>();
        if (this.includeScopeCompile) {
            includedScopes.add("compile");
        }
        if (this.includeScopeRuntime) {
            includedScopes.add("runtime");
        }
        if (this.includeScopeProvided) {
            includedScopes.add("provided");
        }
        if (this.includeScopeTest) {
            includedScopes.add("test");
        }
        return includedScopes;
    }

    @Override
    public void process(@NonNull StepContext context, @NonNull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        Run run = (Run)context.get(Run.class);
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        FilePath workspace = (FilePath)context.get(FilePath.class);
        List<MavenDependency> dependencies = DependenciesLister.listDependencies(mavenSpyLogsElt, LOGGER);
        if (LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] dependenciesFingerprintPublisher - filter: versions[snapshot: " + this.isIncludeSnapshotVersions() + ", release: " + this.isIncludeReleaseVersions() + "], scopes:" + this.getIncludedScopes());
        }
        HashMap<CallSite, String> artifactsToFingerPrint = new HashMap<CallSite, String>();
        for (MavenDependency mavenDependency : dependencies) {
            if (mavenDependency.isSnapshot()) {
                if (!this.includeSnapshotVersions) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    listener.getLogger().println("[withMaven] Skip fingerprinting snapshot dependency: " + mavenDependency);
                    continue;
                }
            } else if (!this.includeReleaseVersions) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                listener.getLogger().println("[withMaven] Skip fingerprinting release dependency: " + mavenDependency);
                continue;
            }
            if (!this.getIncludedScopes().contains(mavenDependency.getScope())) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                listener.getLogger().println("[withMaven] Skip fingerprinting dependency with ignored scope: " + mavenDependency);
                continue;
            }
            try {
                if (StringUtils.isEmpty((String)mavenDependency.getFile())) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    listener.getLogger().println("[withMaven] Can't fingerprint maven dependency with no file attached: " + mavenDependency);
                    continue;
                }
                FilePath filePath = new FilePath(workspace, mavenDependency.getFile());
                if (!mavenDependency.getFile().endsWith("." + mavenDependency.getExtension()) && filePath.isDirectory()) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    listener.getLogger().println("[withMaven] Skip fingerprinting of maven dependency of type directory " + mavenDependency);
                    continue;
                }
                String dependencyMavenRepoStyleFilePath = mavenDependency.getGroupId().replace('.', '/') + "/" + mavenDependency.getArtifactId() + "/" + mavenDependency.getBaseVersion() + "/" + mavenDependency.getFileNameWithBaseVersion();
                if (filePath.exists()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        listener.getLogger().println("[withMaven] Fingerprint dependency " + dependencyMavenRepoStyleFilePath);
                    }
                    String artifactDigest = filePath.digest();
                    artifactsToFingerPrint.put((CallSite)((Object)dependencyMavenRepoStyleFilePath), artifactDigest);
                    continue;
                }
                listener.getLogger().println("[withMaven] FAILURE to fingerprint " + dependencyMavenRepoStyleFilePath + ", file not found");
            }
            catch (IOException | RuntimeException exception) {
                listener.error("[withMaven] WARNING: Exception fingerprinting " + mavenDependency + ", skip");
                exception.printStackTrace(listener.getLogger());
                listener.getLogger().flush();
            }
        }
        LOGGER.log(Level.FINER, "Fingerprint {0}", artifactsToFingerPrint);
        FingerprintMap fingerprintMap = Jenkins.get().getFingerprintMap();
        for (Map.Entry entry : artifactsToFingerPrint.entrySet()) {
            String artifactPathInFingerprintZone = (String)entry.getKey();
            String artifactMd5 = (String)entry.getValue();
            fingerprintMap.getOrCreate(null, artifactPathInFingerprintZone, artifactMd5).addFor(run);
        }
        Fingerprinter.FingerprintAction fingerprintAction = (Fingerprinter.FingerprintAction)run.getAction(Fingerprinter.FingerprintAction.class);
        if (fingerprintAction == null) {
            run.addAction((Action)new Fingerprinter.FingerprintAction(run, artifactsToFingerPrint));
        } else {
            fingerprintAction.add(artifactsToFingerPrint);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[disabled=" + this.isDisabled() + ", scopes=" + this.getIncludedScopes() + ", versions={snapshot:" + this.isIncludeSnapshotVersions() + ", release:" + this.isIncludeReleaseVersions() + "}]";
    }

    public boolean isIncludeSnapshotVersions() {
        return this.includeSnapshotVersions;
    }

    @DataBoundSetter
    public void setIncludeSnapshotVersions(boolean includeSnapshotVersions) {
        this.includeSnapshotVersions = includeSnapshotVersions;
    }

    public boolean isIncludeReleaseVersions() {
        return this.includeReleaseVersions;
    }

    @DataBoundSetter
    public void setIncludeReleaseVersions(boolean includeReleaseVersions) {
        this.includeReleaseVersions = includeReleaseVersions;
    }

    public boolean isIncludeScopeCompile() {
        return this.includeScopeCompile;
    }

    @DataBoundSetter
    public void setIncludeScopeCompile(boolean includeScopeCompile) {
        this.includeScopeCompile = includeScopeCompile;
    }

    public boolean isIncludeScopeRuntime() {
        return this.includeScopeRuntime;
    }

    @DataBoundSetter
    public void setIncludeScopeRuntime(boolean includeScopeRuntime) {
        this.includeScopeRuntime = includeScopeRuntime;
    }

    public boolean isIncludeScopeTest() {
        return this.includeScopeTest;
    }

    @DataBoundSetter
    public void setIncludeScopeTest(boolean includeScopeTest) {
        this.includeScopeTest = includeScopeTest;
    }

    public boolean isIncludeScopeProvided() {
        return this.includeScopeProvided;
    }

    @DataBoundSetter
    public void setIncludeScopeProvided(boolean includeScopeProvided) {
        this.includeScopeProvided = includeScopeProvided;
    }

    @Symbol(value={"dependenciesFingerprintPublisher"})
    @Extension
    public static class DescriptorImpl
    extends MavenPublisher.DescriptorImpl {
        @NonNull
        public String getDisplayName() {
            return "Dependencies Fingerprint Publisher";
        }

        @Override
        public int ordinal() {
            return 20;
        }

        @Override
        @NonNull
        public String getSkipFileName() {
            return ".skip-fingerprint-maven-dependencies";
        }
    }
}

