/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.dao;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.jenkinsci.plugins.pipeline.maven.dao.AbstractPipelineMavenPluginDao;
import org.postgresql.util.PSQLState;

public class PipelineMavenPluginPostgreSqlDao
extends AbstractPipelineMavenPluginDao {
    public PipelineMavenPluginPostgreSqlDao(@NonNull DataSource ds) {
        super(ds);
    }

    @Override
    public String getJdbcScheme() {
        return "postgresql";
    }

    @Override
    protected void registerJdbcDriver() {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("PostgreSQL driver 'org.postgresql.Driver' not found. Please install the 'PostgreSQL API Plugin' to install the PostgreSQL driver");
        }
    }

    @Override
    protected String getDatabaseDescription() {
        String string;
        block24: {
            Connection cnn = this.getDataSource().getConnection();
            try {
                DatabaseMetaData metaData = cnn.getMetaData();
                String version = metaData.getDatabaseProductName() + " " + metaData.getDatabaseProductVersion();
                try (Statement stmt = cnn.createStatement();){
                    try (ResultSet rst = stmt.executeQuery("select AURORA_VERSION()");){
                        rst.next();
                        version = version + " / Amazon Aurora " + rst.getString(1);
                    }
                    catch (SQLException e) {
                        if (!PSQLState.UNDEFINED_FUNCTION.getState().equals(e.getSQLState())) {
                            this.LOGGER.log(Level.WARNING, "Exception checking Amazon Aurora version", e);
                        }
                        cnn.rollback();
                    }
                }
                string = version;
                if (cnn == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (cnn != null) {
                        try {
                            cnn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return "#" + e.toString() + "#";
                }
            }
            cnn.close();
        }
        return string;
    }

    @Override
    protected Long getGeneratedPrimaryKey(PreparedStatement stmt, String column) throws SQLException {
        long jobPrimaryKey;
        block7: {
            try (ResultSet rst = stmt.getGeneratedKeys();){
                if (rst.next()) {
                    jobPrimaryKey = rst.getLong(column);
                    break block7;
                }
                throw new IllegalStateException();
            }
        }
        return jobPrimaryKey;
    }

    @Override
    public boolean isEnoughProductionGradeForTheWorkload() {
        return true;
    }
}

