/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.console.ConsoleLogFilter;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.tasks.Maven;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.mvn.DefaultGlobalSettingsProvider;
import jenkins.mvn.DefaultSettingsProvider;
import jenkins.mvn.FilePathGlobalSettingsProvider;
import jenkins.mvn.FilePathSettingsProvider;
import jenkins.mvn.GlobalMavenConfig;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.SettingsProvider;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.maven.GlobalMavenSettingsConfig;
import org.jenkinsci.plugins.configfiles.maven.MavenSettingsConfig;
import org.jenkinsci.plugins.configfiles.maven.job.MvnGlobalSettingsProvider;
import org.jenkinsci.plugins.configfiles.maven.job.MvnSettingsProvider;
import org.jenkinsci.plugins.configfiles.maven.security.CredentialsHelper;
import org.jenkinsci.plugins.configfiles.maven.security.MavenServerIdRequirement;
import org.jenkinsci.plugins.configfiles.maven.security.ServerCredentialMapping;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenConfigFolderOverrideProperty;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisherStrategy;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.WithMavenStep;
import org.jenkinsci.plugins.pipeline.maven.console.MaskPasswordsConsoleLogFilter;
import org.jenkinsci.plugins.pipeline.maven.console.MavenColorizerConsoleLogFilter;
import org.jenkinsci.plugins.pipeline.maven.util.FileUtils;
import org.jenkinsci.plugins.pipeline.maven.util.TaskListenerTraceWrapper;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.springframework.util.ClassUtils;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Contextual fields used only in start(); no onResume needed")
class WithMavenStepExecution2
extends GeneralNonBlockingStepExecution {
    private static final long serialVersionUID = 1L;
    private static final String M2_HOME = "M2_HOME";
    private static final String MAVEN_HOME = "MAVEN_HOME";
    private static final String MAVEN_OPTS = "MAVEN_OPTS";
    private static final String MVN_CMD = "MVN_CMD";
    private static final Logger LOGGER = Logger.getLogger(WithMavenStepExecution2.class.getName());
    private final transient WithMavenStep step;
    private final transient TaskListener listener;
    private final transient FilePath ws;
    private final transient Launcher launcher;
    private final transient EnvVars env;
    private transient EnvVars envOverride;
    private final transient Run<? extends Job<?, ?>, ? extends Run<?, ?>> build;
    private transient Computer computer;
    private transient FilePath tempBinDir;
    private boolean withContainer;
    private transient TaskListenerTraceWrapper console;

    WithMavenStepExecution2(StepContext context, WithMavenStep step) throws Exception {
        super(context);
        this.step = step;
        this.listener = (TaskListener)context.get(TaskListener.class);
        this.ws = (FilePath)context.get(FilePath.class);
        this.launcher = (Launcher)context.get(Launcher.class);
        this.env = (EnvVars)context.get(EnvVars.class);
        this.build = (Run)context.get(Run.class);
    }

    public boolean start() throws Exception {
        this.run(this::doStart);
        return false;
    }

    protected boolean doStart() throws Exception {
        this.envOverride = new EnvVars();
        this.console = new TaskListenerTraceWrapper(this.listener, this.computeTraceability());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Maven: {0}", this.step.getMaven());
            LOGGER.log(Level.FINE, "Jdk: {0}", this.step.getJdk());
            LOGGER.log(Level.FINE, "MavenOpts: {0}", this.step.getMavenOpts());
            LOGGER.log(Level.FINE, "Temporary Binary Directory: {0}", this.step.getTempBinDir());
            LOGGER.log(Level.FINE, "Settings Config: {0}", this.step.getMavenSettingsConfig());
            LOGGER.log(Level.FINE, "Settings FilePath: {0}", this.step.getMavenSettingsFilePath());
            LOGGER.log(Level.FINE, "Global settings Config: {0}", this.step.getGlobalMavenSettingsConfig());
            LOGGER.log(Level.FINE, "Global settings FilePath: {0}", this.step.getGlobalMavenSettingsFilePath());
            LOGGER.log(Level.FINE, "Options: {0}", this.step.getOptions());
            LOGGER.log(Level.FINE, "env.PATH: {0}", this.env.get((Object)"PATH"));
            LOGGER.log(Level.FINE, "ws: {0}", this.ws.getRemote());
        }
        this.console.trace("[withMaven] Options: " + this.step.getOptions());
        ExtensionList availableMavenPublishers = Jenkins.get().getExtensionList(MavenPublisher.class);
        this.console.trace("[withMaven] Available options: " + availableMavenPublishers.stream().map(MavenPublisher::toString).collect(Collectors.joining(",")));
        this.getComputer();
        this.withContainer = this.detectWithContainer();
        if (this.withContainer) {
            this.console.trace("[withMaven] IMPORTANT \"withMaven(){...}\" step running within a Docker container. See ");
            this.console.traceHyperlink("https://github.com/jenkinsci/pipeline-maven-plugin/blob/master/FAQ.adoc#how-to-use-the-pipeline-maven-plugin-with-docker", "Pipeline Maven Plugin FAQ");
            this.console.trace(" in case of problem.");
        }
        this.setupJDK();
        ArrayList<Credentials> credentials = new ArrayList<Credentials>();
        this.setupMaven(credentials);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, this.build + " - Track usage and mask password of credentials " + credentials.stream().map(new CredentialsToPrettyString()).collect(Collectors.joining(",")));
        }
        CredentialsProvider.trackAll(this.build, new ArrayList<Credentials>(credentials));
        ConsoleLogFilter originalFilter = (ConsoleLogFilter)this.getContext().get(ConsoleLogFilter.class);
        MaskPasswordsConsoleLogFilter maskSecretsFilter = MaskPasswordsConsoleLogFilter.newMaskPasswordsConsoleLogFilter(credentials, this.getComputer().getDefaultCharset());
        MavenColorizerConsoleLogFilter mavenColorizerFilter = new MavenColorizerConsoleLogFilter(this.getComputer().getDefaultCharset().name());
        ConsoleLogFilter newFilter = BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)originalFilter, (ConsoleLogFilter)maskSecretsFilter), (ConsoleLogFilter)mavenColorizerFilter);
        EnvironmentExpander envEx = EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(this.envOverride));
        LOGGER.log(Level.FINEST, "envOverride: {0}", this.envOverride);
        this.getContext().newBodyInvoker().withContexts(new Object[]{envEx, newFilter}).withCallback((BodyExecutionCallback)new WithMavenStepExecutionCallBack(this.tempBinDir, this.step.getOptions(), this.step.getPublisherStrategy())).start();
        return false;
    }

    private boolean detectWithContainer() {
        Launcher launcher1 = this.launcher;
        while (launcher1 instanceof Launcher.DecoratedLauncher) {
            String launcherClassName = launcher1.getClass().getName();
            if (launcherClassName.contains("org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecDecorator")) {
                LOGGER.log(Level.FINE, "Step running within Kubernetes withContainer(): {1}", launcherClassName);
                return false;
            }
            if (launcherClassName.contains("WithContainerStep")) {
                LOGGER.log(Level.FINE, "Step running within docker.image(): {1}", launcherClassName);
                return true;
            }
            if (launcherClassName.contains("ContainerExecDecorator")) {
                LOGGER.log(Level.FINE, "Step running within docker.image(): {1}", launcherClassName);
                return true;
            }
            launcher1 = ((Launcher.DecoratedLauncher)launcher1).getInner();
        }
        return false;
    }

    private void setupJDK() throws AbortException, IOException, InterruptedException {
        String jdkInstallationName = this.step.getJdk();
        if (StringUtils.isEmpty((String)jdkInstallationName)) {
            this.console.trace("[withMaven] using JDK installation provided by the build agent");
            return;
        }
        if (this.withContainer) {
            LOGGER.log(Level.FINE, "Ignoring JDK installation parameter: {0}", jdkInstallationName);
            this.console.println("WARNING: \"withMaven(){...}\" step running within a container, tool installations are not available see https://issues.jenkins-ci.org/browse/JENKINS-36159. You have specified a JDK installation \"" + jdkInstallationName + "\", which will be ignored.");
            return;
        }
        this.console.trace("[withMaven] using JDK installation " + jdkInstallationName);
        JDK jdk = Jenkins.get().getJDK(jdkInstallationName);
        if (jdk == null) {
            throw new AbortException("Could not find the JDK installation: " + jdkInstallationName + ". Make sure it is configured on the Global Tool Configuration page");
        }
        Node node = this.getComputer().getNode();
        if (node == null) {
            throw new AbortException("Could not obtain the Node for the computer: " + this.getComputer().getName());
        }
        jdk = jdk.forNode(node, this.listener).forEnvironment(this.env);
        jdk.buildEnvVars(this.envOverride);
    }

    private void setupMaven(@NonNull Collection<Credentials> credentials) throws IOException, InterruptedException {
        if (this.step.getTempBinDir() != null && !this.step.getTempBinDir().isEmpty()) {
            String expandedTargetLocation = this.step.getTempBinDir();
            try {
                expandedTargetLocation = TokenMacro.expandAll(this.build, (FilePath)this.ws, (TaskListener)this.listener, (String)expandedTargetLocation);
            }
            catch (MacroEvaluationException e) {
                this.listener.getLogger().println("[ERROR] failed to expand variables in target location '" + expandedTargetLocation + "' : " + e.getMessage());
            }
            this.tempBinDir = new FilePath(this.ws, expandedTargetLocation);
        }
        if (this.tempBinDir == null) {
            this.tempBinDir = WithMavenStepExecution2.tempDir(this.ws).child("withMaven" + Util.getDigestOf((String)UUID.randomUUID().toString()).substring(0, 8));
        }
        this.tempBinDir.mkdirs();
        this.envOverride.put("MVN_CMD_DIR", this.tempBinDir.getRemote());
        String settingsFilePath = this.setupSettingFile(credentials);
        String globalSettingsFilePath = this.setupGlobalSettingFile(credentials);
        String mavenLocalRepo = this.setupMavenLocalRepo();
        FilePath mavenSpyJarPath = this.setupMavenSpy();
        Object javaToolsOptions = this.env.get("JAVA_TOOL_OPTIONS", "");
        if (StringUtils.isNotEmpty((String)javaToolsOptions)) {
            javaToolsOptions = (String)javaToolsOptions + " ";
        }
        javaToolsOptions = (String)javaToolsOptions + "-Dmaven.ext.class.path=\"" + mavenSpyJarPath.getRemote() + "\" -Dorg.jenkinsci.plugins.pipeline.maven.reportsFolder=\"" + this.tempBinDir.getRemote() + "\" ";
        this.envOverride.put("JAVA_TOOL_OPTIONS", (String)javaToolsOptions);
        boolean isUnix = Boolean.TRUE.equals(this.getComputer().isUnix());
        StringBuilder mavenConfig = new StringBuilder();
        mavenConfig.append("--batch-mode ");
        this.ifTraceabilityEnabled(() -> mavenConfig.append("--show-version "));
        if (StringUtils.isNotEmpty((String)settingsFilePath)) {
            if (!isUnix) {
                settingsFilePath = settingsFilePath.replace("%", "%%");
            }
            mavenConfig.append("--settings \"").append(settingsFilePath).append("\" ");
        }
        if (StringUtils.isNotEmpty((String)globalSettingsFilePath)) {
            if (!isUnix) {
                globalSettingsFilePath = globalSettingsFilePath.replace("%", "%%");
            }
            mavenConfig.append("--global-settings \"").append(globalSettingsFilePath).append("\" ");
        }
        if (StringUtils.isNotEmpty((String)mavenLocalRepo)) {
            if (!isUnix) {
                mavenLocalRepo = mavenLocalRepo.replace("%", "%%");
            }
            mavenConfig.append("\"-Dmaven.repo.local=").append(mavenLocalRepo).append("\" ");
        }
        this.envOverride.put("MAVEN_CONFIG", mavenConfig.toString());
        if (StringUtils.isNotEmpty((String)this.step.getMavenOpts())) {
            Object mavenOpts = this.envOverride.expand(this.env.expand(this.step.getMavenOpts()));
            String mavenOpsOriginal = (String)this.env.get((Object)MAVEN_OPTS);
            if (mavenOpsOriginal != null) {
                mavenOpts = (String)mavenOpts + " " + mavenOpsOriginal;
            }
            this.envOverride.put(MAVEN_OPTS, ((String)mavenOpts).replaceAll("[\t\r\n]+", " "));
        }
        String mvnExecPath = this.obtainMavenExec();
        LOGGER.log(Level.FINE, "Using temp dir: {0}", this.tempBinDir.getRemote());
        if (mvnExecPath != null) {
            FilePath mvnExec = new FilePath(this.ws.getChannel(), mvnExecPath);
            String content = this.generateMavenWrapperScriptContent(mvnExec, mavenConfig.toString());
            this.envOverride.put("PATH+MAVEN", this.tempBinDir.getRemote());
            this.createWrapperScript(this.tempBinDir, mvnExec.getName(), content);
        }
    }

    private FilePath setupMavenSpy() throws IOException, InterruptedException {
        InputStream in;
        if (this.tempBinDir == null) {
            throw new IllegalStateException("tempBinDir not defined");
        }
        String MAVEN_SPY_JAR_URL = "org.jenkinsci.plugins.pipeline.maven.mavenSpyJarUrl";
        String mavenSpyJarUrl = System.getProperty("org.jenkinsci.plugins.pipeline.maven.mavenSpyJarUrl");
        if (mavenSpyJarUrl == null) {
            String embeddedMavenSpyJarPath = "META-INF/lib/pipeline-maven-spy.jar";
            LOGGER.log(Level.FINE, "Load embedded maven spy jar '" + embeddedMavenSpyJarPath + "'");
            Class<WithMavenStepExecution2> clazz = WithMavenStepExecution2.class;
            ClassLoader classLoader = clazz.getClassLoader();
            LOGGER.log(Level.FINE, "Load " + embeddedMavenSpyJarPath + " using classloader " + classLoader.getClass() + ": " + classLoader);
            in = classLoader.getResourceAsStream(embeddedMavenSpyJarPath);
            if (in == null) {
                CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                String msg = "Embedded maven spy jar not found at " + embeddedMavenSpyJarPath + " in the pipeline-maven-plugin classpath. Maven Spy Jar URL can be defined with the system property: 'org.jenkinsci.plugins.pipeline.maven.mavenSpyJarUrl'Classloader " + classLoader.getClass() + ": " + classLoader + ". Class " + clazz.getName() + " loaded from " + (Serializable)(codeSource == null ? "#unknown#" : codeSource.getLocation());
                throw new IllegalStateException(msg);
            }
        } else {
            LOGGER.log(Level.FINE, "Load maven spy jar provided by system property 'org.jenkinsci.plugins.pipeline.maven.mavenSpyJarUrl': " + mavenSpyJarUrl);
            in = new URL(mavenSpyJarUrl).openStream();
        }
        FilePath mavenSpyJarFilePath = this.tempBinDir.child("pipeline-maven-spy.jar");
        mavenSpyJarFilePath.copyFrom(in);
        return mavenSpyJarFilePath;
    }

    @Nullable
    private String obtainMavenExec() throws IOException, InterruptedException {
        Object mvnExecPath;
        String mavenHome;
        String mavenInstallationName = this.step.getMaven();
        LOGGER.log(Level.FINE, "Setting up maven: {0}", mavenInstallationName);
        StringBuilder consoleMessage = new StringBuilder("[withMaven]");
        if (StringUtils.isEmpty((String)mavenInstallationName)) {
            consoleMessage.append(" using Maven installation provided by the build agent");
        } else if (this.withContainer) {
            this.console.println("[withMaven] WARNING: Specified Maven '" + mavenInstallationName + "' cannot be installed, will be ignored. Step running within a container, tool installations are not available see https://issues.jenkins-ci.org/browse/JENKINS-36159. ");
            LOGGER.log(Level.FINE, "Running in docker-pipeline, ignore Maven Installation parameter: {0}", mavenInstallationName);
        } else {
            return this.obtainMvnExecutableFromMavenInstallation(mavenInstallationName);
        }
        LOGGER.fine("Searching for Maven through MAVEN_HOME and M2_HOME environment variables...");
        if (this.withContainer) {
            LOGGER.fine("Calling printenv on docker container...");
            mavenHome = this.readFromProcess("printenv", MAVEN_HOME);
            if (mavenHome == null) {
                mavenHome = this.readFromProcess("printenv", M2_HOME);
                if (StringUtils.isNotEmpty((String)mavenHome)) {
                    consoleMessage.append(" with the environment variable M2_HOME=").append(mavenHome);
                }
            } else {
                consoleMessage.append(" with the environment variable MAVEN_HOME=").append(mavenHome);
            }
            if (mavenHome == null) {
                LOGGER.log(Level.FINE, "NO maven installation discovered on docker container through MAVEN_HOME and M2_HOME environment variables");
                mvnExecPath = null;
            } else {
                LOGGER.log(Level.FINE, "Found maven installation on {0}", mavenHome);
                mvnExecPath = mavenHome + "/bin/mvn";
            }
        } else {
            LOGGER.fine("Using computer environment...");
            LOGGER.log(Level.FINE, "Agent env: {0}", this.env);
            mavenHome = (String)this.env.get((Object)MAVEN_HOME);
            if (mavenHome == null) {
                mavenHome = (String)this.env.get((Object)M2_HOME);
                if (StringUtils.isNotEmpty((String)mavenHome)) {
                    consoleMessage.append(" with the environment variable M2_HOME=").append(mavenHome);
                }
            } else {
                consoleMessage.append(" with the environment variable MAVEN_HOME=").append(mavenHome);
            }
            if (mavenHome == null) {
                LOGGER.log(Level.FINE, "NO maven installation discovered on build agent through MAVEN_HOME and M2_HOME environment variables");
                mvnExecPath = null;
            } else {
                LOGGER.log(Level.FINE, "Found maven installation on {0}", mavenHome);
                Maven.MavenInstallation mavenInstallation = new Maven.MavenInstallation("Maven Auto-discovered", mavenHome, null);
                mavenInstallation.buildEnvVars(this.envOverride);
                mvnExecPath = mavenInstallation.getExecutable(this.launcher);
            }
        }
        if (mvnExecPath == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                this.console.trace("[withMaven] No Maven Installation or MAVEN_HOME found, looking for mvn executable by using which/where command");
            }
            if (Boolean.TRUE.equals(this.getComputer().isUnix())) {
                mvnExecPath = this.readFromProcess("/bin/sh", "-c", "which mvn");
            } else {
                mvnExecPath = this.readFromProcess("where", "mvn.cmd");
                if (mvnExecPath == null) {
                    mvnExecPath = this.readFromProcess("where", "mvn.bat");
                }
            }
            if (mvnExecPath == null) {
                boolean isUnix = Boolean.TRUE.equals(this.getComputer().isUnix());
                String mvnwScript = isUnix ? "mvnw" : "mvnw.cmd";
                boolean mvnwScriptExists = this.ws.child(mvnwScript).exists();
                consoleMessage = mvnwScriptExists ? new StringBuilder("[withMaven] Maven installation not specified in the 'withMaven()' step and not found on the build agent but '" + mvnwScript + "' script found in the workspace.") : new StringBuilder("[withMaven] Maven installation not specified in the 'withMaven()' step and not found on the build agent");
            } else {
                consoleMessage.append(" with executable ").append((String)mvnExecPath);
            }
        }
        this.console.trace(consoleMessage.toString());
        LOGGER.log(Level.FINE, "Found exec for maven on: {0}", mvnExecPath);
        return mvnExecPath;
    }

    private String obtainMvnExecutableFromMavenInstallation(String mavenInstallationName) throws IOException, InterruptedException {
        Maven.MavenInstallation mavenInstallation = null;
        for (Maven.MavenInstallation i : WithMavenStepExecution2.getMavenInstallations()) {
            if (!mavenInstallationName.equals(i.getName())) continue;
            mavenInstallation = i;
            LOGGER.log(Level.FINE, "Found maven installation {0} with installation home {1}", new Object[]{mavenInstallation.getName(), mavenInstallation.getHome()});
            break;
        }
        if (mavenInstallation == null) {
            throw new AbortException("Could not find specified Maven installation '" + mavenInstallationName + "'.");
        }
        Node node = this.getComputer().getNode();
        if (node == null) {
            throw new AbortException("Could not obtain the Node for the computer: " + this.getComputer().getName());
        }
        mavenInstallation = mavenInstallation.forNode(node, this.listener).forEnvironment(this.env);
        mavenInstallation.buildEnvVars(this.envOverride);
        this.console.trace("[withMaven] using Maven installation '" + mavenInstallation.getName() + "'");
        return mavenInstallation.getExecutable(this.launcher);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String readFromProcess(String ... args) throws InterruptedException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Launcher.ProcStarter ps = this.launcher.launch();
            Proc p = this.launcher.launch(ps.cmds(args).stdout((OutputStream)baos));
            int exitCode = p.join();
            if (exitCode == 0) {
                String string = baos.toString(this.getComputer().getDefaultCharset().name()).replaceAll("[\t\r\n]+", " ").trim();
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace(this.console.format("Error executing command '%s' : %s%n", Arrays.toString(args), e.getMessage()));
            return null;
        }
    }

    private String generateMavenWrapperScriptContent(@NonNull FilePath mvnExec, @NonNull String mavenConfig) throws AbortException {
        boolean isUnix = Boolean.TRUE.equals(this.getComputer().isUnix());
        StringBuilder script = new StringBuilder();
        if (isUnix) {
            String lineSep = "\n";
            script.append("#!/bin/sh -e").append(lineSep);
            this.ifTraceabilityEnabled(() -> script.append("echo ----- withMaven Wrapper script -----").append(lineSep));
            script.append("\"").append(mvnExec.getRemote()).append("\" ").append(mavenConfig).append(" \"$@\"").append(lineSep);
        } else {
            String lineSep = "\r\n";
            script.append("@echo off").append(lineSep);
            this.ifTraceabilityEnabled(() -> script.append("echo ----- withMaven Wrapper script -----").append(lineSep));
            mavenConfig = mavenConfig.replace("%", "%%");
            script.append("\"").append(mvnExec.getRemote()).append("\" ").append(mavenConfig).append(" %*").append(lineSep);
        }
        LOGGER.log(Level.FINER, "Generated Maven wrapper script: \n{0}", script);
        return script.toString();
    }

    private FilePath createWrapperScript(FilePath tempBinDir, String name, String content) throws IOException, InterruptedException {
        FilePath scriptFile = tempBinDir.child(name);
        this.envOverride.put(MVN_CMD, scriptFile.getRemote());
        scriptFile.write(content, this.getComputer().getDefaultCharset().name());
        scriptFile.chmod(493);
        return scriptFile;
    }

    @Nullable
    private String setupMavenLocalRepo() throws IOException, InterruptedException {
        String expandedMavenLocalRepo;
        if (StringUtils.isEmpty((String)this.step.getMavenLocalRepo())) {
            expandedMavenLocalRepo = null;
        } else {
            String expandedPath = this.envOverride.expand(this.env.expand(this.step.getMavenLocalRepo()));
            if (FileUtils.isAbsolutePath(expandedPath)) {
                expandedMavenLocalRepo = expandedPath;
            } else {
                FilePath repoPath = new FilePath(this.ws, expandedPath);
                repoPath.mkdirs();
                expandedMavenLocalRepo = repoPath.getRemote();
            }
        }
        LOGGER.log(Level.FINEST, "setupMavenLocalRepo({0}): {1}", new Object[]{this.step.getMavenLocalRepo(), expandedMavenLocalRepo});
        return expandedMavenLocalRepo;
    }

    @Nullable
    private String setupSettingFile(@NonNull Collection<Credentials> credentials) throws IOException, InterruptedException {
        SettingsProvider settingsProvider;
        FilePath settingsDest = this.tempBinDir.child("settings.xml");
        if (StringUtils.isNotEmpty((String)this.step.getMavenSettingsConfig())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                this.console.formatTrace("[withMaven] using Maven settings provided by the Jenkins Managed Configuration File '%s' %n", this.step.getMavenSettingsConfig());
            }
            this.settingsFromConfig(this.step.getMavenSettingsConfig(), settingsDest, credentials);
            this.envOverride.put("MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        if (StringUtils.isNotEmpty((String)this.step.getMavenSettingsFilePath())) {
            String settingsPath = this.step.getMavenSettingsFilePath();
            FilePath settings = this.ws.child(settingsPath);
            if (settings.exists()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    this.console.formatTrace("[withMaven] using Maven settings provided on the build agent '%s' %n", settingsPath);
                    LOGGER.log(Level.FINE, "Copying maven settings file from build agent {0} to {1}", new Object[]{settings, settingsDest});
                }
                settings.copyTo(settingsDest);
                this.envOverride.put("MVN_SETTINGS", settingsDest.getRemote());
                return settingsDest.getRemote();
            }
            throw new AbortException("Could not find file '" + settings + "' on the build agent");
        }
        MavenConfigFolderOverrideProperty overrideProperty = this.getMavenConfigOverrideProperty();
        StringBuilder mavenSettingsLog = new StringBuilder();
        if (overrideProperty != null && overrideProperty.getSettings() != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                mavenSettingsLog.append("[withMaven] using overridden Maven settings by folder '").append(overrideProperty.getOwner().getDisplayName()).append("'. ");
            }
            settingsProvider = overrideProperty.getSettings();
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                mavenSettingsLog.append("[withMaven] using Maven settings provided by the Jenkins global configuration. ");
            }
            settingsProvider = GlobalMavenConfig.get().getSettingsProvider();
        }
        if (settingsProvider instanceof MvnSettingsProvider) {
            MvnSettingsProvider mvnSettingsProvider = (MvnSettingsProvider)settingsProvider;
            if (LOGGER.isLoggable(Level.FINE)) {
                mavenSettingsLog.append("Config File Provider maven settings file '").append(mvnSettingsProvider.getSettingsConfigId()).append("'");
                this.console.trace(mavenSettingsLog);
            }
            this.settingsFromConfig(mvnSettingsProvider.getSettingsConfigId(), settingsDest, credentials);
            this.envOverride.put("MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        if (settingsProvider instanceof FilePathSettingsProvider) {
            FilePathSettingsProvider filePathSettingsProvider = (FilePathSettingsProvider)settingsProvider;
            String settingsPath = filePathSettingsProvider.getPath();
            FilePath settings = this.ws.child(settingsPath);
            if (settings.exists()) {
                settings.copyTo(settingsDest);
                this.envOverride.put("MVN_SETTINGS", settingsDest.getRemote());
                if (LOGGER.isLoggable(Level.FINE)) {
                    mavenSettingsLog.append("Maven settings on the build agent'").append(settingsPath).append("'");
                    this.console.trace(mavenSettingsLog);
                }
                return settingsDest.getRemote();
            }
            throw new AbortException("Could not find file provided by the Jenkins global configuration '" + settings + "' on the build agent");
        }
        if (settingsProvider instanceof DefaultSettingsProvider) {
            if (LOGGER.isLoggable(Level.FINE)) {
                mavenSettingsLog.append("Maven settings defined by 'DefaultSettingsProvider', NOT overriding it.");
                this.console.trace(mavenSettingsLog);
            }
        } else if (settingsProvider == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                mavenSettingsLog.append("Maven settings are null. NO settings will be defined.");
                this.console.trace(mavenSettingsLog);
            }
        } else {
            this.console.trace("[withMaven] Ignore unsupported Maven SettingsProvider " + settingsProvider);
        }
        return null;
    }

    @CheckForNull
    private MavenConfigFolderOverrideProperty getMavenConfigOverrideProperty() {
        Job job = this.build.getParent();
        ItemGroup group = job.getParent();
        while (group instanceof Item && !(group instanceof Jenkins)) {
            MavenConfigFolderOverrideProperty mavenConfigProperty;
            if (group instanceof AbstractFolder && (mavenConfigProperty = (MavenConfigFolderOverrideProperty)((AbstractFolder)group).getProperties().get(MavenConfigFolderOverrideProperty.class)) != null && mavenConfigProperty.isOverride()) {
                return mavenConfigProperty;
            }
            group = ((Item)group).getParent();
        }
        return null;
    }

    @Nullable
    private String setupGlobalSettingFile(@NonNull Collection<Credentials> credentials) throws IOException, InterruptedException {
        GlobalSettingsProvider globalSettingsProvider;
        FilePath settingsDest = this.tempBinDir.child("globalSettings.xml");
        if (StringUtils.isNotEmpty((String)this.step.getGlobalMavenSettingsConfig())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                this.console.formatTrace("[withMaven] using Maven global settings provided by the Jenkins Managed Configuration File '%s' %n", this.step.getGlobalMavenSettingsConfig());
            }
            this.globalSettingsFromConfig(this.step.getGlobalMavenSettingsConfig(), settingsDest, credentials);
            this.envOverride.put("GLOBAL_MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        if (StringUtils.isNotEmpty((String)this.step.getGlobalMavenSettingsFilePath())) {
            String settingsPath = this.step.getGlobalMavenSettingsFilePath();
            FilePath settings = this.ws.child(settingsPath);
            if (settings.exists()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    this.console.formatTrace("[withMaven] using Maven global settings provided on the build agent '%s' %n", settingsPath);
                    LOGGER.log(Level.FINE, "Copying maven global settings file from build agent {0} to {1}", new Object[]{settings, settingsDest});
                }
                settings.copyTo(settingsDest);
                this.envOverride.put("GLOBAL_MVN_SETTINGS", settingsDest.getRemote());
                return settingsDest.getRemote();
            }
            throw new AbortException("Could not find file '" + settings + "' on the build agent");
        }
        MavenConfigFolderOverrideProperty overrideProperty = this.getMavenConfigOverrideProperty();
        StringBuilder mavenSettingsLog = new StringBuilder();
        if (overrideProperty == null || overrideProperty.getGlobalSettings() == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                mavenSettingsLog.append("[withMaven] using Maven global settings provided by the Jenkins global configuration. ");
            }
            globalSettingsProvider = GlobalMavenConfig.get().getGlobalSettingsProvider();
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                mavenSettingsLog.append("[withMaven] using overridden Maven global settings by folder '").append(overrideProperty.getOwner().getDisplayName()).append("'. ");
            }
            globalSettingsProvider = overrideProperty.getGlobalSettings();
        }
        if (globalSettingsProvider instanceof MvnGlobalSettingsProvider) {
            MvnGlobalSettingsProvider mvnGlobalSettingsProvider = (MvnGlobalSettingsProvider)globalSettingsProvider;
            if (LOGGER.isLoggable(Level.FINE)) {
                mavenSettingsLog.append("Config File Provider maven global settings file '").append(mvnGlobalSettingsProvider.getSettingsConfigId()).append("'");
            }
            this.globalSettingsFromConfig(mvnGlobalSettingsProvider.getSettingsConfigId(), settingsDest, credentials);
            this.envOverride.put("GLOBAL_MVN_SETTINGS", settingsDest.getRemote());
            if (LOGGER.isLoggable(Level.FINE)) {
                this.console.trace(mavenSettingsLog);
            }
            return settingsDest.getRemote();
        }
        if (globalSettingsProvider instanceof FilePathGlobalSettingsProvider) {
            FilePathGlobalSettingsProvider filePathGlobalSettingsProvider = (FilePathGlobalSettingsProvider)globalSettingsProvider;
            String settingsPath = filePathGlobalSettingsProvider.getPath();
            FilePath settings = this.ws.child(settingsPath);
            if (settings.exists()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    mavenSettingsLog.append("Maven global settings on the build agent '").append(settingsPath).append("'");
                }
                settings.copyTo(settingsDest);
                this.envOverride.put("GLOBAL_MVN_SETTINGS", settingsDest.getRemote());
                if (LOGGER.isLoggable(Level.FINE)) {
                    this.console.trace(mavenSettingsLog);
                }
                return settingsDest.getRemote();
            }
            throw new AbortException("Could not find file provided by the Jenkins global configuration '" + settings + "' on the build agent");
        }
        if (globalSettingsProvider instanceof DefaultGlobalSettingsProvider) {
            if (LOGGER.isLoggable(Level.FINE)) {
                mavenSettingsLog.append("Maven global settings defined by 'DefaultSettingsProvider', NOT overriding it.");
                this.console.trace(mavenSettingsLog);
            }
        } else if (globalSettingsProvider == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                mavenSettingsLog.append("Maven global settings are null. NO settings will be defined.");
                this.console.trace(mavenSettingsLog);
            }
        } else {
            this.console.trace("[withMaven] Ignore unsupported Maven GlobalSettingsProvider " + globalSettingsProvider);
        }
        return null;
    }

    private void settingsFromConfig(String mavenSettingsConfigId, FilePath mavenSettingsFile, @NonNull Collection<Credentials> credentials) throws AbortException {
        Config c = ConfigFiles.getByIdOrNull(this.build, (String)mavenSettingsConfigId);
        if (c == null) {
            throw new AbortException("Could not find the Maven settings.xml config file id:" + mavenSettingsConfigId + ". Make sure it exists on Managed Files");
        }
        if (StringUtils.isBlank((String)c.content)) {
            throw new AbortException("Could not create Maven settings.xml config file id:" + mavenSettingsConfigId + ". Content of the file is empty");
        }
        MavenSettingsConfig mavenSettingsConfig = c instanceof MavenSettingsConfig ? (MavenSettingsConfig)c : new MavenSettingsConfig(c.id, c.name, c.comment, c.content, MavenSettingsConfig.isReplaceAllDefault, null);
        try {
            String mavenSettingsFileContent;
            Map<String, StandardUsernameCredentials> resolvedCredentialsByMavenServerId = this.resolveCredentials(mavenSettingsConfig.getServerCredentialMappings(), "Maven settings");
            if (resolvedCredentialsByMavenServerId.isEmpty()) {
                mavenSettingsFileContent = mavenSettingsConfig.content;
                if (LOGGER.isLoggable(Level.FINE)) {
                    this.console.trace("[withMaven] using Maven settings.xml '" + mavenSettingsConfig.id + "' with NO Maven servers credentials provided by Jenkins");
                }
            } else {
                credentials.addAll(resolvedCredentialsByMavenServerId.values());
                ArrayList tempFiles = new ArrayList();
                mavenSettingsFileContent = CredentialsHelper.fillAuthentication((String)mavenSettingsConfig.content, (Boolean)mavenSettingsConfig.isReplaceAll, resolvedCredentialsByMavenServerId, (FilePath)this.tempBinDir, tempFiles);
                if (LOGGER.isLoggable(Level.FINE)) {
                    this.console.trace("[withMaven] using Maven settings.xml '" + mavenSettingsConfig.id + "' with Maven servers credentials provided by Jenkins (replaceAll: " + mavenSettingsConfig.isReplaceAll + "): " + resolvedCredentialsByMavenServerId.entrySet().stream().map(new MavenServerToCredentialsMappingToStringFunction()).sorted().collect(Collectors.joining(", ")));
                }
            }
            mavenSettingsFile.write(mavenSettingsFileContent, this.getComputer().getDefaultCharset().name());
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception injecting Maven settings.xml " + mavenSettingsConfig.id + " during the build: " + this.build + ": " + e.getMessage(), e);
        }
    }

    private void globalSettingsFromConfig(String mavenGlobalSettingsConfigId, FilePath mavenGlobalSettingsFile, Collection<Credentials> credentials) throws AbortException {
        Config c = ConfigFiles.getByIdOrNull(this.build, (String)mavenGlobalSettingsConfigId);
        if (c == null) {
            throw new AbortException("Could not find the Maven global settings.xml config file id:" + mavenGlobalSettingsFile + ". Make sure it exists on Managed Files");
        }
        if (StringUtils.isBlank((String)c.content)) {
            throw new AbortException("Could not create Maven global settings.xml config file id:" + mavenGlobalSettingsFile + ". Content of the file is empty");
        }
        GlobalMavenSettingsConfig mavenGlobalSettingsConfig = c instanceof GlobalMavenSettingsConfig ? (GlobalMavenSettingsConfig)c : new GlobalMavenSettingsConfig(c.id, c.name, c.comment, c.content, MavenSettingsConfig.isReplaceAllDefault, null);
        try {
            String mavenGlobalSettingsFileContent;
            Map<String, StandardUsernameCredentials> resolvedCredentialsByMavenServerId = this.resolveCredentials(mavenGlobalSettingsConfig.getServerCredentialMappings(), " Global Maven settings");
            if (resolvedCredentialsByMavenServerId.isEmpty()) {
                mavenGlobalSettingsFileContent = mavenGlobalSettingsConfig.content;
                this.console.trace("[withMaven] using Maven global settings.xml '" + mavenGlobalSettingsConfig.id + "' with NO Maven servers credentials provided by Jenkins");
            } else {
                credentials.addAll(resolvedCredentialsByMavenServerId.values());
                ArrayList tempFiles = new ArrayList();
                mavenGlobalSettingsFileContent = CredentialsHelper.fillAuthentication((String)mavenGlobalSettingsConfig.content, (Boolean)mavenGlobalSettingsConfig.isReplaceAll, resolvedCredentialsByMavenServerId, (FilePath)this.tempBinDir, tempFiles);
                this.console.trace("[withMaven] using Maven global settings.xml '" + mavenGlobalSettingsConfig.id + "' with Maven servers credentials provided by Jenkins (replaceAll: " + mavenGlobalSettingsConfig.isReplaceAll + "): " + resolvedCredentialsByMavenServerId.entrySet().stream().map(new MavenServerToCredentialsMappingToStringFunction()).sorted().collect(Collectors.joining(", ")));
            }
            mavenGlobalSettingsFile.write(mavenGlobalSettingsFileContent, this.getComputer().getDefaultCharset().name());
            LOGGER.log(Level.FINE, "Created global config file {0}", new Object[]{mavenGlobalSettingsFile});
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception injecting Maven settings.xml " + mavenGlobalSettingsConfig.id + " during the build: " + this.build + ": " + e.getMessage(), e);
        }
    }

    @NonNull
    public Map<String, StandardUsernameCredentials> resolveCredentials(@Nullable List<ServerCredentialMapping> serverCredentialMappings, String logMessagePrefix) {
        HashMap<String, StandardUsernameCredentials> mavenServerIdToCredentials = new HashMap<String, StandardUsernameCredentials>();
        if (serverCredentialMappings == null) {
            return mavenServerIdToCredentials;
        }
        ArrayList<ServerCredentialMapping> unresolvedServerCredentialsMappings = new ArrayList<ServerCredentialMapping>();
        for (ServerCredentialMapping serverCredentialMapping : serverCredentialMappings) {
            List domainRequirements = StringUtils.isBlank((String)serverCredentialMapping.getServerId()) ? Collections.emptyList() : Collections.singletonList(new MavenServerIdRequirement(serverCredentialMapping.getServerId()));
            StandardUsernameCredentials credentials = (StandardUsernameCredentials)CredentialsProvider.findCredentialById((String)serverCredentialMapping.getCredentialsId(), StandardUsernameCredentials.class, this.build, domainRequirements);
            if (credentials == null) {
                unresolvedServerCredentialsMappings.add(serverCredentialMapping);
                continue;
            }
            mavenServerIdToCredentials.put(serverCredentialMapping.getServerId(), credentials);
        }
        if (!unresolvedServerCredentialsMappings.isEmpty()) {
            this.console.println("[withMaven] WARNING " + logMessagePrefix + " - Silently skip Maven server Ids with missing associated Jenkins credentials: " + unresolvedServerCredentialsMappings.stream().map(new ServerCredentialMappingToStringFunction()).collect(Collectors.joining(", ")));
        }
        return mavenServerIdToCredentials;
    }

    private void ifTraceabilityEnabled(Runnable runnable) {
        if (this.computeTraceability()) {
            runnable.run();
        }
    }

    private boolean computeTraceability() {
        return GlobalPipelineMavenConfig.get().isGlobalTraceability() && this.step.isTraceability() == null || Boolean.TRUE.equals(this.step.isTraceability());
    }

    private static Maven.MavenInstallation[] getMavenInstallations() {
        return ((Maven.DescriptorImpl)Jenkins.get().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations();
    }

    @NonNull
    private Computer getComputer() throws AbortException {
        if (this.computer != null) {
            return this.computer;
        }
        String node = null;
        Jenkins j = Jenkins.get();
        for (Computer c : j.getComputers()) {
            if (c.getChannel() != this.launcher.getChannel()) continue;
            node = c.getName();
            break;
        }
        if (node == null) {
            throw new AbortException("Could not find computer for the job");
        }
        this.computer = j.getComputer(node);
        if (this.computer == null) {
            throw new AbortException("No such computer " + node);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Computer: {0}", this.computer.getName());
            try {
                LOGGER.log(Level.FINE, "Env: {0}", this.computer.getEnvironment());
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return this.computer;
    }

    private static FilePath tempDir(FilePath ws) {
        return WorkspaceList.tempDir((FilePath)ws);
    }

    private static class CredentialsToPrettyString
    implements Function<Credentials, String> {
        private CredentialsToPrettyString() {
        }

        @Override
        public String apply(@javax.annotation.Nullable Credentials credentials) {
            if (credentials == null) {
                return "null";
            }
            String result = ClassUtils.getShortName(credentials.getClass()) + "[";
            if (credentials instanceof IdCredentials) {
                IdCredentials idCredentials = (IdCredentials)credentials;
                result = result + "id: " + idCredentials.getId();
            }
            result = result + "]";
            return result;
        }
    }

    private static class MavenServerToCredentialsMappingToStringFunction
    implements Function<Map.Entry<String, StandardUsernameCredentials>, String> {
        private MavenServerToCredentialsMappingToStringFunction() {
        }

        @Override
        public String apply(@Nullable Map.Entry<String, StandardUsernameCredentials> entry) {
            if (entry == null) {
                return null;
            }
            String mavenServerId = entry.getKey();
            StandardUsernameCredentials credentials = entry.getValue();
            return "[mavenServerId: '" + mavenServerId + "', jenkinsCredentials: '" + credentials.getId() + "']";
        }
    }

    private static class ServerCredentialMappingToStringFunction
    implements Function<ServerCredentialMapping, String> {
        private ServerCredentialMappingToStringFunction() {
        }

        @Override
        public String apply(ServerCredentialMapping mapping) {
            return "[mavenServerId: " + mapping.getServerId() + ", jenkinsCredentials: " + mapping.getCredentialsId() + "]";
        }
    }

    private class WithMavenStepExecutionCallBack
    extends GeneralNonBlockingStepExecution.TailCall {
        @Deprecated
        private FilePath tempBinDir;
        private final String tempBinDirPath;
        private final MavenPublisherStrategy mavenPublisherStrategy;
        private final List<MavenPublisher> options;
        private final MavenSpyLogProcessor mavenSpyLogProcessor;
        private static final long serialVersionUID = 1L;

        private WithMavenStepExecutionCallBack(@NonNull FilePath tempBinDir, @NonNull List<MavenPublisher> options, MavenPublisherStrategy mavenPublisherStrategy) {
            super((GeneralNonBlockingStepExecution)WithMavenStepExecution2.this);
            this.mavenSpyLogProcessor = new MavenSpyLogProcessor();
            this.tempBinDirPath = tempBinDir.getRemote();
            this.options = options;
            this.mavenPublisherStrategy = mavenPublisherStrategy;
        }

        protected void finished(StepContext context) throws Exception {
            TaskListener listener = (TaskListener)context.get(TaskListener.class);
            if (this.tempBinDir == null) {
                FilePath ws = (FilePath)context.get(FilePath.class);
                if (ws == null) {
                    listener.getLogger().println("Missing agent to clean up " + this.tempBinDirPath);
                    return;
                }
                this.tempBinDir = ws.child(this.tempBinDirPath);
            }
            this.mavenSpyLogProcessor.processMavenSpyLogs(context, this.tempBinDir, this.options, this.mavenPublisherStrategy);
            try {
                this.tempBinDir.deleteRecursive();
            }
            catch (IOException | InterruptedException e) {
                try {
                    if (e instanceof IOException) {
                        Util.displayIOException((IOException)((IOException)e), (TaskListener)listener);
                    }
                    Functions.printStackTrace((Throwable)e, (PrintWriter)listener.fatalError("Error deleting temporary files"));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> overrides;

        private ExpanderImpl(EnvVars overrides) {
            LOGGER.log(Level.FINEST, "ExpanderImpl(overrides: {0})", new Object[]{overrides});
            this.overrides = new HashMap<String, String>();
            for (Map.Entry entry : overrides.entrySet()) {
                this.overrides.put((String)entry.getKey(), (String)entry.getValue());
            }
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            LOGGER.log(Level.FINEST, "ExpanderImpl.expand - env before expand: {0}", new Object[]{env});
            env.overrideAll(this.overrides);
            LOGGER.log(Level.FINEST, "ExpanderImpl.expand - env after expand: {0}", new Object[]{env});
        }
    }
}

