/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import java.io.IOException;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class NonProductionGradeDatabaseWarningAdministrativeMonitor
extends AdministrativeMonitor {
    public boolean isActivated() {
        String jdbcUrl = GlobalPipelineMavenConfig.get().getJdbcUrl();
        if (jdbcUrl != null && !jdbcUrl.trim().isEmpty()) {
            return jdbcUrl.startsWith("jdbc:h2:");
        }
        if (GlobalPipelineMavenConfig.get().isDaoInitialized()) {
            return !GlobalPipelineMavenConfig.get().getDao().isEnoughProductionGradeForTheWorkload();
        }
        return false;
    }

    public String getDisplayName() {
        return "Pipeline Maven Integration - Non Production Database";
    }

    @RequirePOST
    public void doAct(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.hasParameter("no")) {
            this.disable(true);
            rsp.sendRedirect(req.getContextPath() + "/manage");
        } else {
            rsp.sendRedirect(req.getContextPath() + "/configureTools");
        }
    }
}

