/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;

public enum MavenPublisherStrategy {
    IMPLICIT("Implicit"){

        @Override
        @NonNull
        public List<MavenPublisher> buildPublishersList(@NonNull List<MavenPublisher> configuredPublishers, @NonNull TaskListener listener) {
            List<Object> globallyConfiguredPublishers;
            HashMap<String, MavenPublisher> configuredPublishersById = new HashMap<String, MavenPublisher>();
            for (MavenPublisher mavenPublisher : configuredPublishers) {
                if (mavenPublisher == null) continue;
                configuredPublishersById.put(mavenPublisher.getDescriptor().getId(), mavenPublisher);
            }
            HashMap<String, MavenPublisher> globallyConfiguredPublishersById = new HashMap<String, MavenPublisher>();
            GlobalPipelineMavenConfig globalPipelineMavenConfig = GlobalPipelineMavenConfig.get();
            List<Object> list = globallyConfiguredPublishers = globalPipelineMavenConfig == null ? Collections.emptyList() : globalPipelineMavenConfig.getPublisherOptions();
            if (globallyConfiguredPublishers == null) {
                globallyConfiguredPublishers = Collections.emptyList();
            }
            for (MavenPublisher mavenPublisher : globallyConfiguredPublishers) {
                globallyConfiguredPublishersById.put(mavenPublisher.getDescriptor().getId(), mavenPublisher);
            }
            HashMap<String, MavenPublisher> defaultPublishersById = new HashMap<String, MavenPublisher>();
            DescriptorExtensionList descriptorExtensionList = Jenkins.get().getDescriptorList(MavenPublisher.class);
            for (Descriptor descriptor : descriptorExtensionList) {
                try {
                    defaultPublishersById.put(descriptor.getId(), (MavenPublisher)descriptor.clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    PrintWriter error = listener.error("[withMaven] Exception instantiation default config for Maven Publisher '" + descriptor.getDisplayName() + "' / " + descriptor.getId() + ": " + e);
                    e.printStackTrace(error);
                    error.close();
                    LOGGER.log(Level.WARNING, "Exception instantiating " + descriptor.clazz + ": " + e, e);
                    e.printStackTrace();
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] Maven Publishers with configuration provided by the pipeline: " + configuredPublishersById.values());
                listener.getLogger().println("[withMaven] Maven Publishers with configuration defined globally: " + globallyConfiguredPublishersById.values());
                listener.getLogger().println("[withMaven] Maven Publishers with default configuration: " + defaultPublishersById.values());
            }
            ArrayList<MavenPublisher> results = new ArrayList<MavenPublisher>();
            for (Map.Entry entry : defaultPublishersById.entrySet()) {
                String publisherId = (String)entry.getKey();
                MavenPublisher publisher = this.buildConfiguredMavenPublisher((MavenPublisher)configuredPublishersById.get(publisherId), (MavenPublisher)globallyConfiguredPublishersById.get(publisherId), (MavenPublisher)entry.getValue(), listener);
                results.add(publisher);
            }
            Collections.sort(results);
            return results;
        }
    }
    ,
    EXPLICIT("Explicit"){

        @Override
        @NonNull
        public List<MavenPublisher> buildPublishersList(@NonNull List<MavenPublisher> configuredPublishers, @NonNull TaskListener listener) {
            ArrayList<MavenPublisher> result = new ArrayList<MavenPublisher>();
            for (MavenPublisher publisher : configuredPublishers) {
                if (publisher == null) continue;
                result.add(publisher);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] Maven Publishers: " + result);
            }
            return result;
        }
    };

    final String description;
    private static final Logger LOGGER;

    private MavenPublisherStrategy(String description) {
        this.description = description;
    }

    public MavenPublisher buildConfiguredMavenPublisher(@Nullable MavenPublisher pipelinePublisher, @Nullable MavenPublisher globallyConfiguredPublisher, @NonNull MavenPublisher defaultPublisher, @NonNull TaskListener listener) {
        String logMessage;
        MavenPublisher result;
        if (pipelinePublisher == null && globallyConfiguredPublisher == null) {
            result = defaultPublisher;
            logMessage = "default";
        } else if (pipelinePublisher == null && globallyConfiguredPublisher != null) {
            result = globallyConfiguredPublisher;
            logMessage = "globally";
        } else if (pipelinePublisher != null && globallyConfiguredPublisher == null) {
            result = pipelinePublisher;
            logMessage = "pipeline";
        } else if (pipelinePublisher != null && globallyConfiguredPublisher != null) {
            result = pipelinePublisher;
            logMessage = "pipeline";
            listener.getLogger().println("[withMaven] WARNING merging publisher configuration defined in the 'Global Tool Configuration' and at the pipeline level is not yet supported. Use pipeline level configuration for '" + result.getDescriptor().getDisplayName() + "'");
        } else {
            throw new IllegalStateException("Should not happen, workaround for Findbugs NP_NULL_ON_SOME_PATH above");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] Use " + logMessage + " defined publisher for '" + result.getDescriptor().getDisplayName() + "'");
        }
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    @NonNull
    public abstract List<MavenPublisher> buildPublishersList(@NonNull List<MavenPublisher> var1, @NonNull TaskListener var2);

    static {
        LOGGER = Logger.getLogger(MavenPublisherStrategy.class.getName());
    }
}

