/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.service;

import hudson.model.Item;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.pipeline.maven.service.ServiceLogger;

public class ServiceLoggerImpl
implements ServiceLogger {
    private final Logger logger = Logger.getLogger(ServiceLoggerImpl.class.getName());
    @Nonnull
    private final PrintStream stdOut;
    @Nonnull
    private final PrintStream stdErr;
    @Nullable
    String prefix;

    public ServiceLoggerImpl(@Nonnull PrintStream stdOut, @Nonnull PrintStream stdErr, @Nullable String prefix) {
        this.stdOut = stdOut;
        this.stdErr = stdErr;
        this.prefix = prefix;
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    @Override
    public void log(Level level, String message) {
        if (!this.isLoggable(level)) {
            return;
        }
        StringBuilder messageToWrite = new StringBuilder();
        if (this.prefix != null && !this.prefix.isEmpty()) {
            messageToWrite.append(this.prefix).append(" ");
        }
        messageToWrite.append(level).append(" ").append(message);
        this.stdOut.println(messageToWrite.toString());
    }

    @Override
    public String modelHyperlinkNoteEncodeTo(@Nullable Item item) {
        return item == null ? "#null#" : item.getFullDisplayName();
    }
}

