/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.listeners;

import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyAbstractCause;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCause;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCauseHelper;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyUpstreamCause;
import org.jenkinsci.plugins.pipeline.maven.cause.OtherMavenDependencyCause;
import org.jenkinsci.plugins.pipeline.maven.dao.UpstreamMemory;
import org.jenkinsci.plugins.pipeline.maven.listeners.AbstractWorkflowRunListener;
import org.jenkinsci.plugins.pipeline.maven.listeners.DaoHelper;
import org.jenkinsci.plugins.pipeline.maven.trigger.WorkflowJobDependencyTrigger;

@Extension
public class DownstreamPipelineTriggerRunListener
extends AbstractWorkflowRunListener {
    private static final Logger LOGGER = Logger.getLogger(DownstreamPipelineTriggerRunListener.class.getName());
    @Inject
    public GlobalPipelineMavenConfig globalPipelineMavenConfig;

    public void onCompleted(Run<?, ?> upstreamBuild, @Nonnull TaskListener listener) {
        LOGGER.log(Level.FINER, "onCompleted({0})", new Object[]{upstreamBuild});
        UpstreamMemory upstreamMemory = new UpstreamMemory();
        DaoHelper daoHelper = new DaoHelper(this.globalPipelineMavenConfig);
        if (!this.shouldRun(upstreamBuild, listener)) {
            LOGGER.log(Level.FINE, "Skipping downstream pipeline triggering for {0} as withMaven step not found.", new Object[]{upstreamBuild});
            return;
        }
        long startTimeInNanos = System.nanoTime();
        if (LOGGER.isLoggable(Level.FINER)) {
            listener.getLogger().println("[withMaven] pipelineGraphPublisher - triggerDownstreamPipelines");
        }
        if (!this.globalPipelineMavenConfig.getTriggerDownstreamBuildsResultsCriteria().contains(upstreamBuild.getResult())) {
            HashMap<String, List> omittedPipelineFullNamesAndCauses = new HashMap<String, List>();
            for (Cause cause : upstreamBuild.getCauses()) {
                if (!(cause instanceof MavenDependencyCause)) continue;
                MavenDependencyCause mavenDependencyCause = (MavenDependencyCause)cause;
                for (String string : mavenDependencyCause.getOmittedPipelineFullNames()) {
                    omittedPipelineFullNamesAndCauses.computeIfAbsent(string, p -> new ArrayList()).add(mavenDependencyCause);
                }
            }
            if (omittedPipelineFullNamesAndCauses.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    listener.getLogger().println("[withMaven] Skip triggering downstream jobs for upstream build with ignored result status " + upstreamBuild + ": " + upstreamBuild.getResult());
                }
            } else {
                for (Map.Entry entry : omittedPipelineFullNamesAndCauses.entrySet()) {
                    Job omittedPipeline = (Job)Jenkins.get().getItemByFullName((String)entry.getKey(), Job.class);
                    if (omittedPipeline == null) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Illegal state: " + (String)entry.getKey() + " not resolved");
                        continue;
                    }
                    ArrayList<MavenDependencyCause> omittedPipelineTriggerCauses = new ArrayList<MavenDependencyCause>();
                    for (MavenDependencyCause cause : (List)entry.getValue()) {
                        if (cause instanceof MavenDependencyUpstreamCause) {
                            MavenDependencyUpstreamCause mavenDependencyUpstreamCause = (MavenDependencyUpstreamCause)cause;
                            Run run = mavenDependencyUpstreamCause.getUpstreamRun() == null ? upstreamBuild : mavenDependencyUpstreamCause.getUpstreamRun();
                            omittedPipelineTriggerCauses.add(new MavenDependencyUpstreamCause(run, mavenDependencyUpstreamCause.getMavenArtifacts(), Collections.emptyList()));
                            continue;
                        }
                        if (cause instanceof MavenDependencyAbstractCause) {
                            try {
                                MavenDependencyAbstractCause mavenDependencyCause = ((MavenDependencyAbstractCause)cause).clone();
                                mavenDependencyCause.setOmittedPipelineFullNames(Collections.emptyList());
                                omittedPipelineTriggerCauses.add((MavenDependencyCause)((Cause)mavenDependencyCause));
                            }
                            catch (CloneNotSupportedException e) {
                                listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Failure to clone pipeline cause " + cause + " : " + e);
                                omittedPipelineTriggerCauses.add(new OtherMavenDependencyCause(((MavenDependencyAbstractCause)cause).getShortDescription()));
                            }
                            continue;
                        }
                        omittedPipelineTriggerCauses.add(new OtherMavenDependencyCause(((MavenDependencyAbstractCause)cause).getShortDescription()));
                    }
                    Queue.Item item = ParameterizedJobMixIn.scheduleBuild2((Job)omittedPipeline, (int)-1, (Action[])new Action[]{new CauseAction(omittedPipelineTriggerCauses)});
                    if (item == null) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Failure to trigger omitted pipeline " + ModelHyperlinkNote.encodeTo((Item)omittedPipeline) + " due to causes " + omittedPipelineTriggerCauses + ", invocation rejected.");
                        continue;
                    }
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Triggering downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)omittedPipeline) + " despite build result " + upstreamBuild.getResult() + " for the upstream causes: " + omittedPipelineTriggerCauses.stream().map(Cause::getShortDescription).collect(Collectors.joining(", ")));
                }
            }
            return;
        }
        try {
            this.globalPipelineMavenConfig.getPipelineTriggerService().checkNoInfiniteLoopOfUpstreamCause(upstreamBuild);
        }
        catch (IllegalStateException e) {
            listener.getLogger().println("[withMaven] WARNING abort infinite build trigger loop. Please consider opening a Jira issue: " + e.getMessage());
            return;
        }
        Job upstreamPipeline = upstreamBuild.getParent();
        String upstreamPipelineFullName = upstreamPipeline.getFullName();
        int n = upstreamBuild.getNumber();
        Map<MavenArtifact, SortedSet<String>> downstreamPipelinesByArtifact = this.globalPipelineMavenConfig.getDao().listDownstreamJobsByArtifact(upstreamPipelineFullName, n);
        LOGGER.log(Level.FINER, "got downstreamPipelinesByArtifact for project {0} and build #{1}: {2}", new Object[]{upstreamPipelineFullName, n, downstreamPipelinesByArtifact});
        TreeMap<String, Set> jobsToTrigger = new TreeMap<String, Set>();
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        ArrayList<String> rejectedPipelines = new ArrayList<String>();
        for (Map.Entry<MavenArtifact, SortedSet<String>> entry : downstreamPipelinesByArtifact.entrySet()) {
            MavenArtifact mavenArtifact = entry.getKey();
            SortedSet<String> downstreamPipelines = entry.getValue();
            block11: for (String downstreamPipelineFullName : downstreamPipelines) {
                Run lastSuccessfulBuild;
                Job job;
                if (jobsToTrigger.containsKey(downstreamPipelineFullName)) {
                    Set mavenArtifacts;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip eligibility check of pipeline " + downstreamPipelineFullName + " for artifact " + mavenArtifact.getShortDescription() + ", eligibility already confirmed");
                    }
                    if ((mavenArtifacts = (Set)jobsToTrigger.get(downstreamPipelineFullName)) == null) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Invalid state, no artifacts found for pipeline '" + downstreamPipelineFullName + "' while evaluating " + mavenArtifact.getShortDescription());
                        continue;
                    }
                    mavenArtifacts.add(mavenArtifact);
                    continue;
                }
                if (Objects.equals(downstreamPipelineFullName, upstreamPipelineFullName)) continue;
                if (rejectedPipelines.contains(downstreamPipelineFullName)) {
                    LOGGER.log(Level.FINE, "Downstream pipeline {0} already checked", new Object[]{downstreamPipelineFullName});
                    continue;
                }
                Job downstreamPipeline = (Job)Jenkins.get().getItemByFullName(downstreamPipelineFullName, Job.class);
                if (downstreamPipeline == null || downstreamPipeline.getLastBuild() == null) {
                    LOGGER.log(Level.FINE, "Downstream pipeline {0} or downstream pipeline last build not found from upstream build {1}. Database synchronization issue or security restriction?", new Object[]{downstreamPipelineFullName, upstreamBuild.getFullDisplayName(), Jenkins.getAuthentication()});
                    rejectedPipelines.add(downstreamPipelineFullName);
                    continue;
                }
                int downstreamBuildNumber = downstreamPipeline.getLastBuild().getNumber();
                List<MavenArtifact> downstreamPipelineGeneratedArtifacts = daoHelper.getGeneratedArtifacts(downstreamPipelineFullName, downstreamBuildNumber);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " evaluated for because it has a dependency on " + mavenArtifact + " generates " + downstreamPipelineGeneratedArtifacts);
                }
                Iterator iterator = downstreamPipelineGeneratedArtifacts.iterator();
                while (iterator.hasNext()) {
                    MavenArtifact downstreamPipelineGeneratedArtifact = (MavenArtifact)iterator.next();
                    if (!Objects.equals(mavenArtifact.getGroupId(), downstreamPipelineGeneratedArtifact.getGroupId()) || !Objects.equals(mavenArtifact.getArtifactId(), downstreamPipelineGeneratedArtifact.getArtifactId())) continue;
                    if (!LOGGER.isLoggable(Level.FINE)) continue block11;
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " for " + mavenArtifact + " because it generates artifact with same groupId:artifactId " + downstreamPipelineGeneratedArtifact);
                    continue block11;
                }
                Map<MavenArtifact, SortedSet<String>> map = daoHelper.listDownstreamJobsByArtifact(downstreamPipelineFullName, downstreamBuildNumber);
                for (Map.Entry entry2 : map.entrySet()) {
                    SortedSet downstreamDownstreamPipelines = (SortedSet)entry2.getValue();
                    if (!downstreamDownstreamPipelines.contains(upstreamPipelineFullName)) continue;
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Infinite loop detected: skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + "  (dependency: " + mavenArtifact.getShortDescription() + ") because it is itself triggering this pipeline " + ModelHyperlinkNote.encodeTo((Item)upstreamPipeline) + " (dependency: " + ((MavenArtifact)entry2.getKey()).getShortDescription() + ")");
                    continue block11;
                }
                Map<String, Integer> transitiveUpstreamPipelines = this.globalPipelineMavenConfig.getDao().listTransitiveUpstreamJobs(downstreamPipelineFullName, downstreamBuildNumber, upstreamMemory);
                if (LOGGER.isLoggable(Level.FINER)) {
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Found transitive upstream pipelines for " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + ": " + transitiveUpstreamPipelines.keySet().stream().collect(Collectors.joining(",")));
                }
                if (transitiveUpstreamPipelines != null && transitiveUpstreamPipelines.isEmpty() && (job = (Job)Jenkins.get().getItemByFullName(downstreamPipelineFullName, Job.class)) != null && (lastSuccessfulBuild = job.getLastSuccessfulBuild()) != null) {
                    transitiveUpstreamPipelines = this.globalPipelineMavenConfig.getDao().listTransitiveUpstreamJobs(downstreamPipelineFullName, lastSuccessfulBuild.number, upstreamMemory);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Updated transitive upstream pipelines for " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + ": " + transitiveUpstreamPipelines.keySet().stream().collect(Collectors.joining(",")));
                    }
                }
                for (String transitiveUpstreamPipelineName : transitiveUpstreamPipelines.keySet()) {
                    Job transitiveUpstreamPipeline = (Job)Jenkins.get().getItemByFullName(transitiveUpstreamPipelineName, Job.class);
                    if (transitiveUpstreamPipeline == null) {
                        if (!LOGGER.isLoggable(Level.FINER)) continue;
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " because transitive pipeline " + transitiveUpstreamPipelineName + " is unaccessible");
                        continue;
                    }
                    if (transitiveUpstreamPipeline.getFullName().equals(upstreamPipeline.getFullName())) {
                        if (!LOGGER.isLoggable(Level.FINER)) continue;
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " because transitive pipeline " + transitiveUpstreamPipelineName + " is the current one");
                        continue;
                    }
                    if (transitiveUpstreamPipeline.isBuilding()) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " because it has a dependency already building: " + ModelHyperlinkNote.encodeTo((Item)transitiveUpstreamPipeline));
                        continue block11;
                    }
                    if (this.isInQueue(transitiveUpstreamPipeline)) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " because it has a dependency already building or in queue: " + ModelHyperlinkNote.encodeTo((Item)transitiveUpstreamPipeline));
                        continue block11;
                    }
                    if (!downstreamPipelines.contains(transitiveUpstreamPipelineName)) continue;
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " because it has a dependency on a pipeline that will be triggered by this build: " + ModelHyperlinkNote.encodeTo((Item)transitiveUpstreamPipeline));
                    hashMap.computeIfAbsent(transitiveUpstreamPipelineName, p -> new TreeSet()).add(downstreamPipelineFullName);
                    continue block11;
                }
                listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - checked transitive upstreams for: " + downstreamPipelineFullName + " build: " + downstreamBuildNumber + " result: " + String.join((CharSequence)",", transitiveUpstreamPipelines.keySet()));
                if (!downstreamPipeline.isBuildable()) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering of non buildable (disabled: " + ((ParameterizedJobMixIn.ParameterizedJob)downstreamPipeline).isDisabled() + ", isHoldOffBuildUntilSave: " + downstreamPipeline.isHoldOffBuildUntilSave() + ") downstream pipeline " + downstreamPipeline.getFullName() + " from upstream build " + upstreamBuild.getFullDisplayName());
                    }
                    rejectedPipelines.add(downstreamPipelineFullName);
                    continue;
                }
                WorkflowJobDependencyTrigger workflowJobDependencyTrigger = this.globalPipelineMavenConfig.getPipelineTriggerService().getWorkflowJobDependencyTrigger((ParameterizedJobMixIn.ParameterizedJob)downstreamPipeline);
                if (workflowJobDependencyTrigger == null) {
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering of downstream pipeline " + downstreamPipeline.getFullName() + " from upstream build " + upstreamBuild.getFullDisplayName() + ": dependency trigger not configured");
                    rejectedPipelines.add(downstreamPipelineFullName);
                    continue;
                }
                boolean downstreamVisibleByUpstreamBuildAuth = this.globalPipelineMavenConfig.getPipelineTriggerService().isDownstreamVisibleByUpstreamBuildAuth((Item)downstreamPipeline);
                boolean upstreamVisibleByDownstreamBuildAuth = this.globalPipelineMavenConfig.getPipelineTriggerService().isUpstreamBuildVisibleByDownstreamBuildAuth(upstreamPipeline, downstreamPipeline);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "upstreamPipeline (" + upstreamPipelineFullName + ", visibleByDownstreamBuildAuth: " + upstreamVisibleByDownstreamBuildAuth + "),  downstreamPipeline (" + downstreamPipeline.getFullName() + ", visibleByUpstreamBuildAuth: " + downstreamVisibleByUpstreamBuildAuth + "), upstreamBuildAuth: " + Jenkins.getAuthentication());
                }
                if (downstreamVisibleByUpstreamBuildAuth && upstreamVisibleByDownstreamBuildAuth) {
                    Set mavenArtifactsCausingTheTrigger = jobsToTrigger.computeIfAbsent(downstreamPipelineFullName, k -> new TreeSet());
                    if (mavenArtifactsCausingTheTrigger.contains(mavenArtifact)) continue;
                    mavenArtifactsCausingTheTrigger.add(mavenArtifact);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering of " + downstreamPipeline.getFullName() + " by " + upstreamBuild.getFullDisplayName() + ": downstreamVisibleByUpstreamBuildAuth: " + downstreamVisibleByUpstreamBuildAuth + ", upstreamVisibleByDownstreamBuildAuth: " + upstreamVisibleByDownstreamBuildAuth);
            }
        }
        block15: for (Map.Entry<MavenArtifact, SortedSet<String>> entry : jobsToTrigger.entrySet()) {
            String downstreamJobFullName = (String)((Object)entry.getKey());
            Job downstreamJob = (Job)Jenkins.get().getItemByFullName(downstreamJobFullName, Job.class);
            if (downstreamJob == null) {
                listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Illegal state: " + downstreamJobFullName + " not resolved");
                continue;
            }
            Set mavenArtifacts = entry.getValue();
            MavenDependencyUpstreamCause cause = new MavenDependencyUpstreamCause(upstreamBuild, mavenArtifacts, (Collection)hashMap.get(downstreamJobFullName));
            Run downstreamJobLastBuild = downstreamJob.getLastBuild();
            if (downstreamJobLastBuild != null) {
                List<MavenArtifact> matchingMavenDependencies = MavenDependencyCauseHelper.isSameCause((MavenDependencyCause)cause, downstreamJobLastBuild.getCauses());
                if (matchingMavenDependencies.isEmpty()) {
                    for (Map.Entry entry3 : hashMap.entrySet()) {
                        if (!((Set)entry3.getValue()).contains(downstreamJobFullName)) continue;
                        Job transitiveDownstreamJob = (Job)Jenkins.get().getItemByFullName((String)((Object)entry.getKey()), Job.class);
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + "because it will be triggered by transitive downstream " + ModelHyperlinkNote.encodeTo((Item)transitiveDownstreamJob));
                        continue block15;
                    }
                } else {
                    downstreamJobLastBuild.addAction((Action)new CauseAction((Cause)cause));
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + " as it was already triggered for Maven dependencies: " + matchingMavenDependencies.stream().map(mavenDependency -> mavenDependency == null ? null : mavenDependency.getShortDescription()).collect(Collectors.joining(", ")));
                    try {
                        downstreamJobLastBuild.save();
                    }
                    catch (IOException e) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Failure to update build " + downstreamJobLastBuild.getFullDisplayName() + ": " + e.toString());
                    }
                    continue;
                }
            }
            this.scheduleBuild(downstreamJob, cause, listener);
        }
        long durationInMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimeInNanos, TimeUnit.NANOSECONDS);
        if (durationInMillis > TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS) || LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - completed in " + durationInMillis + " ms");
        }
    }

    private void scheduleBuild(Job downstreamJob, MavenDependencyUpstreamCause cause, TaskListener listener) {
        if (this.isInQueue(downstreamJob)) {
            listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + " because it is already in the queue");
        } else {
            Queue.Item queuedItem = ParameterizedJobMixIn.scheduleBuild2((Job)downstreamJob, (int)-1, (Action[])new Action[]{new CauseAction((Cause)cause)});
            String dependenciesMessage = cause.getMavenArtifactsDescription();
            if (queuedItem == null) {
                listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + " due to dependencies on " + dependenciesMessage + ", invocation rejected.");
            } else {
                listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Triggering downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + "#" + downstreamJob.getNextBuildNumber() + " due to dependency on " + dependenciesMessage + " ...");
            }
        }
    }

    private boolean isInQueue(Job<?, ?> job) {
        return job instanceof Queue.Task && Jenkins.get().getQueue().contains((Queue.Task)job);
    }
}

