/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.db.migration.h2;

import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Run;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.maven.db.migration.MigrationStep;

public class MigrationStep11
implements MigrationStep {
    private static final Logger LOGGER = Logger.getLogger(MigrationStep11.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(@Nonnull Connection cnn, @Nonnull MigrationStep.JenkinsDetails jenkinsDetails) throws SQLException {
        int jobCount = 0;
        int buildCauseCount = 0;
        LOGGER.info("Upgrade table JENKINS_BUILD_UPSTREAM_CAUSE...");
        String select = "select jenkins_job.full_name, jenkins_job.jenkins_master_id, jenkins_build.number, jenkins_build.id  from jenkins_build inner join jenkins_job on jenkins_build.job_id = jenkins_job.id order by jenkins_job.full_name, jenkins_build.number";
        String insert = " insert into JENKINS_BUILD_UPSTREAM_CAUSE (upstream_build_id, downstream_build_id)  select upstream_build.id, ?  from jenkins_build as upstream_build, jenkins_job as upstream_job  where    upstream_build.job_id = upstream_job.id and   upstream_job.full_name = ? and   upstream_job.jenkins_master_id = ? and   upstream_build.number = ? ";
        try (PreparedStatement insertStmt = cnn.prepareStatement(insert);
             PreparedStatement selectStmt = cnn.prepareStatement(select);
             ResultSet rst = selectStmt.executeQuery();){
            while (rst.next()) {
                if (++jobCount < 100 && jobCount % 10 == 0 || jobCount < 500 && jobCount % 20 == 0 || jobCount % 50 == 0) {
                    LOGGER.log(Level.INFO, "#" + jobCount + " - " + rst.getString("FULL_NAME") + "...");
                }
                String jobFullName = rst.getString("full_name");
                int buildNumber = rst.getInt("number");
                long buildId = rst.getLong("id");
                long jenkinsMasterId = rst.getLong("jenkins_master_id");
                try {
                    Run build;
                    Job pipeline = (Job)Jenkins.get().getItemByFullName(jobFullName, Job.class);
                    if (pipeline == null || (build = pipeline.getBuildByNumber(buildNumber)) == null) continue;
                    for (Cause cause : build.getCauses()) {
                        if (!(cause instanceof Cause.UpstreamCause)) continue;
                        Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)cause;
                        String upstreamJobFullName = upstreamCause.getUpstreamProject();
                        int upstreamJobNumber = upstreamCause.getUpstreamBuild();
                        insertStmt.setLong(1, buildId);
                        insertStmt.setString(2, upstreamJobFullName);
                        insertStmt.setLong(3, jenkinsMasterId);
                        insertStmt.setInt(4, upstreamJobNumber);
                        insertStmt.addBatch();
                        ++buildCauseCount;
                    }
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.WARNING, "Silently ignore exception migrating build " + jobFullName + "#" + buildNumber, e);
                }
            }
            insertStmt.executeBatch();
        }
        LOGGER.info("Successfully upgraded table JENKINS_BUILD_UPSTREAM_CAUSE, " + jobCount + " jobs scanned, " + buildCauseCount + " job causes inserted");
    }

    protected void updateJenkinsJobRecord(@Nonnull Connection cnn, long jenkinsJobPrimaryKey, int lastBuildNumber) throws SQLException {
        try (PreparedStatement stmt = cnn.prepareStatement("UPDATE JENKINS_JOB set LAST_BUILD_NUMBER = ?, LAST_SUCCESSFUL_BUILD_NUMBER = ? where ID = ?");){
            stmt.setInt(1, lastBuildNumber);
            stmt.setInt(2, lastBuildNumber);
            stmt.setLong(3, jenkinsJobPrimaryKey);
            stmt.execute();
        }
    }

    @Nullable
    protected Integer findLastBuildNumber(@Nonnull Connection cnn, long jobPrimaryKey) throws SQLException {
        try (PreparedStatement stmt2 = cnn.prepareStatement("SELECT * FROM JENKINS_BUILD WHERE JOB_ID = ? ORDER BY JENKINS_BUILD.NUMBER DESC LIMIT 1");){
            Integer n;
            block16: {
                ResultSet rst2;
                block14: {
                    Integer n2;
                    block15: {
                        stmt2.setLong(1, jobPrimaryKey);
                        rst2 = stmt2.executeQuery();
                        try {
                            if (!rst2.next()) break block14;
                            n2 = rst2.getInt("JENKINS_BUILD.NUMBER");
                            if (rst2 == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rst2 != null) {
                                try {
                                    rst2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rst2.close();
                    }
                    return n2;
                }
                n = null;
                if (rst2 == null) break block16;
                rst2.close();
            }
            return n;
        }
    }
}

