/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.maveninvoker.MavenInvokerRecorder;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.util.FileUtils;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Element;

public class InvokerRunsPublisher
extends MavenPublisher {
    private static final Logger LOGGER = Logger.getLogger(InvokerRunsPublisher.class.getName());
    protected static final String GROUP_ID = "org.apache.maven.plugins";
    protected static final String ARTIFACT_ID = "maven-invoker-plugin";
    protected static final String RUN_GOAL = "run";
    protected static final String INTEGRATION_TEST_GOAL = "integration-test";
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public InvokerRunsPublisher() {
    }

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        List<Element> invokerRunRunEvents = XmlUtils.getExecutionEventsByPlugin(mavenSpyLogsElt, GROUP_ID, ARTIFACT_ID, RUN_GOAL, "MojoSucceeded", "MojoFailed");
        List<Element> invokerRunIntegrationTestEvents = XmlUtils.getExecutionEventsByPlugin(mavenSpyLogsElt, GROUP_ID, ARTIFACT_ID, INTEGRATION_TEST_GOAL, "MojoSucceeded", "MojoFailed");
        if (invokerRunRunEvents.isEmpty() && invokerRunIntegrationTestEvents.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] invokerPublisher - No org.apache.maven.plugins:maven-invoker-plugin:run or org.apache.maven.plugins:maven-invoker-plugin:integration-test execution found");
            }
            return;
        }
        try {
            Class.forName("org.jenkinsci.plugins.maveninvoker.MavenInvokerRecorder");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] invokerPublisher - Jenkins ");
            listener.hyperlink("https://wiki.jenkins.io/display/JENKINS/Maven+Invoker+Plugin", "Maven Invoker Plugin");
            listener.getLogger().println(" not found, don't display org.apache.maven.plugins:maven-invoker-plugin:run results in pipeline screen.");
            return;
        }
        this.executeReporter(context, listener, invokerRunRunEvents);
        this.executeReporter(context, listener, invokerRunIntegrationTestEvents);
    }

    private void executeReporter(StepContext context, TaskListener listener, List<Element> testEvents) throws IOException, InterruptedException {
        FilePath workspace = (FilePath)context.get(FilePath.class);
        String fileSeparatorOnAgent = XmlUtils.getFileSeparatorOnRemote(workspace);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        FlowNode node = (FlowNode)context.get(FlowNode.class);
        for (Element testEvent : testEvents) {
            Element projectElt = XmlUtils.getUniqueChildElement(testEvent, "project");
            Element pluginElt = XmlUtils.getUniqueChildElement(testEvent, "plugin");
            Element reportsDirectoryElt = XmlUtils.getUniqueChildElementOrNull(pluginElt, "reportsDirectory");
            Element cloneProjectsToElt = XmlUtils.getUniqueChildElementOrNull(pluginElt, "cloneProjectsTo");
            Element projectsDirectoryElt = XmlUtils.getUniqueChildElementOrNull(pluginElt, "projectsDirectory");
            MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenSpyLogProcessor.PluginInvocation pluginInvocation = XmlUtils.newPluginInvocation(pluginElt);
            String reportsDirectory = this.expandAndRelativize(reportsDirectoryElt, "reportsDirectory", testEvent, projectElt, workspace, listener);
            String projectsDirectory = this.expandAndRelativize(projectsDirectoryElt, "projectsDirectory", testEvent, projectElt, workspace, listener);
            String cloneProjectsTo = this.expandAndRelativize(cloneProjectsToElt, "cloneProjectsTo", testEvent, projectElt, workspace, listener);
            if (reportsDirectory == null || projectsDirectory == null) continue;
            String testResults = reportsDirectory + fileSeparatorOnAgent + "*.xml";
            listener.getLogger().println("[withMaven] invokerPublisher - Archive invoker results for Maven artifact " + mavenArtifact.toString() + " generated by " + pluginInvocation + ": " + testResults);
            MavenInvokerRecorder archiver = new MavenInvokerRecorder("**/" + reportsDirectory + "/BUILD*.xml", "**/" + (cloneProjectsTo != null ? cloneProjectsTo : projectsDirectory));
            try {
                archiver.perform(run, workspace, launcher, listener, node);
            }
            catch (Exception e) {
                listener.error("[withMaven] invokerPublisher - exception archiving Invoker runs for Maven artifact " + mavenArtifact.toString() + " generated by " + pluginInvocation + ": " + e + ". Failing the build.");
                LOGGER.log(Level.WARNING, "Exception processing " + XmlUtils.toString(testEvent), e);
                run.setResult(Result.FAILURE);
            }
        }
    }

    @Nullable
    protected String expandAndRelativize(@Nullable Element element, @Nullable String name, Element testEvent, Element projectElt, FilePath workspace, TaskListener listener) {
        if (element == null) {
            listener.getLogger().println("[withMaven] invokerPublisher - No <" + name + "> element found for <plugin> in " + XmlUtils.toString(testEvent));
            return null;
        }
        String result = element.getTextContent().trim();
        if (result.contains("${invoker.projectsDirectory}")) {
            result = result.replace("${invoker.projectsDirectory}", "${basedir}/src/it");
        } else if (result.contains("${invoker.reportsDirectory}")) {
            result = result.replace("${invoker.reportsDirectory}", "${project.build.directory}/invoker-reports");
        }
        if (result.contains("${project.build.directory}")) {
            String projectBuildDirectory = XmlUtils.getProjectBuildDirectory(projectElt);
            if (projectBuildDirectory == null || projectBuildDirectory.isEmpty()) {
                listener.getLogger().println("[withMaven] invokerPublisher - '${project.build.directory}' found for <project> in " + XmlUtils.toString(testEvent));
                return null;
            }
            result = result.replace("${project.build.directory}", projectBuildDirectory);
        } else if (result.contains("${basedir}")) {
            String baseDir = projectElt.getAttribute("baseDir");
            if (baseDir.isEmpty()) {
                listener.getLogger().println("[withMaven] invokerPublisher - '${basedir}' NOT found for <project> in " + XmlUtils.toString(testEvent));
                return null;
            }
            result = result.replace("${basedir}", baseDir);
        } else if (!FileUtils.isAbsolutePath(result)) {
            char separator = FileUtils.isWindows(result) ? (char)'\\' : '/';
            String baseDir = projectElt.getAttribute("baseDir");
            if (baseDir.isEmpty()) {
                listener.getLogger().println("[withMaven] invokerPublisher - '${basedir}' NOT found for <project> in " + XmlUtils.toString(testEvent));
                return null;
            }
            result = baseDir + separator + result;
        }
        return XmlUtils.getPathInWorkspace(result, workspace);
    }

    @Symbol(value={"invokerPublisher"})
    @Extension
    public static class DescriptorImpl
    extends MavenPublisher.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return "Invoker Publisher";
        }

        @Override
        public int ordinal() {
            return 10;
        }

        @Override
        @Nonnull
        public String getSkipFileName() {
            return ".skip-publish-invoker-runs";
        }
    }
}

