/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.listeners;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.listeners.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;

@Extension
public class DatabaseSyncItemListener
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(DatabaseSyncItemListener.class.getName());
    @Inject
    public GlobalPipelineMavenConfig globalPipelineMavenConfig;

    public void onDeleted(Item item) {
        if (item instanceof FlowExecutionOwner.Executable) {
            LOGGER.log(Level.FINE, "onDeleted({0})", item);
            this.globalPipelineMavenConfig.getDao().deleteJob(item.getFullName());
        } else {
            LOGGER.log(Level.FINE, "Ignore onDeleted({0})", new Object[]{item});
        }
    }

    public void onRenamed(Item item, String oldName, String newName) {
        if (item instanceof FlowExecutionOwner.Executable) {
            LOGGER.log(Level.FINE, "onRenamed({0}, {1}, {2})", new Object[]{item, oldName, newName});
            ItemGroup parent = item.getParent();
            String oldFullName = parent.equals(Jenkins.get()) ? oldName : parent.getFullName() + "/" + oldName;
            String newFullName = item.getFullName();
            this.globalPipelineMavenConfig.getDao().renameJob(oldFullName, newFullName);
        } else {
            LOGGER.log(Level.FINE, "Ignore onRenamed({0}, {1}, {2})", new Object[]{item, oldName, newName});
        }
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
        if (item instanceof FlowExecutionOwner.Executable) {
            LOGGER.log(Level.FINE, "onLocationChanged({0}, {1}, {2})", new Object[]{item, oldFullName, newFullName});
            this.globalPipelineMavenConfig.getDao().renameJob(oldFullName, newFullName);
        } else {
            LOGGER.log(Level.FINE, "Ignore onLocationChanged({0}, {1}, {2})", new Object[]{item, oldFullName, newFullName});
        }
    }
}

