/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.dao;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.pipeline.maven.dao.AbstractPipelineMavenPluginDaoDecorator;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;

public class CustomTypePipelineMavenPluginDaoDecorator
extends AbstractPipelineMavenPluginDaoDecorator {
    private static final List<String> KNOWN_JAR_TYPES_WITH_DIFFERENT_EXTENSION = Arrays.asList("test-jar", "maven-plugin", "ejb", "ejb-client", "java-source", "javadoc");

    public CustomTypePipelineMavenPluginDaoDecorator(@Nonnull PipelineMavenPluginDao delegate) {
        super(delegate);
    }

    @Override
    public void recordGeneratedArtifact(@Nonnull String jobFullName, int buildNumber, @Nonnull String groupId, @Nonnull String artifactId, @Nonnull String version, @Nonnull String type, @Nonnull String baseVersion, @Nullable String repositoryUrl, boolean skipDownstreamTriggers, String extension, String classifier) {
        super.recordGeneratedArtifact(jobFullName, buildNumber, groupId, artifactId, version, type, baseVersion, repositoryUrl, skipDownstreamTriggers, extension, classifier);
        if (this.shouldReportAgainWithExtensionAsType(type, extension)) {
            super.recordGeneratedArtifact(jobFullName, buildNumber, groupId, artifactId, version, extension, baseVersion, repositoryUrl, skipDownstreamTriggers, extension, classifier);
        }
    }

    private boolean shouldReportAgainWithExtensionAsType(String type, String extension) {
        if (KNOWN_JAR_TYPES_WITH_DIFFERENT_EXTENSION.contains(type)) {
            return false;
        }
        return !StringUtils.equals((CharSequence)type, (CharSequence)extension);
    }
}

