/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import jenkins.model.CauseOfInterruption;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.steps.build.DownstreamFailureCause;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;
import org.jenkinsci.plugins.workflow.support.steps.build.WaitForBuildAction;
import org.jenkinsci.plugins.workflow.support.steps.build.WaitForBuildStep;

public class WaitForBuildStepExecution
extends AbstractStepExecutionImpl {
    private static final long serialVersionUID = 1L;
    private final transient WaitForBuildStep step;

    public WaitForBuildStepExecution(WaitForBuildStep step, @NonNull StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        Run run = Run.fromExternalizableId((String)this.step.getRunId());
        if (run == null) {
            throw new AbortException("No build exists with runId " + this.step.getRunId());
        }
        String runHyperLink = ModelHyperlinkNote.encodeTo((String)("/" + run.getUrl()), (String)run.getFullDisplayName());
        TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
        if (run.isBuilding()) {
            run.addAction((Action)new WaitForBuildAction(this.getContext(), this.step.isPropagate()));
            taskListener.getLogger().println("Waiting for " + runHyperLink + " to complete");
            return false;
        }
        Result result = run.getResult();
        if (result == null) {
            taskListener.getLogger().println("Warning: " + runHyperLink + " already completed but getResult() returned null. Treating the result of this build as a failure");
            result = Result.FAILURE;
        } else {
            taskListener.getLogger().println(runHyperLink + " already completed: " + result.toString());
        }
        StepContext context = this.getContext();
        if (!this.step.isPropagate() || result == Result.SUCCESS) {
            context.onSuccess((Object)new RunWrapper(run, false));
        } else {
            context.onFailure((Throwable)new FlowInterruptedException(result, false, new CauseOfInterruption[]{new DownstreamFailureCause(run)}));
        }
        return true;
    }
}

