/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import hudson.AbortException;
import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerAction;
import org.jenkinsci.plugins.workflow.support.steps.build.DownstreamFailureCause;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;

@Extension
public class BuildTriggerListener
extends RunListener<Run<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(BuildTriggerListener.class.getName());

    public void onStarted(Run<?, ?> run, TaskListener listener) {
        for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor(run)) {
            StepContext stepContext = trigger.context;
            if (stepContext != null && stepContext.isReady()) {
                LOGGER.log(Level.FINE, "started building {0} from #{1} in {2}", new Object[]{run, run.getQueueId(), stepContext});
                try {
                    TaskListener taskListener = (TaskListener)stepContext.get(TaskListener.class);
                    taskListener.getLogger().println("Starting building: " + ModelHyperlinkNote.encodeTo((String)("/" + run.getUrl()), (String)run.getFullDisplayName()));
                    if (!trigger.waitForStart) continue;
                    stepContext.onSuccess((Object)new RunWrapper(run, false));
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, null, e);
                }
                continue;
            }
            LOGGER.log(Level.FINE, "{0} unavailable in {1}", new Object[]{stepContext, run});
        }
    }

    public void onFinalized(Run<?, ?> run) {
        for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor(run)) {
            if (trigger.waitForStart) continue;
            StepContext stepContext = trigger.context;
            LOGGER.log(Level.FINE, "completing {0} for {1}", new Object[]{run, stepContext});
            Result result = run.getResult();
            if (result == null) {
                result = Result.FAILURE;
            }
            try {
                ((TaskListener)stepContext.get(TaskListener.class)).getLogger().println("Build " + ModelHyperlinkNote.encodeTo((String)("/" + run.getUrl()), (String)run.getFullDisplayName()) + " completed: " + result.toString());
                if (trigger.propagate && result != Result.SUCCESS) {
                    ((FlowNode)stepContext.get(FlowNode.class)).addOrReplaceAction((Action)new WarningAction(result));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, null, e);
            }
            if (!trigger.propagate || result == Result.SUCCESS) {
                if (trigger.interruption == null) {
                    stepContext.onSuccess((Object)new RunWrapper(run, false));
                    continue;
                }
                stepContext.onFailure(trigger.interruption);
                continue;
            }
            stepContext.onFailure((Throwable)new FlowInterruptedException(result, false, new CauseOfInterruption[]{new DownstreamFailureCause(run)}));
        }
        run.removeActions(BuildTriggerAction.class);
    }

    public void onDeleted(Run<?, ?> run) {
        for (BuildTriggerAction.Trigger trigger : BuildTriggerAction.triggersFor(run)) {
            Timer.get().submit(() -> trigger.context.onFailure((Throwable)new AbortException(run.getFullDisplayName() + " was deleted")));
        }
    }
}

