/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.uberalls;

import com.uber.jenkins.phabricator.coverage.CodeCoverageMetrics;
import com.uber.jenkins.phabricator.utils.CommonUtils;
import com.uber.jenkins.phabricator.utils.Logger;
import java.io.IOException;
import java.net.URISyntaxException;
import net.sf.json.JSON;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;

public class UberallsClient {
    public static final String PACKAGE_COVERAGE_KEY = "packageCoverage";
    public static final String FILES_COVERAGE_KEY = "filesCoverage";
    public static final String CLASSES_COVERAGE_KEY = "classesCoverage";
    public static final String METHOD_COVERAGE_KEY = "methodCoverage";
    public static final String LINE_COVERAGE_KEY = "lineCoverage";
    public static final String CONDITIONAL_COVERAGE_KEY = "conditionalCoverage";
    public static final String LINES_COVERED_KEY = "linesCovered";
    public static final String LINES_TESTED_KEY = "linesTested";
    private static final String TAG = "uberalls-client";
    private final String baseURL;
    private final Logger logger;
    private final String repository;
    private final String branch;

    public UberallsClient(String baseURL, Logger logger, String repository, String branch) {
        this.baseURL = baseURL;
        this.logger = logger;
        this.repository = repository;
        this.branch = branch;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public CodeCoverageMetrics getParentCoverage(String sha) {
        if (sha == null) {
            return null;
        }
        try {
            String coverageJSON = this.getCoverage(sha);
            JsonSlurper jsonParser = new JsonSlurper();
            JSON responseJSON = jsonParser.parseText(coverageJSON);
            if (responseJSON instanceof JSONNull) {
                return null;
            }
            JSONObject coverage = (JSONObject)responseJSON;
            return new CodeCoverageMetrics(Double.valueOf(coverage.getDouble(PACKAGE_COVERAGE_KEY)).floatValue(), Double.valueOf(coverage.getDouble(FILES_COVERAGE_KEY)).floatValue(), Double.valueOf(coverage.getDouble(CLASSES_COVERAGE_KEY)).floatValue(), Double.valueOf(coverage.getDouble(METHOD_COVERAGE_KEY)).floatValue(), Double.valueOf(coverage.getDouble(LINE_COVERAGE_KEY)).floatValue(), Double.valueOf(coverage.getDouble(CONDITIONAL_COVERAGE_KEY)).floatValue(), coverage.getLong(LINES_COVERED_KEY), coverage.getLong(LINES_TESTED_KEY));
        }
        catch (Exception e) {
            e.printStackTrace(this.logger.getStream());
            return null;
        }
    }

    public boolean recordCoverage(String sha, CodeCoverageMetrics codeCoverageMetrics) {
        if (codeCoverageMetrics != null) {
            JSONObject params = new JSONObject();
            params.put("sha", (Object)sha);
            params.put("branch", (Object)this.branch);
            params.put("repository", (Object)this.repository);
            params.put(PACKAGE_COVERAGE_KEY, (Object)Float.valueOf(codeCoverageMetrics.getPackageCoveragePercent()));
            params.put(FILES_COVERAGE_KEY, (Object)Float.valueOf(codeCoverageMetrics.getFilesCoveragePercent()));
            params.put(CLASSES_COVERAGE_KEY, (Object)Float.valueOf(codeCoverageMetrics.getClassesCoveragePercent()));
            params.put(METHOD_COVERAGE_KEY, (Object)Float.valueOf(codeCoverageMetrics.getMethodCoveragePercent()));
            params.put(LINE_COVERAGE_KEY, (Object)Float.valueOf(codeCoverageMetrics.getLineCoveragePercent()));
            params.put(CONDITIONAL_COVERAGE_KEY, (Object)Float.valueOf(codeCoverageMetrics.getConditionalCoveragePercent()));
            params.put(LINES_COVERED_KEY, (Object)Float.valueOf(codeCoverageMetrics.getLinesCovered()));
            params.put(LINES_TESTED_KEY, (Object)Float.valueOf(codeCoverageMetrics.getLinesTested()));
            try {
                HttpClient client = this.getClient();
                PostMethod request = new PostMethod(this.getBuilder().build().toString());
                request.addRequestHeader("Content-Type", "application/json");
                StringRequestEntity requestEntity = new StringRequestEntity(params.toString(), ContentType.APPLICATION_JSON.toString(), "UTF-8");
                request.setRequestEntity((RequestEntity)requestEntity);
                int statusCode = client.executeMethod((HttpMethod)request);
                if (statusCode != 200) {
                    this.logger.info(TAG, "Call failed: " + request.getStatusLine());
                    return false;
                }
                return true;
            }
            catch (URISyntaxException e) {
                e.printStackTrace(this.logger.getStream());
            }
            catch (HttpResponseException e) {
                this.logger.info(TAG, "HTTP Response error recording metrics: " + (Object)((Object)e));
            }
            catch (ClientProtocolException e) {
                e.printStackTrace(this.logger.getStream());
            }
            catch (IOException e) {
                e.printStackTrace(this.logger.getStream());
            }
        }
        return false;
    }

    public String getCoverage(String sha) {
        try {
            URIBuilder builder = this.getBuilder().setParameter("sha", sha).setParameter("repository", this.repository);
            HttpClient client = this.getClient();
            GetMethod request = new GetMethod(builder.build().toString());
            int statusCode = client.executeMethod((HttpMethod)request);
            if (statusCode != 200) {
                this.logger.info(TAG, "Call failed: " + request.getStatusLine());
                return null;
            }
            return request.getResponseBodyAsString();
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() != 404) {
                e.printStackTrace(this.logger.getStream());
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.logger.getStream());
        }
        return null;
    }

    private URIBuilder getBuilder() throws URISyntaxException {
        return new URIBuilder(this.baseURL);
    }

    public HttpClient getClient() {
        return new HttpClient();
    }

    public boolean isConfigured() {
        return !CommonUtils.isBlank(this.baseURL);
    }
}

