/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.tasks;

import com.uber.jenkins.phabricator.utils.Logger;

public abstract class Task {
    protected Result result = Result.UNKNOWN;
    private final Logger logger;

    public Task(Logger logger) {
        this.logger = logger;
    }

    public Result run() {
        this.setup();
        this.execute();
        this.tearDown();
        return this.result;
    }

    protected void info(String message) {
        this.logger.info(this.getTag(), message);
    }

    protected void printStackTrace(Exception e) {
        e.printStackTrace(this.logger.getStream());
    }

    protected abstract String getTag();

    protected abstract void setup();

    protected abstract void execute();

    protected abstract void tearDown();

    public static enum Result {
        SUCCESS,
        FAILURE,
        IGNORED,
        SKIPPED,
        UNKNOWN;

    }
}

