/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.tasks;

import com.uber.jenkins.phabricator.conduit.ConduitAPIException;
import com.uber.jenkins.phabricator.conduit.DifferentialClient;
import com.uber.jenkins.phabricator.conduit.HarbormasterClient;
import com.uber.jenkins.phabricator.lint.LintResults;
import com.uber.jenkins.phabricator.tasks.Task;
import com.uber.jenkins.phabricator.unit.UnitResults;
import com.uber.jenkins.phabricator.utils.Logger;
import java.io.IOException;
import java.util.Map;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class SendHarbormasterResultTask
extends Task {
    private final DifferentialClient diffClient;
    private final String phid;
    private final HarbormasterClient.MessageType messageType;
    private final Map<String, String> coverage;
    private final LintResults lintResults;
    private UnitResults unitResults;

    public SendHarbormasterResultTask(Logger logger, DifferentialClient diffClient, String phid, HarbormasterClient.MessageType messageType, UnitResults unitResults, Map<String, String> harbormasterCoverage, LintResults lintResults) {
        super(logger);
        this.diffClient = diffClient;
        this.phid = phid;
        this.messageType = messageType;
        this.unitResults = unitResults;
        this.coverage = harbormasterCoverage;
        this.lintResults = lintResults;
    }

    @Override
    protected String getTag() {
        return "send-harbormaster-result";
    }

    @Override
    protected void setup() {
    }

    @Override
    protected void execute() {
        try {
            if (!this.sendMessage(this.unitResults, this.coverage, this.lintResults)) {
                this.info("Error sending Harbormaster unit results, trying again without unit data (you may have an old Phabricator?).");
                this.sendMessage(null, null, null);
            }
        }
        catch (ConduitAPIException e) {
            this.printStackTrace(e);
            this.failTask();
        }
        catch (IOException e) {
            this.printStackTrace(e);
            this.failTask();
        }
    }

    @Override
    protected void tearDown() {
    }

    private boolean sendMessage(UnitResults unitResults, Map<String, String> coverage, LintResults lintResults) throws IOException, ConduitAPIException {
        JSONObject result = this.diffClient.sendHarbormasterMessage(this.phid, this.messageType, unitResults, coverage, lintResults);
        if (result.containsKey((Object)"error_info") && !(result.get("error_info") instanceof JSONNull)) {
            this.info(String.format("Error from Harbormaster: %s", result.getString("error_info")));
            this.failTask();
            return false;
        }
        this.result = Task.Result.SUCCESS;
        return true;
    }

    private void failTask() {
        this.info("Unable to post to Harbormaster");
        this.result = Task.Result.FAILURE;
    }
}

