/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.tasks;

import com.uber.jenkins.phabricator.conduit.ConduitAPIClient;
import com.uber.jenkins.phabricator.conduit.ConduitAPIException;
import com.uber.jenkins.phabricator.conduit.HarbormasterClient;
import com.uber.jenkins.phabricator.tasks.Task;
import com.uber.jenkins.phabricator.utils.Logger;
import hudson.model.Result;
import java.io.IOException;

public class NonDifferentialHarbormasterTask
extends Task {
    private final String phid;
    private final ConduitAPIClient conduit;
    private final Result buildResult;
    private final String buildUrl;
    private final HarbormasterClient harbormaster;
    private final Logger logger;
    private final boolean sendPartialResults;

    public NonDifferentialHarbormasterTask(Logger logger, String phid, ConduitAPIClient conduitClient, Result result, String buildUrl, boolean sendPartialResults) {
        super(logger);
        this.logger = logger;
        this.phid = phid;
        this.conduit = conduitClient;
        this.buildResult = result;
        this.buildUrl = buildUrl;
        this.sendPartialResults = sendPartialResults;
        this.harbormaster = new HarbormasterClient(this.conduit);
    }

    @Override
    protected String getTag() {
        return "non-differential-harbormaster";
    }

    @Override
    protected void setup() {
    }

    @Override
    protected void execute() {
        HarbormasterClient.MessageType messageType = this.sendPartialResults ? HarbormasterClient.MessageType.work : (this.buildResult.isBetterOrEqualTo(Result.SUCCESS) ? HarbormasterClient.MessageType.pass : HarbormasterClient.MessageType.fail);
        this.info(String.format("Sending diffusion result as: %s, message type: %s", this.buildResult.toString(), messageType.name()));
        try {
            this.harbormaster.sendHarbormasterUri(this.phid, this.buildUrl);
            this.harbormaster.sendHarbormasterMessage(this.phid, messageType, null, null, null);
            this.result = Task.Result.SUCCESS;
            return;
        }
        catch (ConduitAPIException e) {
            e.printStackTrace(this.logger.getStream());
        }
        catch (IOException e) {
            e.printStackTrace(this.logger.getStream());
        }
        this.result = Task.Result.FAILURE;
    }

    @Override
    protected void tearDown() {
    }
}

