/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.uber.jenkins.phabricator.LauncherFactory;
import com.uber.jenkins.phabricator.conduit.ArcanistClient;
import com.uber.jenkins.phabricator.tasks.Task;
import com.uber.jenkins.phabricator.utils.Logger;
import hudson.model.Computer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ApplyPatchTask
extends Task {
    private static final String DEFAULT_GIT_PATH = "git";
    private static final String DEFAULT_HG_PATH = "hg";
    private final LauncherFactory starter;
    private final PrintStream logStream;
    private final String scmType;
    private String gitPath;
    private String hgPath;
    private final String arcPath;
    private final boolean skipForcedClean;
    private final String baseCommit;
    private final String conduitUrl;
    private final String conduitToken;
    private final String diffID;
    private final boolean createCommit;
    private final boolean createBranch;
    private final boolean patchWithForceFlag;

    public ApplyPatchTask(Logger logger, LauncherFactory starter, String baseCommit, String diffID, String conduitUrl, String conduitToken, String arcPath, boolean createCommit, boolean skipForcedClean, boolean createBranch, boolean patchWithForceFlag, String scmType) {
        super(logger);
        this.arcPath = this.isWindows() ? arcPath + ".bat" : arcPath;
        this.gitPath = DEFAULT_GIT_PATH;
        this.hgPath = DEFAULT_HG_PATH;
        this.scmType = scmType;
        this.starter = starter;
        this.logStream = logger.getStream();
        this.baseCommit = baseCommit;
        this.diffID = diffID;
        this.conduitUrl = conduitUrl;
        this.conduitToken = conduitToken;
        this.createCommit = createCommit;
        this.skipForcedClean = skipForcedClean;
        this.createBranch = createBranch;
        this.patchWithForceFlag = patchWithForceFlag;
    }

    @VisibleForTesting
    void setGitPath(String gitPath) {
        this.gitPath = gitPath;
    }

    @VisibleForTesting
    void setHgPath(String hgPath) {
        this.hgPath = hgPath;
    }

    @Override
    protected String getTag() {
        return "arc-patch";
    }

    @Override
    protected void setup() {
    }

    @Override
    protected void execute() {
        try {
            this.prepareRepositoryState();
            this.result = this.applyArcPatch() == 0 ? Task.Result.SUCCESS : Task.Result.FAILURE;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace(this.logStream);
            this.result = Task.Result.FAILURE;
        }
    }

    private int applyArcPatch() throws IOException, InterruptedException {
        ArrayList<String> arcPatchParams = new ArrayList<String>(Arrays.asList("--diff", this.diffID));
        switch (this.scmType) {
            case "git": 
            case "hg": {
                if (!this.createCommit) {
                    arcPatchParams.add("--nocommit");
                }
                if (this.createBranch) break;
                arcPatchParams.add("--nobranch");
                break;
            }
            case "svn": {
                break;
            }
            default: {
                this.info("Unknown scm type " + this.scmType + " skipping");
            }
        }
        if (this.patchWithForceFlag) {
            arcPatchParams.add("--force");
        }
        ArcanistClient arc = new ArcanistClient(this.arcPath, "patch", this.conduitUrl, this.conduitToken, arcPatchParams.toArray(new String[arcPatchParams.size()]));
        int exitCode = arc.callConduit(this.starter.launch(), this.logStream);
        return exitCode;
    }

    private void prepareRepositoryState() throws InterruptedException, IOException {
        List<String> resetToBaseCommit = Collections.emptyList();
        List<String> cleanWorkingDir = Collections.emptyList();
        List<String> updateSubmodules = Collections.emptyList();
        switch (this.scmType) {
            case "git": {
                resetToBaseCommit = Arrays.asList(this.gitPath, "reset", "--hard", this.baseCommit);
                cleanWorkingDir = Arrays.asList(this.gitPath, "clean", "-fd", "-f");
                updateSubmodules = Arrays.asList(this.gitPath, "submodule", "update", "--init", "--recursive");
                break;
            }
            case "hg": {
                resetToBaseCommit = Arrays.asList(this.hgPath, "update", "--clean", this.baseCommit);
                cleanWorkingDir = Arrays.asList(this.hgPath, "--config", "extensions.purge=", "purge", "--files", "--dirs");
                updateSubmodules = Collections.emptyList();
                break;
            }
            case "svn": {
                break;
            }
            default: {
                this.info("Unknown scm type " + this.scmType + " skipping");
                return;
            }
        }
        int exitCode = this.launch(resetToBaseCommit);
        if (exitCode != 0) {
            this.info("Got non-zero exit code resetting to base commit " + this.baseCommit + ": " + exitCode);
        }
        if (!this.skipForcedClean) {
            this.launch(cleanWorkingDir);
        }
        this.launch(updateSubmodules);
    }

    private int launch(List<String> cmds) throws IOException, InterruptedException {
        if (cmds.isEmpty()) {
            return 0;
        }
        return this.starter.launch().cmds(cmds).stdout((OutputStream)this.logStream).join();
    }

    private boolean isWindows() {
        try {
            Map remoteProperties;
            Computer remoteComputer = Computer.currentComputer();
            if (remoteComputer != null && (remoteProperties = remoteComputer.getSystemProperties()).containsKey("os.name")) {
                return StringUtils.startsWithIgnoreCase((String)remoteProperties.get("os.name").toString(), (String)"Windows");
            }
        }
        catch (IOException e) {
            this.info("IOException attempting to determine whether the OS is Windows.\n" + e.getMessage());
        }
        catch (InterruptedException e) {
            this.info("InterruptedException attempting to determine whether the OS is Windows.\n" + e.getMessage());
        }
        return false;
    }

    @Override
    protected void tearDown() {
    }
}

