/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.coverage;

import com.uber.jenkins.phabricator.coverage.CodeCoverageMetrics;
import com.uber.jenkins.phabricator.coverage.CoverageProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlCoverageProvider
extends CoverageProvider {
    private final List<XmlCoverageHandler> xmlCoverageHandlers;
    private final Set<File> coverageReports;
    private final DocumentBuilder db;
    private final CoverageCounters cc;

    XmlCoverageProvider(Set<File> coverageReports) {
        this(coverageReports, null);
    }

    public XmlCoverageProvider(Set<File> coverageReports, Set<String> includeFiles) {
        super(includeFiles);
        this.coverageReports = coverageReports;
        this.xmlCoverageHandlers = Arrays.asList(new CoberturaXmlCoverageHandler(), new CloverXmlCoverageHandler(), new JacocoXmlCoverageHandler());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        DocumentBuilder localDb = null;
        try {
            dbf.setFeature("http://xml.org/sax/features/namespaces", false);
            dbf.setFeature("http://xml.org/sax/features/validation", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            localDb = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.db = localDb;
        this.cc = new CoverageCounters();
    }

    @Override
    protected void computeCoverage() {
        try {
            this.parse(this.includeFiles, this.coverageReports);
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
        }
        this.computeMetrics();
    }

    protected void computeMetrics() {
        this.metrics = new CodeCoverageMetrics(this.cc.pkg.getPercent(), this.cc.file.getPercent(), this.cc.cls.getPercent(), this.cc.method.getPercent(), Math.max(this.cc.lineCoveragePercentOverride.floatValue(), this.cc.line.getPercent()), Math.max(this.cc.branchCoveragePercentOverride.floatValue(), this.cc.branch.getPercent()), ((CoverageCounters)this.cc).line.covered, ((CoverageCounters)this.cc).line.covered + ((CoverageCounters)this.cc).line.missed);
    }

    private void parse(Set<String> includeFiles, Set<File> reports) throws SAXException, IOException {
        if (this.db != null) {
            for (File file : reports) {
                FileInputStream is = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    Document document = this.db.parse(is);
                    for (XmlCoverageHandler xmlCoverageHandler : this.xmlCoverageHandlers) {
                        if (!xmlCoverageHandler.isApplicable(document)) continue;
                        xmlCoverageHandler.parseCoverage(document, includeFiles, this.cc, this.lineCoverage);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)is).close();
                }
            }
        }
    }

    private static Long getLongValue(NamedNodeMap attrs, String attr) {
        String content = attrs.getNamedItem(attr).getTextContent();
        try {
            return Math.round(Double.valueOf(content));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(content + " is not a valid coverage number", e);
        }
    }

    private static Integer getIntValue(NamedNodeMap attrs, String attr) {
        String content = attrs.getNamedItem(attr).getTextContent();
        try {
            return Math.round(Float.valueOf(content).floatValue());
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(content + " is not a valid coverage number", e);
        }
    }

    private static Float getFloatValue(NamedNodeMap attrs, String attr) {
        String content = attrs.getNamedItem(attr).getTextContent();
        try {
            return Float.valueOf(content);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(content + " is not a valid coverage number", e);
        }
    }

    private static class CoverageCounters {
        Float lineCoveragePercentOverride = Float.valueOf(0.0f);
        Float branchCoveragePercentOverride = Float.valueOf(0.0f);
        private final CoverageCounter pkg = new CoverageCounter();
        private final CoverageCounter cls = new CoverageCounter();
        private final CoverageCounter method = new CoverageCounter();
        private final CoverageCounter line = new CoverageCounter();
        private final CoverageCounter branch = new CoverageCounter();
        private final CoverageCounter file = new CoverageCounter();

        private CoverageCounters() {
        }
    }

    private static class CoverageCounter {
        long covered = 0L;
        long missed = 0L;

        private CoverageCounter() {
        }

        float getPercent() {
            long total = this.covered + this.missed;
            if (total == 0L) {
                return 100.0f;
            }
            return (float)this.covered * 1.0f / (float)total * 1.0f * 100.0f;
        }
    }

    private static class CloverXmlCoverageHandler
    extends XmlCoverageHandler {
        private CloverXmlCoverageHandler() {
        }

        @Override
        boolean isApplicable(Document document) {
            Element documentElement = document.getDocumentElement();
            if (!documentElement.getTagName().equals("coverage")) {
                return false;
            }
            NodeList children = documentElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (!children.item(i).getNodeName().equals("project")) continue;
                return true;
            }
            return false;
        }

        @Override
        void parseCoverage(Document document, Set<String> includeFiles, CoverageCounters cc, Map<String, List<Integer>> lineCoverage) {
            Node packageNode;
            int i;
            HashMap<String, SortedMap<Integer, Integer>> internalCounts = new HashMap<String, SortedMap<Integer, Integer>>();
            NodeList packages = document.getElementsByTagName("package");
            for (i = 0; i < packages.getLength(); ++i) {
                packageNode = packages.item(i);
                NodeList fileNodes = packageNode.getChildNodes();
                for (int j = 0; j < fileNodes.getLength(); ++j) {
                    String fileName;
                    String finalFileName;
                    Node fileNode = fileNodes.item(j);
                    if (!fileNode.hasAttributes() || (finalFileName = CloverXmlCoverageHandler.getRelativePathFromProjectRoot(includeFiles, fileName = fileNode.getAttributes().getNamedItem("name").getTextContent())) == null) continue;
                    SortedMap hitCounts = internalCounts.computeIfAbsent(finalFileName, it -> new TreeMap());
                    NodeList coverage = fileNode.getChildNodes();
                    for (int k = 0; k < coverage.getLength(); ++k) {
                        NamedNodeMap attrs;
                        Node coverageNode = coverage.item(k);
                        if (coverageNode == null || !"line".equals(coverageNode.getNodeName()) || !"stmt".equals((attrs = coverageNode.getAttributes()).getNamedItem("type").getTextContent())) continue;
                        long hitCount = XmlCoverageProvider.getIntValue(attrs, "count").intValue();
                        int lineNumber = XmlCoverageProvider.getIntValue(attrs, "num");
                        hitCounts.put(lineNumber, hitCount > 0L ? 1 : 0);
                    }
                }
            }
            this.computeLineCoverage(internalCounts, lineCoverage);
            for (i = 0; i < packages.getLength(); ++i) {
                packageNode = packages.item(i);
                NodeList packageChildren = packageNode.getChildNodes();
                boolean packageCovered = false;
                for (int j = 0; j < packageChildren.getLength(); ++j) {
                    Node fileNode = packageChildren.item(j);
                    if (!fileNode.getNodeName().equals("file")) continue;
                    NodeList fileChildren = fileNode.getChildNodes();
                    boolean fileCovered = false;
                    for (int k = 0; k < fileChildren.getLength(); ++k) {
                        Node fileChild = fileChildren.item(k);
                        if (fileChild.getNodeName().equals("line")) {
                            Node lineChild = fileChild;
                            NamedNodeMap lineAttributes = lineChild.getAttributes();
                            String typeAttributeText = lineAttributes.getNamedItem("type").getTextContent();
                            if (typeAttributeText.equals("stmt")) {
                                int lineHits = XmlCoverageProvider.getIntValue(lineAttributes, "count");
                                if (lineHits > 0) {
                                    fileCovered = true;
                                    ++((CoverageCounters)cc).line.covered;
                                } else {
                                    ++((CoverageCounters)cc).line.missed;
                                }
                            } else if (typeAttributeText.equals("method")) {
                                int methodHits = XmlCoverageProvider.getIntValue(lineAttributes, "count");
                                if (methodHits > 0) {
                                    fileCovered = true;
                                    ++((CoverageCounters)cc).method.covered;
                                } else {
                                    ++((CoverageCounters)cc).method.missed;
                                }
                            }
                        }
                        if (!fileChild.getNodeName().equals("class")) continue;
                        Node classNode = fileChild;
                        NodeList classChildren = classNode.getChildNodes();
                        for (int l = 0; l < classChildren.getLength(); ++l) {
                            Node metricNode = classChildren.item(l);
                            if (!metricNode.getNodeName().equals("metrics")) continue;
                            Integer coveredstatements = XmlCoverageProvider.getIntValue(metricNode.getAttributes(), "coveredstatements");
                            if (coveredstatements > 0) {
                                fileCovered = true;
                                ++((CoverageCounters)cc).cls.covered;
                                continue;
                            }
                            ++((CoverageCounters)cc).cls.missed;
                        }
                    }
                    if (fileCovered) {
                        packageCovered = true;
                        ++((CoverageCounters)cc).file.covered;
                        continue;
                    }
                    ++((CoverageCounters)cc).file.missed;
                }
                if (packageCovered) {
                    ++((CoverageCounters)cc).pkg.covered;
                    continue;
                }
                ++((CoverageCounters)cc).pkg.missed;
            }
        }

        @Nullable
        private static String getRelativePathFromProjectRoot(Set<String> includeFiles, String coverageFile) {
            if (includeFiles == null || includeFiles.isEmpty()) {
                return coverageFile;
            }
            for (String includedFile : includeFiles) {
                if (!coverageFile.contains(includedFile)) continue;
                return includedFile;
            }
            return null;
        }
    }

    private static class JacocoXmlCoverageHandler
    extends XmlCoverageHandler {
        private JacocoXmlCoverageHandler() {
        }

        @Override
        boolean isApplicable(Document document) {
            return document.getDocumentElement().getTagName().equals("report");
        }

        @Override
        void parseCoverage(Document document, Set<String> includeFiles, CoverageCounters cc, Map<String, List<Integer>> lineCoverage) {
            HashMap<String, SortedMap<Integer, Integer>> internalCounts = new HashMap<String, SortedMap<Integer, Integer>>();
            NodeList packages = document.getElementsByTagName("package");
            for (int i = 0; i < packages.getLength(); ++i) {
                Node packageNode = packages.item(i);
                String packageName = packageNode.getAttributes().getNamedItem("name").getTextContent();
                NodeList children = packageNode.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    String fileName;
                    String finalFileName;
                    Node childNode = children.item(j);
                    if (!childNode.getNodeName().equals("sourcefile") || (finalFileName = CoverageProvider.getRelativePathFromProjectRoot(includeFiles, fileName = packageName + File.separatorChar + childNode.getAttributes().getNamedItem("name").getTextContent())) == null) continue;
                    SortedMap hitCounts = internalCounts.computeIfAbsent(finalFileName, it -> new TreeMap());
                    NodeList coverage = childNode.getChildNodes();
                    for (int k = 0; k < coverage.getLength(); ++k) {
                        Node coverageNode = coverage.item(k);
                        if (coverageNode == null || !"line".equals(coverageNode.getNodeName())) continue;
                        NamedNodeMap attrs = coverageNode.getAttributes();
                        long hitCount = XmlCoverageProvider.getIntValue(attrs, "ci").intValue();
                        int lineNumber = XmlCoverageProvider.getIntValue(attrs, "nr");
                        hitCounts.put(lineNumber, hitCount > 0L ? 1 : 0);
                    }
                }
            }
            this.computeLineCoverage(internalCounts, lineCoverage);
            NodeList children = document.getDocumentElement().getChildNodes();
            block15: for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (!node.getNodeName().equals("counter")) continue;
                NamedNodeMap attrs = node.getAttributes();
                long covered = Long.valueOf(attrs.getNamedItem("covered").getTextContent());
                long missed = Long.valueOf(attrs.getNamedItem("missed").getTextContent());
                switch (attrs.getNamedItem("type").getTextContent()) {
                    case "CLASS": {
                        ((CoverageCounters)cc).cls.covered += covered;
                        ((CoverageCounters)cc).cls.missed += missed;
                        continue block15;
                    }
                    case "METHOD": {
                        ((CoverageCounters)cc).method.covered += covered;
                        ((CoverageCounters)cc).method.missed += missed;
                        continue block15;
                    }
                    case "LINE": {
                        ((CoverageCounters)cc).line.covered += covered;
                        ((CoverageCounters)cc).line.missed += missed;
                        continue block15;
                    }
                    case "BRANCH": {
                        ((CoverageCounters)cc).branch.covered += covered;
                        ((CoverageCounters)cc).branch.missed += missed;
                        continue block15;
                    }
                }
            }
        }
    }

    private static class CoberturaXmlCoverageHandler
    extends XmlCoverageHandler {
        private static final String NODE_FILENAME = "filename";
        private static final String NODE_NAME_LINES = "lines";
        private static final String NODE_NAME_LINE = "line";
        private static final String NODE_NUMBER = "number";
        private static final String NODE_HITS = "hits";
        private static final NodeList EMPTY_NODE_LIST = new NodeList(){

            @Override
            public Node item(int index) {
                return null;
            }

            @Override
            public int getLength() {
                return 0;
            }
        };

        private CoberturaXmlCoverageHandler() {
        }

        @Override
        boolean isApplicable(Document document) {
            Element documentElement = document.getDocumentElement();
            if (!documentElement.getTagName().equals("coverage")) {
                return false;
            }
            NodeList children = documentElement.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (!children.item(i).getNodeName().equals("packages")) continue;
                return true;
            }
            return false;
        }

        @Override
        void parseCoverage(Document document, Set<String> includeFiles, CoverageCounters cc, Map<String, List<Integer>> lineCoverage) {
            int i;
            HashMap<String, SortedMap<Integer, Integer>> internalCounts = new HashMap<String, SortedMap<Integer, Integer>>();
            NodeList classes = document.getElementsByTagName("class");
            ArrayList<String> fileNames = new ArrayList<String>();
            ArrayList<NodeList> childNodes = new ArrayList<NodeList>();
            for (i = 0; i < classes.getLength(); ++i) {
                Node classNode = classes.item(i);
                String fileName = classNode.getAttributes().getNamedItem(NODE_FILENAME).getTextContent();
                String finalFileName = CoverageProvider.getRelativePathFromProjectRoot(includeFiles, fileName);
                if (finalFileName == null) continue;
                fileNames.add(finalFileName);
                childNodes.add(classNode.getChildNodes());
            }
            for (i = 0; i < fileNames.size(); ++i) {
                String fileName = (String)fileNames.get(i);
                SortedMap hitCounts = internalCounts.computeIfAbsent(fileName, it -> new TreeMap());
                NodeList children = (NodeList)childNodes.get(i);
                for (int j = 0; j < children.getLength(); ++j) {
                    Node child = children.item(j);
                    if (!NODE_NAME_LINES.equals(child.getNodeName())) continue;
                    NodeList lines = child.getChildNodes();
                    for (int k = 0; k < lines.getLength(); ++k) {
                        Node line = lines.item(k);
                        if (!NODE_NAME_LINE.equals(line.getNodeName())) continue;
                        NamedNodeMap attrs = line.getAttributes();
                        Integer lineNumber = XmlCoverageProvider.getIntValue(attrs, NODE_NUMBER);
                        hitCounts.put(lineNumber, XmlCoverageProvider.getIntValue(attrs, NODE_HITS));
                    }
                }
            }
            this.computeLineCoverage(internalCounts, lineCoverage);
            Element root = document.getDocumentElement();
            NamedNodeMap attrs = root.getAttributes();
            boolean hasLineCoverageInfo = false;
            if (attrs.getNamedItem("lines-covered") != null) {
                hasLineCoverageInfo = true;
                long linesCovered = XmlCoverageProvider.getLongValue(attrs, "lines-covered");
                long linesValid = XmlCoverageProvider.getLongValue(attrs, "lines-valid");
                ((CoverageCounters)cc).line.covered = linesCovered;
                ((CoverageCounters)cc).line.missed = linesValid - linesCovered;
            } else if (attrs.getNamedItem("line-rate") != null) {
                cc.lineCoveragePercentOverride = Float.valueOf(XmlCoverageProvider.getFloatValue(attrs, "line-rate").floatValue() * 100.0f);
            }
            if (attrs.getNamedItem("branches-covered") != null) {
                long branchesCovered = XmlCoverageProvider.getLongValue(attrs, "branches-covered");
                long branchesValid = XmlCoverageProvider.getLongValue(attrs, "branches-valid");
                ((CoverageCounters)cc).branch.covered = branchesCovered;
                ((CoverageCounters)cc).branch.missed = branchesValid - branchesCovered;
            } else if (attrs.getNamedItem("branch-rate") != null) {
                cc.branchCoveragePercentOverride = Float.valueOf(XmlCoverageProvider.getFloatValue(attrs, "branch-rate").floatValue() * 100.0f);
            }
            NodeList packages = document.getElementsByTagName("package");
            for (int i2 = 0; i2 < packages.getLength(); ++i2) {
                Node packageNode = packages.item(i2);
                NodeList classNodes = CoberturaXmlCoverageHandler.getChildrenWithMatchingTag(packageNode, "classes");
                boolean packageCovered = false;
                for (int j = 0; j < classNodes.getLength(); ++j) {
                    Node classNode = classNodes.item(j);
                    if (!classNode.getNodeName().equals("class")) continue;
                    if (!hasLineCoverageInfo) {
                        NodeList classLines = CoberturaXmlCoverageHandler.getChildrenWithMatchingTag(classNode, NODE_NAME_LINES);
                        for (int l = 0; l < classLines.getLength(); ++l) {
                            Node lineNode = classLines.item(l);
                            if (!lineNode.getNodeName().equals(NODE_NAME_LINE)) continue;
                            int hits = XmlCoverageProvider.getIntValue(lineNode.getAttributes(), NODE_HITS);
                            if (hits > 0) {
                                ++((CoverageCounters)cc).line.covered;
                                continue;
                            }
                            ++((CoverageCounters)cc).line.missed;
                        }
                    }
                    NodeList methods = CoberturaXmlCoverageHandler.getChildrenWithMatchingTag(classNode, "methods");
                    boolean classCovered = false;
                    for (int k = 0; k < methods.getLength(); ++k) {
                        Node methodNode = methods.item(k);
                        if (!methodNode.getNodeName().equals("method")) continue;
                        NodeList lines = CoberturaXmlCoverageHandler.getChildrenWithMatchingTag(methodNode, NODE_NAME_LINES);
                        boolean methodCovered = false;
                        for (int l = 0; l < lines.getLength(); ++l) {
                            int hits;
                            Node lineNode = lines.item(l);
                            if (!lineNode.getNodeName().equals(NODE_NAME_LINE) || (hits = XmlCoverageProvider.getIntValue(lineNode.getAttributes(), NODE_HITS).intValue()) <= 0) continue;
                            methodCovered = true;
                            break;
                        }
                        if (methodCovered) {
                            ++((CoverageCounters)cc).method.covered;
                            classCovered = true;
                            continue;
                        }
                        ++((CoverageCounters)cc).method.missed;
                    }
                    if (classCovered) {
                        ++((CoverageCounters)cc).cls.covered;
                        packageCovered = true;
                        continue;
                    }
                    ++((CoverageCounters)cc).cls.missed;
                }
                if (packageCovered) {
                    ++((CoverageCounters)cc).pkg.covered;
                    continue;
                }
                ++((CoverageCounters)cc).pkg.missed;
            }
        }

        private static NodeList getChildrenWithMatchingTag(Node node, String tag) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (!children.item(i).getNodeName().equals(tag)) continue;
                return children.item(i).getChildNodes();
            }
            return EMPTY_NODE_LIST;
        }
    }

    private static abstract class XmlCoverageHandler {
        private XmlCoverageHandler() {
        }

        abstract boolean isApplicable(Document var1);

        abstract void parseCoverage(Document var1, Set<String> var2, CoverageCounters var3, Map<String, List<Integer>> var4);

        void computeLineCoverage(Map<String, SortedMap<Integer, Integer>> internalCounts, Map<String, List<Integer>> lineCoverage) {
            for (Map.Entry<String, SortedMap<Integer, Integer>> entry : internalCounts.entrySet()) {
                ArrayList<Integer> sortedCounts = new ArrayList<Integer>();
                int startIndex = 1;
                for (Map.Entry<Integer, Integer> line : entry.getValue().entrySet()) {
                    for (int i = startIndex; i < line.getKey(); ++i) {
                        sortedCounts.add(null);
                        ++startIndex;
                    }
                    sortedCounts.add(line.getValue());
                    ++startIndex;
                }
                lineCoverage.put(entry.getKey(), sortedCounts);
            }
        }
    }
}

