/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.coverage;

import com.google.common.annotations.VisibleForTesting;
import com.uber.jenkins.phabricator.coverage.CodeCoverageMetrics;
import com.uber.jenkins.phabricator.coverage.XmlCoverageProvider;
import hudson.plugins.jacoco.JacocoBuildAction;
import hudson.plugins.jacoco.report.CoverageReport;
import java.io.File;
import java.util.Set;

public class JacocoPluginCoverageProvider
extends XmlCoverageProvider {
    private final JacocoBuildAction buildAction;

    public JacocoPluginCoverageProvider(Set<File> coverageReports, Set<String> includeFiles, JacocoBuildAction buildAction) {
        super(coverageReports, includeFiles);
        this.buildAction = buildAction;
    }

    @Override
    protected void computeMetrics() {
        CoverageReport coverageResult = this.buildAction.getResult();
        this.metrics = JacocoPluginCoverageProvider.convertJacoco(coverageResult);
    }

    @VisibleForTesting
    static CodeCoverageMetrics convertJacoco(CoverageReport coverageResult) {
        if (coverageResult == null) {
            return null;
        }
        float methodCoverage = coverageResult.getMethodCoverage().getPercentageFloat();
        float classCoverage = coverageResult.getClassCoverage().getPercentageFloat();
        float lineCoverage = coverageResult.getLineCoverage().getPercentageFloat();
        float branchCoverage = coverageResult.getBranchCoverage().getPercentageFloat();
        long linesCovered = coverageResult.getLineCoverage().getCovered();
        long linesTested = coverageResult.getLineCoverage().getTotal();
        return new CodeCoverageMetrics(-1.0f, -1.0f, classCoverage, methodCoverage, lineCoverage, branchCoverage, linesCovered, linesTested);
    }
}

