/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.conduit;

import com.uber.jenkins.phabricator.conduit.ConduitAPIClient;
import com.uber.jenkins.phabricator.conduit.ConduitAPIException;
import com.uber.jenkins.phabricator.lint.LintResults;
import com.uber.jenkins.phabricator.unit.UnitResults;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import net.sf.json.JSONObject;

public class HarbormasterClient {
    private final ConduitAPIClient conduit;

    public HarbormasterClient(ConduitAPIClient conduit) {
        this.conduit = conduit;
    }

    public JSONObject sendHarbormasterMessage(String phid, MessageType messageType, UnitResults unitResults, Map<String, String> coverage, LintResults lintResults) throws ConduitAPIException, IOException {
        ArrayList<JSONObject> unit = new ArrayList<JSONObject>();
        if (unitResults != null) {
            unit.addAll(unitResults.toHarbormaster());
        }
        ArrayList<JSONObject> lint = new ArrayList<JSONObject>();
        if (lintResults != null) {
            lint.addAll(lintResults.toHarbormaster());
        }
        if (coverage != null) {
            JSONObject coverageUnit = new JSONObject().element("result", (Object)"pass").element("name", (Object)"Coverage Data").element("coverage", coverage);
            unit.add(coverageUnit);
        }
        JSONObject params = new JSONObject();
        params.element("type", (Object)messageType.name()).element("buildTargetPHID", (Object)phid);
        if (!unit.isEmpty()) {
            params.element("unit", unit);
        }
        if (!lint.isEmpty()) {
            params.element("lint", lint);
        }
        return this.conduit.perform("harbormaster.sendmessage", params);
    }

    public JSONObject sendHarbormasterUri(String phid, String buildUri) throws ConduitAPIException, IOException {
        JSONObject artifactData = new JSONObject();
        artifactData = artifactData.element("uri", (Object)buildUri).element("name", (Object)"Jenkins").element("ui.external", true);
        JSONObject params = new JSONObject();
        params.element("buildTargetPHID", (Object)phid).element("artifactKey", (Object)"jenkins.uri").element("artifactType", (Object)"uri").element("artifactData", (Map)artifactData);
        return this.conduit.perform("harbormaster.createartifact", params);
    }

    public static enum MessageType {
        pass,
        fail,
        work;

    }
}

