/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator.conduit;

import com.uber.jenkins.phabricator.utils.CommonUtils;
import hudson.Launcher;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class ArcanistClient {
    private final String arcPath;
    private final String methodName;
    private final String conduitUrl;
    private final String conduitToken;
    private final String[] arguments;

    public ArcanistClient(String arcPath, String methodName, String conduitUrl, String conduitToken, String ... arguments) {
        this.arcPath = arcPath;
        this.methodName = methodName;
        this.conduitUrl = conduitUrl;
        this.conduitToken = conduitToken;
        this.arguments = arguments;
    }

    private ArgumentListBuilder getConduitCommand() {
        ArgumentListBuilder builder = new ArgumentListBuilder(new String[]{this.arcPath, this.methodName});
        builder.add(this.arguments);
        if (!CommonUtils.isBlank(this.conduitUrl)) {
            builder.add("--conduit-uri=" + this.conduitUrl);
        }
        if (!CommonUtils.isBlank(this.conduitToken)) {
            builder.addMasked("--conduit-token=" + this.conduitToken);
        }
        return builder;
    }

    private Launcher.ProcStarter getCommand(Launcher.ProcStarter starter) throws IOException {
        return starter.cmds(this.getConduitCommand());
    }

    public int callConduit(Launcher.ProcStarter starter, PrintStream stderr) throws IOException, InterruptedException {
        Launcher.ProcStarter command = this.getCommand(starter);
        return command.stdout((OutputStream)stderr).stderr((OutputStream)stderr).join();
    }
}

