/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator;

import com.google.common.annotations.VisibleForTesting;
import com.uber.jenkins.phabricator.LauncherFactory;
import com.uber.jenkins.phabricator.PhabricatorBuildWrapperDescriptor;
import com.uber.jenkins.phabricator.PhabricatorCauseOfInterruption;
import com.uber.jenkins.phabricator.PhabricatorPostbuildAction;
import com.uber.jenkins.phabricator.conduit.ConduitAPIClient;
import com.uber.jenkins.phabricator.conduit.ConduitAPIException;
import com.uber.jenkins.phabricator.conduit.Differential;
import com.uber.jenkins.phabricator.conduit.DifferentialClient;
import com.uber.jenkins.phabricator.conduit.HarbormasterClient;
import com.uber.jenkins.phabricator.credentials.ConduitCredentials;
import com.uber.jenkins.phabricator.tasks.ApplyPatchTask;
import com.uber.jenkins.phabricator.tasks.SendHarbormasterResultTask;
import com.uber.jenkins.phabricator.tasks.SendHarbormasterUriTask;
import com.uber.jenkins.phabricator.tasks.Task;
import com.uber.jenkins.phabricator.utils.CommonUtils;
import com.uber.jenkins.phabricator.utils.Logger;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.util.RunList;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.CauseOfInterruption;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PhabricatorBuildWrapper
extends BuildWrapper {
    private static final String CONDUIT_TAG = "conduit";
    private static final String DIFFERENTIAL_SUMMARY = "PHABRICATOR_DIFFERENTIAL_SUMMARY";
    private static final String DIFFERENTIAL_AUTHOR = "PHABRICATOR_DIFFERENTIAL_AUTHOR";
    private static final String DIFFERENTIAL_BASE_COMMIT = "PHABRICATOR_DIFFERENTIAL_BASE_COMMIT";
    private static final String DIFFERENTIAL_BRANCH = "PHABRICATOR_DIFFERENTIAL_BRANCH";
    private static final String DEFAULT_GIT_BRANCH = "origin/master";
    private static final String DEFAULT_HG_BRANCH = "default";
    private final boolean createCommit;
    private final boolean applyToMaster;
    private final boolean skipForcedClean;
    private final boolean createBranch;
    private final boolean patchWithForceFlag;
    private final boolean skipApplyPatch;
    private String workDir;
    private String scmType;

    @DataBoundConstructor
    public PhabricatorBuildWrapper(boolean createCommit, boolean applyToMaster, boolean skipForcedClean, boolean createBranch, boolean patchWithForceFlag, boolean skipApplyPatch) {
        this.createCommit = createCommit;
        this.applyToMaster = applyToMaster;
        this.skipForcedClean = skipForcedClean;
        this.createBranch = createBranch;
        this.patchWithForceFlag = patchWithForceFlag;
        this.skipApplyPatch = skipApplyPatch;
        this.workDir = null;
        this.scmType = "git";
    }

    @VisibleForTesting
    static String getAbortOnRevisionId(AbstractBuild build) {
        ParameterValue parameterValue;
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null && (parameterValue = parameters.getParameter("ABORT_ON_REVISION_ID")) != null) {
            return (String)parameterValue.getValue();
        }
        return null;
    }

    @VisibleForTesting
    static Run<?, ?> getUpstreamRun(AbstractBuild build) {
        Cause.UpstreamCause upstreamCause;
        CauseAction action = (CauseAction)build.getAction(CauseAction.class);
        if (action != null && (upstreamCause = (Cause.UpstreamCause)action.findCause(Cause.UpstreamCause.class)) != null) {
            return upstreamCause.getUpstreamRun();
        }
        return null;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        Differential diff;
        ConduitAPIClient conduitClient;
        EnvVars environment = build.getEnvironment((TaskListener)listener);
        Logger logger = new Logger(listener.getLogger());
        if (environment == null) {
            return this.ignoreBuild(logger, "No environment variables found?!");
        }
        final HashMap<String, String> envAdditions = new HashMap<String, String>();
        String phid = (String)environment.get((Object)"PHID");
        String diffID = (String)environment.get((Object)"DIFF_ID");
        if (CommonUtils.isBlank(diffID)) {
            this.addShortText(build);
            this.ignoreBuild(logger, "No differential ID found.");
            return new BuildWrapper.Environment(){};
        }
        FilePath arcWorkPath = this.workDir != null && this.workDir.length() > 0 ? build.getWorkspace().child(this.workDir) : build.getWorkspace();
        LauncherFactory starter = new LauncherFactory(launcher, environment, listener.getLogger(), arcWorkPath);
        try {
            conduitClient = this.getConduitClient(build.getParent(), logger);
        }
        catch (ConduitAPIException e) {
            e.printStackTrace(logger.getStream());
            logger.warn(CONDUIT_TAG, e.getMessage());
            return null;
        }
        DifferentialClient diffClient = new DifferentialClient(diffID, conduitClient);
        if (!CommonUtils.isBlank(phid)) {
            logger.info("harbormaster", "Sending Harbormaster BUILD_URL via PHID: " + phid);
            String buildUrl = (String)environment.get((Object)"BUILD_URL");
            Task.Result sendUriResult = new SendHarbormasterUriTask(logger, diffClient, phid, buildUrl).run();
            if (sendUriResult != Task.Result.SUCCESS) {
                logger.info("harbormaster", "Unable to send BUILD_URL to Harbormaster");
            } else {
                logger.info("harbormaster", "Harbormaster BUILD_URL sent");
            }
        }
        try {
            logger.info(CONDUIT_TAG, "Fetching differential from Conduit API");
            diff = new Differential(diffClient.fetchDiff());
            logger.info(CONDUIT_TAG, "Differential fetched from Conduit API");
            String revisionID = diff.getRevisionID(false);
            logger.info(CONDUIT_TAG, "Fetching commit from Conduit API");
            diff.setCommitMessage(diffClient.getCommitMessage(revisionID));
            logger.info(CONDUIT_TAG, "Fetched commit from Conduit API");
            diff.decorate((Run<?, ?>)build, this.getPhabricatorURL(build.getParent()));
            envAdditions.put(DIFFERENTIAL_AUTHOR, diff.getAuthorEmail());
            envAdditions.put(DIFFERENTIAL_BASE_COMMIT, diff.getBaseCommit());
            envAdditions.put(DIFFERENTIAL_BRANCH, diff.getBranch());
            envAdditions.put(DIFFERENTIAL_SUMMARY, diff.getCommitMessage());
        }
        catch (ConduitAPIException e) {
            e.printStackTrace(logger.getStream());
            logger.warn(CONDUIT_TAG, "Unable to fetch differential from Conduit API");
            logger.warn(CONDUIT_TAG, e.getMessage());
            return null;
        }
        if (this.skipApplyPatch) {
            logger.info("arcanist", "Skipping applying arc patch as configured in job");
        } else {
            String baseCommit = DEFAULT_GIT_BRANCH;
            if ("hg".equals(this.scmType)) {
                baseCommit = DEFAULT_HG_BRANCH;
            }
            if (!this.applyToMaster) {
                baseCommit = diff.getBaseCommit();
            }
            String conduitToken = this.getConduitToken(build.getParent(), logger);
            String conduitUrl = this.getPhabricatorURL(build.getParent());
            Task.Result result = new ApplyPatchTask(logger, starter, baseCommit, diffID, conduitUrl, conduitToken, this.getArcPath(), this.createCommit, this.skipForcedClean, this.createBranch, this.patchWithForceFlag, this.scmType).run();
            if (result != Task.Result.SUCCESS) {
                logger.warn("arcanist", "Error applying arc patch; got non-zero exit code " + (Object)((Object)result));
                Task.Result failureResult = new SendHarbormasterResultTask(logger, diffClient, phid, HarbormasterClient.MessageType.fail, null, null, null).run();
                if (failureResult != Task.Result.SUCCESS) {
                    logger.warn("arcanist", "Unable to notify harbormaster of patch failure");
                }
                return null;
            }
        }
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                EnvVars envVars = new EnvVars(env);
                envVars.putAll(envAdditions);
                env.putAll((Map<String, String>)envVars);
            }
        };
    }

    public void preCheckout(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        String abortOnRevisionId = PhabricatorBuildWrapper.getAbortOnRevisionId(build);
        if (!CommonUtils.isBlank(abortOnRevisionId)) {
            PhabricatorCauseOfInterruption causeOfInterruption = new PhabricatorCauseOfInterruption(build.getUrl());
            Run<?, ?> upstreamRun = PhabricatorBuildWrapper.getUpstreamRun(build);
            RunList runningBuilds = build.getProject().getBuilds();
            for (AbstractBuild runningBuild : runningBuilds) {
                Executor executor = runningBuild.getExecutor();
                Run<?, ?> runningBuildUpstreamRun = PhabricatorBuildWrapper.getUpstreamRun(runningBuild);
                if (!runningBuild.isBuilding() || runningBuild.number >= build.number || !abortOnRevisionId.equals(PhabricatorBuildWrapper.getAbortOnRevisionId(runningBuild)) || upstreamRun != null && runningBuildUpstreamRun != null && upstreamRun.equals(runningBuildUpstreamRun) || executor == null) continue;
                executor.interrupt(Result.ABORTED, new CauseOfInterruption[]{causeOfInterruption});
            }
        }
    }

    protected Object readResolve() {
        if (this.scmType == null) {
            this.scmType = "git";
        }
        return this;
    }

    private void addShortText(AbstractBuild build) {
        build.addAction((Action)PhabricatorPostbuildAction.createShortText("master", null));
    }

    private BuildWrapper.Environment ignoreBuild(Logger logger, String message) {
        logger.info("ignore-build", message);
        return new BuildWrapper.Environment(){};
    }

    private ConduitAPIClient getConduitClient(Job owner, Logger logger) throws ConduitAPIException {
        ConduitCredentials credentials = this.getConduitCredentials(owner);
        if (credentials == null) {
            throw new ConduitAPIException("No credentials configured for conduit");
        }
        return new ConduitAPIClient(credentials.getGateway(), this.getConduitToken(owner, logger));
    }

    private ConduitCredentials getConduitCredentials(Job owner) {
        return this.getDescriptor().getCredentials(owner);
    }

    public boolean isCreateCommit() {
        return this.createCommit;
    }

    public boolean isApplyToMaster() {
        return this.applyToMaster;
    }

    public boolean isCreateBranch() {
        return this.createBranch;
    }

    public boolean isPatchWithForceFlag() {
        return this.patchWithForceFlag;
    }

    public boolean isSkipApplyPatch() {
        return this.skipApplyPatch;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    @DataBoundSetter
    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public String getScmType() {
        return this.scmType;
    }

    @DataBoundSetter
    public void setScmType(String scmType) {
        this.scmType = scmType;
    }

    private String getPhabricatorURL(Job owner) {
        ConduitCredentials credentials = this.getConduitCredentials(owner);
        if (credentials != null) {
            return credentials.getUrl();
        }
        return null;
    }

    private String getConduitToken(Job owner, Logger logger) {
        ConduitCredentials credentials = this.getConduitCredentials(owner);
        if (credentials != null) {
            return credentials.getToken().getPlainText();
        }
        logger.warn("credentials", "No credentials configured.");
        return null;
    }

    private String getArcPath() {
        String providedPath = this.getDescriptor().getArcPath();
        if (CommonUtils.isBlank(providedPath)) {
            return "arc";
        }
        return providedPath;
    }

    public PhabricatorBuildWrapperDescriptor getDescriptor() {
        return (PhabricatorBuildWrapperDescriptor)super.getDescriptor();
    }
}

