/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator;

import com.uber.jenkins.phabricator.CoverageCheckSettings;
import com.uber.jenkins.phabricator.coverage.CodeCoverageMetrics;
import com.uber.jenkins.phabricator.utils.CommonUtils;
import com.uber.jenkins.phabricator.utils.Logger;
import hudson.model.Result;

class CommentBuilder {
    private static final String UBERALLS_TAG = "uberalls";
    private final Logger logger;
    private final CodeCoverageMetrics currentCoverage;
    private final StringBuilder comment;
    private final String buildURL;
    private final boolean preserveFormatting;
    private final CoverageCheckSettings coverageCheckSettings;

    CommentBuilder(Logger logger, CodeCoverageMetrics currentCoverage, String buildURL, boolean preserveFormatting, CoverageCheckSettings coverageCheckSettings) {
        this.logger = logger;
        this.currentCoverage = currentCoverage;
        this.buildURL = buildURL;
        this.preserveFormatting = preserveFormatting;
        this.coverageCheckSettings = coverageCheckSettings;
        this.comment = new StringBuilder();
    }

    String getComment() {
        return this.comment.toString();
    }

    boolean hasCoverageAvailable() {
        return this.currentCoverage != null && this.currentCoverage.getLineCoveragePercent() > 0.0f;
    }

    boolean processParentCoverage(CodeCoverageMetrics parentCoverage, String baseCommit, String branchName) {
        boolean passCoverage = true;
        if (parentCoverage == null) {
            this.logger.info(UBERALLS_TAG, "unable to find coverage for parent commit");
            return passCoverage;
        }
        Float lineCoveragePercent = Float.valueOf(this.currentCoverage.getLineCoveragePercent());
        this.logger.info(UBERALLS_TAG, "line coverage: " + lineCoveragePercent);
        this.logger.info(UBERALLS_TAG, "found parent coverage as " + parentCoverage.getLineCoveragePercent());
        double coverageDelta = lineCoveragePercent.floatValue() - parentCoverage.getLineCoveragePercent();
        String coverageDeltaDisplay = String.format("%.3f", coverageDelta);
        String lineCoverageDisplay = String.format("%.3f", lineCoveragePercent);
        if (coverageDelta > 0.0) {
            this.comment.append("Coverage increased (+" + coverageDeltaDisplay + "%) to " + lineCoverageDisplay + "%");
        } else if (coverageDelta < 0.0) {
            this.comment.append("Coverage decreased (" + coverageDeltaDisplay + "%) to " + lineCoverageDisplay + "%");
        } else {
            this.comment.append("Coverage remained the same (" + lineCoverageDisplay + "%)");
        }
        this.comment.append(" when pulling **" + branchName + "** into ");
        this.comment.append(baseCommit.substring(0, 7));
        this.comment.append(".");
        if (this.isBuildFailingCoverageCheck(lineCoveragePercent.floatValue(), coverageDelta)) {
            passCoverage = false;
            String message = "Build failed because coverage is lower than minimum " + this.coverageCheckSettings.getMinCoverageInPercent() + "% and decreased more than allowed " + Math.abs(this.coverageCheckSettings.getMaxCoverageDecreaseInPercent()) + "%";
            this.logger.info(UBERALLS_TAG, message);
            this.comment.append("\n");
            this.comment.append(message);
            this.comment.append(".");
        }
        return passCoverage;
    }

    private boolean isBuildFailingCoverageCheck(double lineCoveragePercent, double coverageDelta) {
        return this.coverageCheckSettings != null && this.coverageCheckSettings.isCoverageCheckEnabled() && lineCoveragePercent < this.coverageCheckSettings.getMinCoverageInPercent() && coverageDelta < 0.0 && Math.abs(coverageDelta) > Math.abs(this.coverageCheckSettings.getMaxCoverageDecreaseInPercent());
    }

    void processBuildResult(Result result, boolean commentOnSuccess, boolean commentWithConsoleLinkOnFailure, boolean runHarbormaster) {
        if (result == Result.SUCCESS) {
            if (this.comment.length() == 0 && (commentOnSuccess || !runHarbormaster)) {
                this.comment.append("Build is green");
            }
        } else if (result == Result.UNSTABLE) {
            this.comment.append("Build is unstable");
        } else if (result == Result.FAILURE) {
            if (!runHarbormaster || commentWithConsoleLinkOnFailure) {
                this.comment.append("Build has FAILED");
            }
        } else if (result == Result.ABORTED) {
            this.comment.append("Build was aborted");
        } else {
            this.logger.info(UBERALLS_TAG, "Unknown build status " + result.toString());
        }
    }

    void addUserComment(String customComment) {
        if (CommonUtils.isBlank(customComment)) {
            return;
        }
        if (this.hasComment()) {
            this.comment.append("\n\n");
        }
        if (this.preserveFormatting) {
            this.comment.append(String.format("%s\n", customComment));
        } else {
            this.comment.append(String.format("```\n%s\n```\n\n", customComment));
        }
    }

    boolean hasComment() {
        return this.comment.length() > 0;
    }

    void addBuildLink() {
        this.comment.append(String.format("\nSee %s for more details.", this.buildURL));
    }

    void addBuildFailureMessage() {
        this.comment.append(String.format("\n\nLink to build: %s", this.buildURL));
        this.comment.append(String.format("\nSee console output for more information: %sconsole", this.buildURL));
    }
}

