/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jenkins.phabricator;

import com.uber.jenkins.phabricator.CommentBuilder;
import com.uber.jenkins.phabricator.CoverageCheckSettings;
import com.uber.jenkins.phabricator.RemoteFileFetcher;
import com.uber.jenkins.phabricator.conduit.Differential;
import com.uber.jenkins.phabricator.conduit.DifferentialClient;
import com.uber.jenkins.phabricator.conduit.HarbormasterClient;
import com.uber.jenkins.phabricator.coverage.CodeCoverageMetrics;
import com.uber.jenkins.phabricator.coverage.CoverageConverter;
import com.uber.jenkins.phabricator.coverage.CoverageProvider;
import com.uber.jenkins.phabricator.lint.LintResult;
import com.uber.jenkins.phabricator.lint.LintResults;
import com.uber.jenkins.phabricator.tasks.PostCommentTask;
import com.uber.jenkins.phabricator.tasks.SendHarbormasterResultTask;
import com.uber.jenkins.phabricator.tasks.SendHarbormasterUriTask;
import com.uber.jenkins.phabricator.tasks.Task;
import com.uber.jenkins.phabricator.uberalls.UberallsClient;
import com.uber.jenkins.phabricator.unit.UnitResults;
import com.uber.jenkins.phabricator.unit.UnitTestProvider;
import com.uber.jenkins.phabricator.utils.CommonUtils;
import com.uber.jenkins.phabricator.utils.Logger;
import hudson.FilePath;
import hudson.model.Result;
import hudson.model.Run;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class BuildResultProcessor {
    private static final String LOGGING_TAG = "process-build-result";
    private final Logger logger;
    private final Differential diff;
    private final DifferentialClient diffClient;
    private final String phid;
    private final String buildUrl;
    private final boolean runHarbormaster;
    private final FilePath workspace;
    private final Run<?, ?> build;
    private final CommentBuilder commenter;
    private String commentAction;
    private UnitResults unitResults;
    private Map<String, String> harbormasterCoverage;
    private LintResults lintResults;

    public BuildResultProcessor(Logger logger, Run<?, ?> build, FilePath workspace, Differential diff, DifferentialClient diffClient, String phid, CodeCoverageMetrics coverageResult, String buildUrl, boolean preserveFormatting, CoverageCheckSettings coverageCheckSettings) {
        this.logger = logger;
        this.diff = diff;
        this.diffClient = diffClient;
        this.phid = phid;
        this.buildUrl = buildUrl;
        this.build = build;
        this.workspace = workspace;
        this.commentAction = "none";
        this.commenter = new CommentBuilder(logger, coverageResult, buildUrl, preserveFormatting, coverageCheckSettings);
        this.runHarbormaster = !CommonUtils.isBlank(phid);
    }

    public Result getBuildResult() {
        if (this.build.getResult() == null) {
            return Result.SUCCESS;
        }
        return this.build.getResult();
    }

    public boolean processParentCoverage(UberallsClient uberalls) {
        boolean passBuild = true;
        if (this.commenter.hasCoverageAvailable()) {
            if (uberalls.isConfigured()) {
                passBuild = this.commenter.processParentCoverage(uberalls.getParentCoverage(this.diff.getBaseCommit()), this.diff.getBaseCommit(), this.diff.getBranch());
            } else {
                this.logger.info(LOGGING_TAG, "No Uberalls backend configured, skipping...");
            }
        } else {
            this.logger.info(LOGGING_TAG, "No line coverage found, skipping...");
        }
        return passBuild;
    }

    public void processBuildResult(boolean commentOnSuccess, boolean commentWithConsoleLinkOnFailure) {
        this.commenter.processBuildResult(this.getBuildResult(), commentOnSuccess, commentWithConsoleLinkOnFailure, this.runHarbormaster);
    }

    public void processRemoteComment(String commentFile, String commentSize) {
        RemoteFileFetcher commentFetcher = new RemoteFileFetcher(this.workspace, this.logger, commentFile, commentSize);
        try {
            String customComment = commentFetcher.getRemoteFile();
            this.commenter.addUserComment(customComment);
        }
        catch (InterruptedException e) {
            e.printStackTrace(this.logger.getStream());
        }
        catch (IOException e) {
            e.printStackTrace(this.logger.getStream());
        }
    }

    public void processLintResults(String lintFile, String lintFileSize) {
        RemoteFileFetcher lintFetcher = new RemoteFileFetcher(this.workspace, this.logger, lintFile, lintFileSize);
        try {
            String input = lintFetcher.getRemoteFile();
            if (input != null && input.length() > 0) {
                String line;
                this.lintResults = new LintResults();
                BufferedReader reader = new BufferedReader(new StringReader(input));
                String lint = "";
                while ((line = reader.readLine()) != null) {
                    lint = lint + line;
                    try {
                        JSONObject json = JSONObject.fromObject((Object)lint);
                        this.lintResults.add(LintResult.fromJsonObject(json));
                        lint = "";
                    }
                    catch (JSONException e) {
                        e.printStackTrace(this.logger.getStream());
                    }
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace(this.logger.getStream());
        }
        catch (IOException e) {
            e.printStackTrace(this.logger.getStream());
        }
    }

    public void sendComment(boolean commentWithConsoleLinkOnFailure) {
        if (!this.commenter.hasComment()) {
            return;
        }
        if (commentWithConsoleLinkOnFailure && this.getBuildResult().isWorseOrEqualTo(Result.UNSTABLE)) {
            this.commenter.addBuildFailureMessage();
        } else {
            this.commenter.addBuildLink();
        }
        new PostCommentTask(this.logger, this.diffClient, this.diff.getRevisionID(false), this.commenter.getComment(), this.commentAction).run();
    }

    public boolean processHarbormaster(boolean sendPartialResults) {
        HarbormasterClient.MessageType messageType = sendPartialResults ? HarbormasterClient.MessageType.work : (this.getBuildResult().isBetterOrEqualTo(Result.SUCCESS) ? HarbormasterClient.MessageType.pass : HarbormasterClient.MessageType.fail);
        if (this.runHarbormaster) {
            this.logger.info("harbormaster", "Sending Harbormaster BUILD_URL via PHID: " + this.phid);
            Task.Result sendUriResult = new SendHarbormasterUriTask(this.logger, this.diffClient, this.phid, this.buildUrl).run();
            if (sendUriResult != Task.Result.SUCCESS) {
                this.logger.info(LOGGING_TAG, "Unable to send BUILD_URL to Harbormaster. This can be safely ignored, and is usually because it's already set.");
            }
            if (this.unitResults != null) {
                this.logger.info(LOGGING_TAG, String.format("Publishing unit results to Harbormaster for %d tests.", this.unitResults.getResults().size()));
            }
            if (this.harbormasterCoverage != null) {
                this.logger.info(LOGGING_TAG, String.format("Publishing coverage data to Harbormaster for %d files.", this.harbormasterCoverage.size()));
            }
            if (this.lintResults != null) {
                this.logger.info(LOGGING_TAG, String.format("Publishing lint results for %d violations", this.lintResults.getResults().size()));
            }
            this.logger.info(LOGGING_TAG, String.format("Sending build result to Harbormaster with PHID %s, message type: %s", this.phid, messageType.name()));
            Task.Result result = new SendHarbormasterResultTask(this.logger, this.diffClient, this.phid, messageType, this.unitResults, this.harbormasterCoverage, this.lintResults).run();
            if (result != Task.Result.SUCCESS) {
                return false;
            }
        } else {
            this.logger.info("uberalls", "Harbormaster integration not enabled for this build.");
            if (this.getBuildResult().isBetterOrEqualTo(Result.SUCCESS)) {
                this.commentAction = "resign";
            } else if (this.getBuildResult().isWorseOrEqualTo(Result.UNSTABLE)) {
                this.commentAction = "reject";
            }
        }
        return true;
    }

    public void processUnitResults(UnitTestProvider unitProvider) {
        if (unitProvider == null) {
            this.logger.info(LOGGING_TAG, "No unit provider available.");
            return;
        }
        if (!unitProvider.resultsAvailable()) {
            this.logger.info(LOGGING_TAG, "No unit results available.");
            return;
        }
        this.unitResults = unitProvider.getResults();
    }

    void processCoverage(CoverageProvider coverageProvider) {
        if (coverageProvider == null) {
            this.logger.info(LOGGING_TAG, "No coverage provider available.");
            return;
        }
        Map<String, List<Integer>> lineCoverage = coverageProvider.getLineCoverage();
        if (lineCoverage == null || lineCoverage.isEmpty()) {
            this.logger.info(LOGGING_TAG, "No line coverage available to post to Harbormaster.");
            return;
        }
        this.harbormasterCoverage = CoverageConverter.convert(lineCoverage);
    }

    public Map<String, String> getCoverage() {
        return this.harbormasterCoverage;
    }

    public UnitResults getUnitResults() {
        return this.unitResults;
    }

    public LintResults getLintResults() {
        return this.lintResults;
    }
}

