/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import com.google.common.annotations.VisibleForTesting;
import hudson.plugins.performance.parsers.IagoParser;
import hudson.plugins.performance.parsers.JMeterCsvParser;
import hudson.plugins.performance.parsers.JMeterParser;
import hudson.plugins.performance.parsers.JUnitParser;
import hudson.plugins.performance.parsers.JmeterSummarizerParser;
import hudson.plugins.performance.parsers.LoadRunnerParser;
import hudson.plugins.performance.parsers.LocustParser;
import hudson.plugins.performance.parsers.TaurusParser;
import hudson.plugins.performance.parsers.WrkSummarizerParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ParserDetector {
    private ParserDetector() {
    }

    public static String detect(String reportPath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(reportPath)));){
            String line = reader.readLine();
            if (line == null) {
                throw new IllegalArgumentException("File " + reportPath + " is empty");
            }
            if (line.startsWith("<?xml")) {
                String string = ParserDetector.detectXMLFileType(reportPath);
                return string;
            }
            if (ParserDetector.isIagoFileType(line)) {
                String string = IagoParser.class.getSimpleName();
                return string;
            }
            if (ParserDetector.isWRKFileType(line)) {
                String string = WrkSummarizerParser.class.getSimpleName();
                return string;
            }
            if (ParserDetector.isJMeterCSVFileType(line)) {
                String string = JMeterCsvParser.class.getSimpleName();
                return string;
            }
            if (ParserDetector.isJMeterSummarizerFileType(line, reader)) {
                String string = JmeterSummarizerParser.class.getSimpleName();
                return string;
            }
            if (ParserDetector.isLoadRunnerFileType(line)) {
                String string = LoadRunnerParser.class.getSimpleName();
                return string;
            }
            if (ParserDetector.isLocustFileType(line)) {
                String string = LocustParser.class.getSimpleName();
                return string;
            }
            String string = ParserDetector.detectXMLFileType(reportPath);
            return string;
        }
    }

    private static boolean isIagoFileType(String line) {
        String patternString = "INF \\[.*\\] stats:.*";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(line);
        return matcher.matches();
    }

    private static boolean isWRKFileType(String line) {
        String patternString = "Running .*s test @.*";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(line);
        return matcher.matches();
    }

    private static boolean isJMeterCSVFileType(String header) {
        String line = header.toLowerCase();
        return line.contains("timestamp") && line.contains("elapsed") && (line.contains("url") || line.contains("label"));
    }

    private static boolean isJMeterSummarizerFileType(String firstLine, BufferedReader reader) throws IOException {
        String line = firstLine;
        String pattern = "Summariser: Generate Summary Results";
        if (line.contains(pattern)) {
            return true;
        }
        line = reader.readLine();
        while (line != null) {
            if (line.contains(pattern)) {
                return true;
            }
            line = reader.readLine();
        }
        return false;
    }

    private static boolean isLoadRunnerFileType(String line) {
        String pattern = new String(new char[]{'\u0000', '\u0001', '\u0000', '\u0000'}) + "Standard Jet DB";
        return line.length() > pattern.length() && pattern.equals(line.substring(0, pattern.length()));
    }

    private static String detectXMLFileType(String reportPath) throws IOException {
        String string;
        FileInputStream in = new FileInputStream(reportPath);
        try {
            string = ParserDetector.detectXMLFileType(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new IllegalStateException("XML parsing error: ", ex);
            }
        }
        ((InputStream)in).close();
        return string;
    }

    @VisibleForTesting
    protected static String detectXMLFileType(InputStream in) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
        while (eventReader.hasNext()) {
            String name;
            XMLEvent event = eventReader.nextEvent();
            if (!event.isStartElement()) continue;
            StartElement startElement = event.asStartElement();
            switch (name = startElement.getName().getLocalPart()) {
                case "testResults": {
                    return JMeterParser.class.getSimpleName();
                }
                case "testsuite": 
                case "testsuites": {
                    return JUnitParser.class.getSimpleName();
                }
                case "FinalStatus": {
                    return TaurusParser.class.getSimpleName();
                }
            }
            throw new IllegalArgumentException("Unknown xml file format");
        }
        throw new IllegalStateException("XML parsing error: no start element");
    }

    private static boolean isLocustFileType(String line) {
        Object[] fileLineHeader = line.replaceAll("\"", "").split(",");
        Object[] expectedHeaderFields = new String[]{"Method", "Name", "# requests", "# failures", "Median response time", "Average response time", "Min response time", "Max response time", "Average Content Size", "Requests/s"};
        return Arrays.equals(fileLineHeader, expectedHeaderFields);
    }
}

