/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.constraints;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.performance.PerformancePublisher;
import hudson.plugins.performance.actions.PerformanceBuildAction;
import hudson.plugins.performance.constraints.AbstractConstraint;
import hudson.plugins.performance.constraints.ConstraintEvaluation;
import hudson.plugins.performance.constraints.blocks.PreviousResultsBlock;
import hudson.plugins.performance.constraints.blocks.TestCaseBlock;
import hudson.plugins.performance.descriptors.ConstraintDescriptor;
import hudson.plugins.performance.reports.PerformanceReport;
import hudson.plugins.performance.reports.UriReport;
import hudson.plugins.performance.tools.SafeMaths;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.RunList;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RelativeConstraint
extends AbstractConstraint {
    private double tolerance = 0.0;
    private boolean choicePreviousResults = true;
    private Date timeframeStart = new Date();
    private Date timeframeEnd = new Date();
    private PreviousResultsBlock previousResultsBlock;
    private String timeframeStartString = "";
    private String timeframeEndString = "";
    private int previousResults = 0;
    private String previousResultsString = "";

    @DataBoundConstructor
    public RelativeConstraint(AbstractConstraint.Metric meteredValue, AbstractConstraint.Operator operator, String relatedPerfReport, AbstractConstraint.Escalation escalationLevel, boolean success, TestCaseBlock testCaseBlock, PreviousResultsBlock previousResultsBlock, double tolerance) {
        super(meteredValue, operator, relatedPerfReport, escalationLevel, success, testCaseBlock);
        this.tolerance = tolerance;
        this.previousResultsBlock = previousResultsBlock;
        if (this.previousResultsBlock.isChoicePreviousResults()) {
            if ("*".equals(this.previousResultsBlock.getPreviousResultsString())) {
                this.previousResults = -1;
            } else {
                try {
                    this.previousResults = Integer.parseInt(this.previousResultsBlock.getPreviousResultsString());
                }
                catch (NumberFormatException ex) {
                    this.previousResults = -1;
                }
            }
            this.previousResultsString = this.previousResultsBlock.getPreviousResultsString();
        }
        if (this.previousResultsBlock.isChoiceTimeframe()) {
            this.timeframeStartString = this.previousResultsBlock.getTimeframeStartString();
            this.timeframeEndString = this.previousResultsBlock.getTimeframeEndString();
            if (this.timeframeStartString.length() == 10) {
                this.timeframeStartString = this.timeframeStartString + " 00:00";
            }
            if (this.timeframeEndString.length() == 10) {
                this.timeframeEndString = this.timeframeEndString + " 23:59";
            }
            try {
                SimpleDateFormat dfLong = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                this.timeframeStart = dfLong.parse(this.timeframeStartString);
                if (!"now".equals(this.timeframeEndString)) {
                    this.timeframeEnd = dfLong.parse(this.timeframeEndString);
                }
            }
            catch (ParseException e) {
                PrintStream logger = this.getSettings().getListener().getLogger();
                logger.print("Error occurred parsing one of those dates, timeframeStartString:" + this.timeframeStartString + ", timeframeEndString:" + this.timeframeEndString + " using format:yyyy-MM-dd HH:mm, message:" + e.getMessage());
                e.printStackTrace(logger);
            }
        }
        if (this.previousResultsBlock.isChoiceBaselineBuild()) {
            // empty if block
        }
    }

    @Override
    public RelativeConstraint clone() {
        return new RelativeConstraint(this.getMeteredValue(), this.getOperator(), this.getRelatedPerfReport(), this.getEscalationLevel(), this.getSuccess(), new TestCaseBlock(this.getTestCaseBlock().getTestCase()), new PreviousResultsBlock(this.getPreviousResultsBlock().getValue(), this.getPreviousResultsString(), this.getTimeframeStartString(), this.getTimeframeEndString()), this.getTolerance());
    }

    @Override
    public ConstraintEvaluation evaluate(List<? extends Run<?, ?>> builds) throws AbortException, ParseException {
        if (builds.isEmpty()) {
            throw new AbortException("Performance: No builds found to evaluate!");
        }
        this.checkForDefectiveParams(builds);
        PerformanceReport pr = ((PerformanceBuildAction)builds.get(0).getAction(PerformanceBuildAction.class)).getPerformanceReportMap().getPerformanceReport(this.getRelatedPerfReport());
        double calValue = 0.0;
        if (!this.isSpecifiedTestCase()) {
            calValue = this.checkMetredValueforPerfReport(this.getMeteredValue(), pr);
        } else {
            List<UriReport> uriList = pr.getUriListOrdered();
            for (UriReport ur : uriList) {
                if (!this.getTestCaseBlock().getTestCase().equals(ur.getUri())) continue;
                calValue = this.checkMetredValueforUriReport(this.getMeteredValue(), ur);
                break;
            }
        }
        return this.check(builds, calValue);
    }

    private ConstraintEvaluation check(List<? extends Run<?, ?>> builds, double newValue) {
        String measuredLevel;
        double calculatedValue = this.calcAveOfReports(builds);
        if (calculatedValue == -9.223372036854776E18) {
            boolean isVeryFirstBuild = builds.size() == 1;
            this.setSuccess(isVeryFirstBuild);
            this.setResultMessage("Relative constraint " + (isVeryFirstBuild ? "skipped." : "failed!") + " - Report: " + this.getRelatedPerfReport() + "\nThere were no builds found to evaluate!");
            return new ConstraintEvaluation(this, 0.0, 0.0);
        }
        double result = 0.0;
        if (this.getOperator().equals((Object)AbstractConstraint.Operator.NOT_GREATER)) {
            result = calculatedValue * (1.0 + this.getTolerance() / 100.0);
        } else if (this.getOperator().equals((Object)AbstractConstraint.Operator.NOT_LESS)) {
            result = calculatedValue * (1.0 - this.getTolerance() / 100.0);
        } else {
            try {
                throw new AbortException("Performance Plugin: Relative Constraints can only handle \"not greater than\" and \"not less than\" operators. Please check your constraint configuration");
            }
            catch (AbortException e) {
                PrintStream logger = this.getSettings().getListener().getLogger();
                e.printStackTrace(logger);
            }
        }
        switch (this.getOperator()) {
            case NOT_LESS: {
                this.setSuccess(result < newValue);
                break;
            }
            case NOT_GREATER: {
                this.setSuccess(result >= newValue);
                break;
            }
            default: {
                this.setSuccess(false);
            }
        }
        ConstraintEvaluation evaluation = new ConstraintEvaluation(this, result, calculatedValue);
        String string = measuredLevel = this.isSpecifiedTestCase() ? this.getTestCaseBlock().getTestCase() : "all test cases";
        if (this.getSuccess()) {
            this.setResultMessage("Relative constraint successful! - Report: " + this.getRelatedPerfReport() + "\nThe constraint says: " + this.getMeteredValue() + " of " + measuredLevel + " must " + this.getOperator().text + " " + result + "\nMeasured value for " + this.getMeteredValue() + ": " + newValue + "\nIncluded builds: " + this.getPreviousResults() + " builds \nEscalation Level: " + this.getEscalationLevel());
        } else {
            this.setResultMessage("Relative constraint failed! - Report: " + this.getRelatedPerfReport() + "\nThe constraint says: " + this.getMeteredValue() + " of " + measuredLevel + " must " + this.getOperator().text + " " + result + "\nMeasured value for " + this.getMeteredValue() + ": " + newValue + "\nIncluded builds: Last " + this.getPreviousResults() + " builds \nEscalation Level: " + this.getEscalationLevel());
        }
        String unit = this.getMeteredValue() == AbstractConstraint.Metric.ERRORPRC ? "percent" : "milliseconds";
        this.setJunitResult(String.format("<testcase classname=\"%s\" name=\"%s of %s must %s %.3f percent above/below previous\">%n", new Object[]{this.getRelatedPerfReport(), this.getMeteredValue(), measuredLevel, this.getOperator().text, this.getTolerance()}) + (this.getSuccess() ? "" : String.format("    <failure type=\"%s\">Measured value for %s: %.0f %s. Previous value: %.0f %s. Deviation: %.3f %%</failure>%n", new Object[]{this.getEscalationLevel(), this.getMeteredValue(), newValue, unit, calculatedValue, unit, (newValue / calculatedValue - 1.0) * 100.0})) + "</testcase>\n");
        return evaluation;
    }

    private long calcAveOfReports(List<? extends Run<?, ?>> builds) {
        ArrayList buildsToAnalyze = new ArrayList();
        long tmpResult = 0L;
        int counter = 0;
        long result = 0L;
        Run<?, ?> newBuild = builds.get(0);
        if (this.getPreviousResultsBlock().isChoiceTimeframe()) {
            buildsToAnalyze.addAll(this.evaluateDate(builds));
        }
        if (this.getPreviousResultsBlock().isChoicePreviousResults()) {
            buildsToAnalyze.addAll(this.evaluatePreviousBuilds(builds));
        }
        if (this.getPreviousResultsBlock().isChoiceBaselineBuild()) {
            buildsToAnalyze.add(builds.get(this.getSettings().getBaselineBuild()));
        }
        this.setPreviousResults(buildsToAnalyze.size());
        if (!buildsToAnalyze.isEmpty()) {
            for (Run run : buildsToAnalyze) {
                if (run.getAction(PerformanceBuildAction.class) != null && !run.equals(newBuild)) {
                    List<PerformanceReport> tmpList = ((PerformanceBuildAction)run.getAction(PerformanceBuildAction.class)).getPerformanceReportMap().getPerformanceListOrdered();
                    for (PerformanceReport pr : tmpList) {
                        if (!this.getRelatedPerfReport().equals(pr.getReportFileName())) continue;
                        tmpResult = !this.isSpecifiedTestCase() ? (long)((double)tmpResult + this.checkMetredValueforPerfReport(this.getMeteredValue(), pr)) : (long)((double)tmpResult + this.getUriValue(pr));
                        ++counter;
                    }
                    continue;
                }
                PrintStream logger = this.getSettings().getListener().getLogger();
                logger.println("Performance: There are no comaparable data available for build #" + run.getNumber() + ". Skipping this build!");
                this.setPreviousResults(this.getPreviousResults() - 1);
            }
        } else {
            PrintStream logger = this.getSettings().getListener().getLogger();
            logger.println("Performance: There were no builds found to evaluate for a relative constraint!");
            return Long.MIN_VALUE;
        }
        result = (long)SafeMaths.safeDivide(tmpResult, counter);
        return result;
    }

    private List<Run<?, ?>> evaluateDate(List<? extends Run<?, ?>> builds) {
        ArrayList result = new ArrayList();
        Calendar timeframeStartAsCalendar = Calendar.getInstance();
        timeframeStartAsCalendar.setTime(this.getTimeframeStart());
        Calendar timeframeEndAsCalendar = Calendar.getInstance();
        timeframeEndAsCalendar.setTime(this.getTimeframeEnd());
        if ("now".equals(this.getTimeframeEndString())) {
            timeframeEndAsCalendar.setTime(new Date());
        }
        for (Run<?, ?> build : builds) {
            Result buildResult = build.getResult();
            if (buildResult == null || !buildResult.equals(Result.SUCCESS) && (!buildResult.equals(Result.UNSTABLE) || this.getSettings().isIgnoreUnstableBuilds()) && (!buildResult.equals(Result.FAILURE) || this.getSettings().isIgnoreFailedBuilds()) || build.getTimestamp().before(timeframeStartAsCalendar) || build.getTimestamp().after(timeframeEndAsCalendar) || build.equals(builds.get(0))) continue;
            result.add(build);
        }
        return result;
    }

    private List<Run<?, ?>> evaluatePreviousBuilds(List<? extends Run<?, ?>> builds) {
        ArrayList result = new ArrayList();
        if (this.getPreviousResults() == -1) {
            this.setPreviousResults(builds.size() - 1);
        }
        int j = 0;
        for (int i = 1; j < this.getPreviousResults() && i < builds.size(); ++i) {
            if (!builds.get(i).getResult().equals(Result.SUCCESS) && (!builds.get(i).getResult().equals(Result.UNSTABLE) || this.getSettings().isIgnoreUnstableBuilds()) && (!builds.get(i).getResult().equals(Result.FAILURE) || this.getSettings().isIgnoreFailedBuilds())) continue;
            result.add(builds.get(i));
            ++j;
        }
        return result;
    }

    private double getUriValue(PerformanceReport pr) {
        double result = 0.0;
        for (UriReport ur : pr.getUriListOrdered()) {
            if (!this.getTestCaseBlock().getTestCase().equals(ur.getUri())) continue;
            result = this.checkMetredValueforUriReport(this.getMeteredValue(), ur);
        }
        return result;
    }

    public int getPreviousResults() {
        return this.previousResults;
    }

    public void setPreviousResults(int previousResults) {
        this.previousResults = previousResults;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }

    public boolean getChoicePreviousResults() {
        return this.choicePreviousResults;
    }

    public void setChoicePreviousResults(boolean choicePreviousResults) {
        this.choicePreviousResults = choicePreviousResults;
    }

    public String getTimeframeStartString() {
        return this.timeframeStartString;
    }

    public void setTimeframeStartString(String timeframeStartString) {
        this.timeframeStartString = timeframeStartString;
    }

    public String getTimeframeEndString() {
        return this.timeframeEndString;
    }

    public void setTimeframeEndString(String timeframeEndString) {
        this.timeframeEndString = timeframeEndString;
    }

    public Date getTimeframeStart() {
        return this.timeframeStart;
    }

    public void setTimeframeStart(Date timeframeStart) {
        this.timeframeStart = timeframeStart;
    }

    public Date getTimeframeEnd() {
        return this.timeframeEnd;
    }

    public void setTimeframeEnd(Date timeframeEnd) {
        this.timeframeEnd = timeframeEnd;
    }

    public PreviousResultsBlock getPreviousResultsBlock() {
        return this.previousResultsBlock;
    }

    public void setPreviousResultsBlock(PreviousResultsBlock previousResultsBlock) {
        this.previousResultsBlock = previousResultsBlock;
    }

    public String getPreviousResultsString() {
        return this.previousResultsString;
    }

    public void setPreviousResultsString(String previousResultsString) {
        this.previousResultsString = previousResultsString;
    }

    @Symbol(value={"relative"})
    @Extension
    public static class DescriptorImpl
    extends ConstraintDescriptor {
        public String getDisplayName() {
            return "Relative Constraint";
        }

        public FormValidation doCheckRelatedPerfReport(@QueryParameter String relatedPerfReport) {
            if (relatedPerfReport == null || relatedPerfReport.isEmpty()) {
                return FormValidation.error((String)"This field must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTestCase(@QueryParameter String testCase) {
            if (testCase == null || testCase.isEmpty()) {
                return FormValidation.error((String)"This field must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeframeStartString(@QueryParameter String timeframeStartString) {
            return this.dateCheck(timeframeStartString);
        }

        public FormValidation doCheckTimeframeEndString(@QueryParameter String timeframeEndString) {
            if ("now".equals(timeframeEndString)) {
                return FormValidation.ok();
            }
            return this.dateCheck(timeframeEndString);
        }

        private FormValidation dateCheck(String dateString) {
            SimpleDateFormat dfLong = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            SimpleDateFormat dfShort = new SimpleDateFormat("yyyy-MM-dd");
            dfLong.setLenient(false);
            dfShort.setLenient(false);
            try {
                if (dfShort.parse(dateString) != null && dateString.length() == 10 || dfLong.parse(dateString) != null && dateString.length() == 16) {
                    return FormValidation.ok();
                }
            }
            catch (ParseException e1) {
                return FormValidation.error((String)"Not a valid date!");
            }
            return FormValidation.error((String)"Not a valid date!");
        }

        public FormValidation doCheckPreviousResultsString(@QueryParameter String previousResultsString, @AncestorInPath AbstractProject<?, ?> project) {
            int previousResults;
            if ("*".equals(previousResultsString)) {
                return FormValidation.ok();
            }
            try {
                previousResults = Integer.parseInt(previousResultsString);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"This is not a valid number");
            }
            if (previousResults < 1) {
                return FormValidation.error((String)"This value can't be smaller 1");
            }
            if (project == null) {
                return FormValidation.ok();
            }
            RunList builds = project.getBuilds();
            int buildsToAnalyze = 0;
            int successBuilds = 0;
            int failedBuilds = 0;
            int unstableBuilds = 0;
            Object buildSizeMessage = "This value cant be bigger than the amount of stored builds with the status: SUCCESS";
            ListIterator it = builds.listIterator();
            while (it.hasNext()) {
                FreeStyleBuild b;
                Result buildResult;
                Object next = it.next();
                if (!(next instanceof FreeStyleBuild) || (buildResult = (b = (FreeStyleBuild)next).getResult()) == null) continue;
                if (buildResult.equals(Result.FAILURE)) {
                    ++failedBuilds;
                    continue;
                }
                if (buildResult.equals(Result.UNSTABLE)) {
                    ++unstableBuilds;
                    continue;
                }
                if (!buildResult.equals(Result.SUCCESS)) continue;
                ++successBuilds;
            }
            buildsToAnalyze = successBuilds;
            boolean ignoreFailedBuilds = false;
            boolean ignoreUnstableBuilds = false;
            List list = project.getPublishersList().toList();
            for (Publisher p : list) {
                if (!(p instanceof PerformancePublisher)) continue;
                PerformancePublisher pp = (PerformancePublisher)p;
                ignoreFailedBuilds = pp.isIgnoreFailedBuilds();
                ignoreUnstableBuilds = pp.isIgnoreUnstableBuilds();
                break;
            }
            if (!ignoreUnstableBuilds) {
                buildsToAnalyze += unstableBuilds;
                buildSizeMessage = (String)buildSizeMessage + ", UNSTABLE";
            }
            if (!ignoreFailedBuilds) {
                buildsToAnalyze += failedBuilds;
                buildSizeMessage = (String)buildSizeMessage + ", FAILED";
            }
            if (previousResults > buildsToAnalyze + 1) {
                return FormValidation.error((String)buildSizeMessage);
            }
            return FormValidation.ok();
        }
    }
}

