/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.ValidationException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.SAXException;

public class IagoParser
extends AbstractParser {
    public String statsDateFormat = this.getStatsDateFormat();

    @DataBoundConstructor
    public IagoParser(String glob, String percentiles) {
        super(glob, percentiles);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "parrot-server-stats.log";
    }

    protected String getStatsDateFormat() {
        return "yyyymmdd-HH:mm:ss.SSS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        PerformanceReport report = new PerformanceReport(this.percentiles);
        report.setExcludeResponseTime(this.excludeResponseTime);
        report.setReportFileName(reportFile.getName());
        try (BufferedReader reader = new BufferedReader(new FileReader(reportFile));){
            String line = reader.readLine();
            while (line != null) {
                HttpSample sample = this.getSample(line, reportFile.getName());
                String nextLine = reader.readLine();
                if (sample != null) {
                    try {
                        report.addSample(sample);
                    }
                    catch (SAXException e) {
                        throw new RuntimeException("Error parsing file '" + reportFile + "': Unable to add sample for line " + line, e);
                    }
                }
                line = nextLine;
            }
        }
        return report;
    }

    protected HttpSample getSample(String line, String key) throws ParseException, ValidationException {
        HttpSample sample = new HttpSample();
        Pattern pattern = Pattern.compile("^INF \\[(.+)\\] stats: (\\{.+\\})$");
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            throw new ParseException("Invalid line " + line, 0);
        }
        String dateString = matcher.group(1);
        String statsString = matcher.group(2);
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.statsDateFormat);
        Date dateObject = dateFormat.parse(dateString);
        GsonBuilder gsonBuilder = new GsonBuilder();
        StatsDeserializer deserializer = new StatsDeserializer();
        gsonBuilder.registerTypeAdapter(Stats.class, (Object)deserializer);
        Gson gson = gsonBuilder.create();
        Stats statsObject = null;
        try {
            statsObject = (Stats)gson.fromJson(statsString, Stats.class);
        }
        catch (JsonParseException e) {
            throw new ValidationException("Invalid stat data " + statsString + ":" + e.getLocalizedMessage());
        }
        sample.setDate(dateObject);
        sample.setSummarizer(true);
        sample.setSummarizerSamples(statsObject.getClientRequests());
        sample.setDuration(statsObject.getClientRequestLatencyMsAverage());
        sample.setSuccessful(true);
        sample.setSummarizerMin(statsObject.getClientRequestLatencyMsMinimum());
        sample.setSummarizerMax(statsObject.getClientRequestLatencyMsMaximum());
        sample.setSummarizerErrors(statsObject.getClientRequests() - statsObject.getClientSuccess() + statsObject.getSumValidationErrors());
        sample.setUri(key);
        return sample;
    }

    private static class StatsDeserializer
    implements JsonDeserializer<Stats> {
        private static final String[] requiredFields = new String[]{"client/request_latency_ms_minimum", "client/request_latency_ms_maximum", "client/request_latency_ms_average", "client/sent_bytes", "client/requests", "client/success"};

        private StatsDeserializer() {
        }

        public Stats deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = (JsonObject)json;
            Object statsObj = null;
            for (String fieldName : requiredFields) {
                if (jsonObject.get(fieldName) != null) continue;
                throw new JsonParseException("Required Field Not Found: " + fieldName);
            }
            return (Stats)new Gson().fromJson(json, Stats.class);
        }
    }

    protected static class Stats {
        @SerializedName(value="client/request_latency_ms_minimum")
        private long clientRequestLatencyMsMinimum = 0L;
        @SerializedName(value="client/request_latency_ms_maximum")
        private long clientRequestLatencyMsMaximum = 0L;
        @SerializedName(value="client/request_latency_ms_average")
        private long clientRequestLatencyMsAverage = 0L;
        @SerializedName(value="client/sent_bytes")
        private long clientSendBytes = 0L;
        @SerializedName(value="client/requests")
        private long clientRequests = 0L;
        @SerializedName(value="client/success")
        private long clientSuccess = 0L;
        private transient Dictionary<String, Long> validationErrors = new Hashtable<String, Long>();

        public long getClientRequestLatencyMsMinimum() {
            return this.clientRequestLatencyMsMinimum;
        }

        public void setClientRequestLatencyMsMinimum(long clientRequestLatencyMsMinimum) {
            this.clientRequestLatencyMsMinimum = clientRequestLatencyMsMinimum;
        }

        public long getClientRequestLatencyMsMaximum() {
            return this.clientRequestLatencyMsMaximum;
        }

        public void setClientRequestLatencyMsMaximum(long clientRequestLatencyMsMaximum) {
            this.clientRequestLatencyMsMaximum = clientRequestLatencyMsMaximum;
        }

        public long getClientRequestLatencyMsAverage() {
            return this.clientRequestLatencyMsAverage;
        }

        public void setClientRequestLatencyMsAverage(long clientRequestLatencyMsAverage) {
            this.clientRequestLatencyMsAverage = clientRequestLatencyMsAverage;
        }

        public long getClientSendBytes() {
            return this.clientSendBytes;
        }

        public void setClientSendBytes(long clientSendBytes) {
            this.clientSendBytes = clientSendBytes;
        }

        public long getClientRequests() {
            return this.clientRequests;
        }

        public void setClientRequests(long clientRequests) {
            this.clientRequests = clientRequests;
        }

        public long getClientSuccess() {
            return this.clientSuccess;
        }

        public void setClientSuccess(long clientSuccess) {
            this.clientSuccess = clientSuccess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addValidationError(String name, long value) {
            Dictionary<String, Long> dictionary = this.validationErrors;
            synchronized (dictionary) {
                this.validationErrors.put(name, new Long(value));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getSumValidationErrors() {
            long sumValidationErrors = 0L;
            Dictionary<String, Long> dictionary = this.validationErrors;
            synchronized (dictionary) {
                Enumeration<String> keys = this.validationErrors.keys();
                while (keys.hasMoreElements()) {
                    sumValidationErrors += this.validationErrors.get(keys.nextElement()).longValue();
                }
            }
            return sumValidationErrors;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "Iago";
        }
    }
}

