/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Run;
import hudson.plugins.performance.parsers.IagoParser;
import hudson.plugins.performance.parsers.JMeterCsvParser;
import hudson.plugins.performance.parsers.JMeterParser;
import hudson.plugins.performance.parsers.JUnitParser;
import hudson.plugins.performance.parsers.JmeterSummarizerParser;
import hudson.plugins.performance.parsers.LoadRunnerParser;
import hudson.plugins.performance.parsers.ParserDetector;
import hudson.plugins.performance.parsers.PerformanceReportParser;
import hudson.plugins.performance.parsers.TaurusParser;
import hudson.plugins.performance.parsers.WrkSummarizerParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParserFactory {
    private static final Logger LOGGER = Logger.getLogger(ParserFactory.class.getName());
    protected static final Map<String, String> defaultGlobPatterns = new Hashtable<String, String>();

    public static PerformanceReportParser getParser(Run<?, ?> build, FilePath workspace, PrintStream logger, String glob, EnvVars env) throws IOException, InterruptedException {
        String expandGlob = env.expand(glob);
        if (defaultGlobPatterns.containsKey(expandGlob)) {
            return ParserFactory.getParser(defaultGlobPatterns.get(expandGlob), expandGlob);
        }
        File path = new File(expandGlob);
        return path.isAbsolute() ? ParserFactory.getParserWithAbsolutePath(build, workspace, logger, path) : ParserFactory.getParserWithRelativePath(build, workspace, logger, expandGlob);
    }

    private static PerformanceReportParser getParserWithRelativePath(Run<?, ?> build, FilePath workspace, PrintStream logger, String glob) throws IOException, InterruptedException {
        PerformanceReportParser result = ParserFactory.getParserUsingAntPatternRelativePath(build, workspace, logger, glob);
        if (result != null) {
            return result;
        }
        File report = new File(workspace.getRemote() + '/' + glob);
        if (!report.exists()) {
            FilePath localReport = new FilePath(new File(build.getRootDir(), "/temp/" + glob));
            localReport.copyFrom(new FilePath(workspace, glob));
            return ParserFactory.getParser(ParserDetector.detect(localReport.getRemote()), glob);
        }
        return ParserFactory.getParser(ParserDetector.detect(workspace.getRemote() + '/' + glob), workspace.getRemote() + '/' + glob);
    }

    private static PerformanceReportParser getParserUsingAntPatternRelativePath(Run<?, ?> build, FilePath workspace, PrintStream logger, String glob) throws InterruptedException {
        try {
            FilePath[] pathList;
            for (FilePath src : pathList = workspace.list(glob)) {
                File localReport = new File(build.getRootDir(), "/temp/" + src.getName());
                if (!src.isDirectory()) {
                    src.copyTo(new FilePath(localReport));
                    return ParserFactory.getParser(ParserDetector.detect(localReport.getPath()), glob);
                }
                logger.println("Performance: File '" + src.getName() + "' is a directory, not a Performance Report");
            }
        }
        catch (IOException ignored) {
            LOGGER.log(Level.FINE, "Cannot find report file using Ant pattern", ignored);
        }
        return null;
    }

    private static PerformanceReportParser getParserWithAbsolutePath(Run<?, ?> build, FilePath workspace, PrintStream logger, File path) throws IOException, InterruptedException {
        PerformanceReportParser result = ParserFactory.getParserUsingAntPatternAbsolutePath(build, workspace, logger, path);
        if (result != null) {
            return result;
        }
        if (!path.exists()) {
            FilePath localReport = new FilePath(new File(build.getRootDir(), "/temp/" + path.getName()));
            localReport.copyFrom(new FilePath(workspace.getChannel(), path.getAbsolutePath()));
            return ParserFactory.getParser(ParserDetector.detect(localReport.getRemote()), path.getName());
        }
        return ParserFactory.getParser(ParserDetector.detect(path.getAbsolutePath()), path.getAbsolutePath());
    }

    private static PerformanceReportParser getParserUsingAntPatternAbsolutePath(Run<?, ?> build, FilePath wsp, PrintStream logger, File path) throws InterruptedException {
        try {
            FilePath[] pathList;
            File parent = path.getParentFile();
            FilePath workspace = new FilePath(wsp.getChannel(), parent.getAbsolutePath());
            while (!workspace.exists()) {
                if ((parent = parent.getParentFile()) != null) {
                    workspace = new FilePath(wsp.getChannel(), parent.getAbsolutePath());
                    continue;
                }
                return null;
            }
            String glob = path.getAbsolutePath().substring(parent.getAbsolutePath().length() + 1);
            for (FilePath src : pathList = workspace.list(glob)) {
                File localReport = new File(build.getRootDir(), "/temp/" + src.getName());
                if (!src.isDirectory()) {
                    src.copyTo(new FilePath(localReport));
                    return ParserFactory.getParser(ParserDetector.detect(localReport.getPath()), localReport.getPath());
                }
                logger.println("Performance: File '" + src.getName() + "' is a directory, not a Performance Report");
            }
        }
        catch (IOException ignored) {
            LOGGER.log(Level.FINE, "Cannot find report file using Ant pattern", ignored);
        }
        return null;
    }

    private static PerformanceReportParser getParser(String parserName, String glob) {
        if (parserName.equals(JMeterParser.class.getSimpleName())) {
            return new JMeterParser(glob);
        }
        if (parserName.equals(JMeterCsvParser.class.getSimpleName())) {
            return new JMeterCsvParser(glob);
        }
        if (parserName.equals(JUnitParser.class.getSimpleName())) {
            return new JUnitParser(glob);
        }
        if (parserName.equals(TaurusParser.class.getSimpleName())) {
            return new TaurusParser(glob);
        }
        if (parserName.equals(WrkSummarizerParser.class.getSimpleName())) {
            return new WrkSummarizerParser(glob);
        }
        if (parserName.equals(JmeterSummarizerParser.class.getSimpleName())) {
            return new JmeterSummarizerParser(glob);
        }
        if (parserName.equals(IagoParser.class.getSimpleName())) {
            return new IagoParser(glob);
        }
        if (parserName.equals(LoadRunnerParser.class.getSimpleName())) {
            return new LoadRunnerParser(glob);
        }
        throw new IllegalArgumentException("Unknown parser type: " + parserName);
    }

    static {
        defaultGlobPatterns.put("parrot-server-stats.log", IagoParser.class.getSimpleName());
        defaultGlobPatterns.put("**/*.csv", JMeterCsvParser.class.getSimpleName());
        defaultGlobPatterns.put("**/*.jtl", JMeterParser.class.getSimpleName());
        defaultGlobPatterns.put("**/*.log", JmeterSummarizerParser.class.getSimpleName());
        defaultGlobPatterns.put("**/TEST-*.xml", JUnitParser.class.getSimpleName());
        defaultGlobPatterns.put("**/*.xml", TaurusParser.class.getSimpleName());
        defaultGlobPatterns.put("**/*.wrk", WrkSummarizerParser.class.getSimpleName());
        defaultGlobPatterns.put("**/*.mdb", LoadRunnerParser.class.getSimpleName());
    }
}

