/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.constraints;

import hudson.model.Run;
import hudson.plugins.performance.actions.PerformanceBuildAction;
import hudson.plugins.performance.constraints.AbstractConstraint;
import hudson.plugins.performance.reports.PerformanceReport;
import hudson.plugins.performance.reports.UriReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConstraintFactory {
    public List<? extends AbstractConstraint> createConstraintClones(Run<?, ?> build, List<? extends AbstractConstraint> constraints) {
        ArrayList<AbstractConstraint> createdConstraints = new ArrayList<AbstractConstraint>();
        for (AbstractConstraint abstractConstraint : constraints) {
            List<Object> testCases = new ArrayList();
            if (abstractConstraint.isSpecifiedTestCase()) {
                String testCase = abstractConstraint.getTestCaseBlock().getTestCase();
                if ("*".equals(testCase)) {
                    PerformanceReport pr = ((PerformanceBuildAction)build.getAction(PerformanceBuildAction.class)).getPerformanceReportMap().getPerformanceReport(abstractConstraint.getRelatedPerfReport());
                    for (UriReport ur : pr.getUriListOrdered()) {
                        testCases.add(ur.getUri());
                    }
                } else {
                    String[] tmpTestCases = testCase.split(",");
                    String[] stringArray = new String[tmpTestCases.length];
                    for (int i = 0; i < tmpTestCases.length; ++i) {
                        stringArray[i] = tmpTestCases[i].trim();
                    }
                    testCases = Arrays.asList(stringArray);
                }
                for (String string : testCases) {
                    AbstractConstraint constraint = abstractConstraint.clone();
                    constraint.getTestCaseBlock().setTestCase(string);
                    createdConstraints.add(constraint);
                }
                continue;
            }
            createdConstraints.add(abstractConstraint);
        }
        return createdConstraints;
    }
}

