/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.performance.parsers.JMeterParser;
import hudson.plugins.performance.parsers.PerformanceReportParser;
import hudson.plugins.performance.reports.PerformanceReport;
import hudson.plugins.performance.reports.UriReport;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractParser
extends PerformanceReportParser {
    private static final Logger LOGGER = Logger.getLogger(JMeterParser.class.getName());
    private static final String SERIALIZED_DATA_FILE_SUFFIX = ".serialized";
    private static final Cache<String, PerformanceReport> CACHE = CacheBuilder.newBuilder().maximumSize(1000L).softValues().build();
    protected boolean isNumberDateFormat = false;
    protected SimpleDateFormat format;
    protected static final String[] DATE_FORMATS = new String[]{"yyyy/MM/dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss,SSS", "yyyy/mm/dd HH:mm:ss"};
    protected String percentiles;
    protected String filterRegex;

    public AbstractParser(String glob, String percentiles, String filterRegex) {
        super(glob);
        this.percentiles = percentiles;
        this.filterRegex = filterRegex;
    }

    @Override
    public Collection<PerformanceReport> parse(Run<?, ?> build, Collection<File> reports, TaskListener listener) throws IOException {
        ArrayList<PerformanceReport> result = new ArrayList<PerformanceReport>();
        for (File reportFile : reports) {
            PerformanceReport deserializedReport = AbstractParser.loadSerializedReport(reportFile);
            if (deserializedReport != null) {
                result.add(deserializedReport);
                continue;
            }
            try {
                listener.getLogger().println("Performance: Parsing report file '" + reportFile + "' with filterRegex '" + this.filterRegex + "'.");
                PerformanceReport report = this.parse(reportFile);
                result.add(report);
                this.passBaselineBuild(report);
                AbstractParser.saveSerializedReport(reportFile, report);
            }
            catch (Throwable e) {
                listener.getLogger().println("Performance: Failed to parse file '" + reportFile + "': " + e.getMessage());
                e.printStackTrace(listener.getLogger());
            }
        }
        return result;
    }

    private void passBaselineBuild(PerformanceReport report) {
        report.setBaselineBuild(this.baselineBuild);
    }

    abstract PerformanceReport parse(File var1) throws Exception;

    /*
     * Exception decompiling
     */
    protected static PerformanceReport loadSerializedReport(File reportFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void saveSerializedReport(File reportFile, PerformanceReport report) {
        if (reportFile == null) {
            throw new IllegalArgumentException("Argument 'reportFile' cannot be null.");
        }
        if (report == null) {
            throw new IllegalArgumentException("Argument 'report' cannot be null.");
        }
        String serialized = reportFile.getPath() + SERIALIZED_DATA_FILE_SUFFIX;
        Cache<String, PerformanceReport> cache = CACHE;
        synchronized (cache) {
            CACHE.put((Object)serialized, (Object)report);
        }
        try (FileOutputStream fos = new FileOutputStream(serialized);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             ObjectOutputStream out = new ObjectOutputStream(bos);){
            out.writeObject(report);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Saving serialized PerformanceReport instance to file '" + serialized + "' failed.", ex);
        }
    }

    public void clearDateFormat() {
        this.format = null;
        this.isNumberDateFormat = false;
    }

    public Date parseTimestamp(String timestamp) {
        if (this.format == null) {
            this.initDateFormat(timestamp);
        }
        try {
            return this.isNumberDateFormat ? new Date(Long.valueOf(timestamp)) : this.format.parse(timestamp);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse timestamp: " + timestamp + ". Please, use one of supported formats: " + Arrays.toString(DATE_FORMATS), e);
        }
    }

    private void initDateFormat(String timestamp) {
        Date result = null;
        for (String format : DATE_FORMATS) {
            try {
                this.format = new SimpleDateFormat(format);
                result = this.format.parse(timestamp);
            }
            catch (ParseException ex) {
                this.format = null;
            }
            if (result != null) break;
        }
        if (result == null) {
            try {
                Long.valueOf(timestamp);
                this.isNumberDateFormat = true;
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Cannot parse timestamp: " + timestamp + ". Please, use one of supported formats: " + Arrays.toString(DATE_FORMATS), ex);
            }
        }
    }

    protected PerformanceReport createPerformanceReport() {
        return new PerformanceReport(this.percentiles, this.filterRegex);
    }

    public static class ObjectInputStreamWithClassMapping
    extends ObjectInputStream {
        protected Hashtable<String, Class> classMapping = new Hashtable();

        public ObjectInputStreamWithClassMapping(InputStream in) throws IOException {
            super(in);
            this.classMapping.put("hudson.plugins.performance.PerformanceReport", PerformanceReport.class);
            this.classMapping.put("hudson.plugins.performance.UriReport", UriReport.class);
            this.classMapping.put("hudson.plugins.performance.UriReport$Sample", UriReport.Sample.class);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return this.classMapping.containsKey(desc.getName()) ? this.classMapping.get(desc.getName()) : super.resolveClass(desc);
        }
    }
}

