/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.constraints;

import hudson.AbortException;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Run;
import hudson.plugins.performance.actions.PerformanceBuildAction;
import hudson.plugins.performance.constraints.AbsoluteConstraint;
import hudson.plugins.performance.constraints.ConstraintEvaluation;
import hudson.plugins.performance.constraints.RelativeConstraint;
import hudson.plugins.performance.constraints.blocks.TestCaseBlock;
import hudson.plugins.performance.data.ConstraintSettings;
import hudson.plugins.performance.descriptors.ConstraintDescriptor;
import hudson.plugins.performance.reports.PerformanceReport;
import hudson.plugins.performance.reports.UriReport;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import jenkins.model.Jenkins;

public abstract class AbstractConstraint
implements Describable<AbstractConstraint>,
ExtensionPoint {
    public static final String ANY = "*";
    protected static final String NOW = "now";
    private boolean success = false;
    private boolean isSpecifiedTestCase = false;
    private Metric meteredValue;
    private Operator operator;
    private Escalation escalationLevel;
    private String resultMessage = "";
    private String junitResult = "";
    private String relatedPerfReport;
    private TestCaseBlock testCaseBlock;
    private ConstraintSettings settings;

    public ConstraintDescriptor getDescriptor() {
        return (ConstraintDescriptor)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public static ExtensionList<AbstractConstraint> all() {
        return Jenkins.getInstance().getExtensionList(AbstractConstraint.class);
    }

    protected AbstractConstraint(Metric meteredValue, Operator operator, String relatedPerfReport, Escalation escalationLevel, boolean success, TestCaseBlock testCaseBlock) {
        this.relatedPerfReport = relatedPerfReport;
        this.success = success;
        this.meteredValue = meteredValue;
        this.operator = operator;
        this.escalationLevel = escalationLevel;
        if (testCaseBlock != null) {
            this.setSpecifiedTestCase(true);
            this.testCaseBlock = testCaseBlock;
        } else {
            this.setSpecifiedTestCase(false);
        }
    }

    public abstract AbstractConstraint clone();

    public abstract ConstraintEvaluation evaluate(List<? extends Run<?, ?>> var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, AbortException, ParseException;

    protected double checkMetredValueforUriReport(Metric meteredValue, UriReport ur) {
        switch (meteredValue) {
            case ERRORPRC: {
                return ur.errorPercent();
            }
            case AVERAGE: {
                return ur.getAverage();
            }
            case LINE90: {
                return ur.get90Line();
            }
            case MEDIAN: {
                return ur.getMedian();
            }
            case MINIMUM: {
                return ur.getMin();
            }
            case MAXIMUM: {
                return ur.getMax();
            }
        }
        return ur.getAverage();
    }

    protected double checkMetredValueforPerfReport(Metric meteredValue, PerformanceReport pr) {
        switch (meteredValue) {
            case ERRORPRC: {
                return pr.errorPercent();
            }
            case AVERAGE: {
                return pr.getAverage();
            }
            case LINE90: {
                return pr.get90Line();
            }
            case MEDIAN: {
                return pr.getMedian();
            }
            case MINIMUM: {
                return pr.getMin();
            }
            case MAXIMUM: {
                return pr.getMax();
            }
        }
        return pr.getAverage();
    }

    protected void checkForDefectiveParams(List<? extends Run<?, ?>> builds) throws AbortException {
        AbsoluteConstraint ac;
        boolean found = false;
        if (((PerformanceBuildAction)builds.get(0).getAction(PerformanceBuildAction.class)).getPerformanceReportMap().getPerformanceReport(this.getRelatedPerfReport()) == null) {
            throw new AbortException("Performance Plugin: Could't find a report specified in the performance constraints! Report: \"" + this.getRelatedPerfReport() + "\"");
        }
        PerformanceReport pr = ((PerformanceBuildAction)builds.get(0).getAction(PerformanceBuildAction.class)).getPerformanceReportMap().getPerformanceReport(this.getRelatedPerfReport());
        if (this.isSpecifiedTestCase()) {
            for (UriReport ur : pr.getUriListOrdered()) {
                if (!ur.getUri().equals(this.getTestCaseBlock().getTestCase())) continue;
                found = true;
            }
            if (!found) {
                throw new AbortException("Performance Plugin: Could't find a test case specified in the performance constraints! TestCase: \"" + this.getTestCaseBlock().getTestCase() + "\" Report: \"" + this.getRelatedPerfReport() + "\"");
            }
        }
        if (this instanceof AbsoluteConstraint && (ac = (AbsoluteConstraint)this).getValue() < 0L) {
            throw new AbortException("Performance Plugin: The value of a Absolute Constraint can't be negative!");
        }
        if (this instanceof RelativeConstraint) {
            RelativeConstraint rc = (RelativeConstraint)this;
            if (rc.getTolerance() < 0.0) {
                throw new AbortException("Performance Plugin: The tolerance of a Relative Constraint can't be negative!");
            }
            if (rc.getTimeframeStart().after(rc.getTimeframeEnd())) {
                throw new AbortException("Performance Plugin: The start date of a Relative Constraint can't be after the end date");
            }
            if (rc.getPreviousResultsBlock().isChoiceTimeframe()) {
                SimpleDateFormat dfLong = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                try {
                    rc.setTimeframeStart(dfLong.parse(rc.getTimeframeStartString()));
                    if (!NOW.equals(rc.getTimeframeEndString())) {
                        rc.setTimeframeEnd(dfLong.parse(rc.getTimeframeEndString()));
                    }
                }
                catch (ParseException e) {
                    throw new AbortException("Performance Plugin: Couldn't parse date in Relative Constraint! Please check the configuration of your constraints");
                }
            }
        }
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public String getResultMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public String getJunitResult() {
        return this.junitResult;
    }

    public void setJunitResult(String junitResult) {
        this.junitResult = junitResult;
    }

    public String getRelatedPerfReport() {
        return this.relatedPerfReport;
    }

    public void setRelatedPerfReport(String relatedPerfReport) {
        this.relatedPerfReport = relatedPerfReport;
    }

    public Metric getMeteredValue() {
        return this.meteredValue;
    }

    public void setMeteredValue(Metric meteredValue) {
        this.meteredValue = meteredValue;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public Escalation getEscalationLevel() {
        return this.escalationLevel;
    }

    public void setEscalationLevel(Escalation escalationLevel) {
        this.escalationLevel = escalationLevel;
    }

    public TestCaseBlock getTestCaseBlock() {
        return this.testCaseBlock;
    }

    public void setTestCaseBlock(TestCaseBlock testCaseBlock) {
        this.testCaseBlock = testCaseBlock;
    }

    public boolean isSpecifiedTestCase() {
        return this.isSpecifiedTestCase;
    }

    public void setSpecifiedTestCase(boolean isSpecifiedTestCase) {
        this.isSpecifiedTestCase = isSpecifiedTestCase;
    }

    public ConstraintSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ConstraintSettings settings) {
        this.settings = settings;
    }

    public String getTestCase() {
        if (this.getTestCaseBlock() != null) {
            return this.getTestCaseBlock().getTestCase();
        }
        return null;
    }

    public void setTestCase(String testCase) {
        this.getTestCaseBlock().setTestCase(testCase);
    }

    public static enum Operator {
        NOT_GREATER("not be greater than", false),
        NOT_LESS("not be less than", false),
        NOT_EQUAL("not be equal to", false);

        public final String text;
        private boolean isSelected;

        private Operator(String text, boolean isSelected) {
            this.text = text;
            this.setSelected(isSelected);
        }

        public String toString() {
            return this.text;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }
    }

    public static enum Escalation {
        INFORMATION("Information", false),
        WARNING("Warning", false),
        ERROR("Error", false);

        private final String text;
        private boolean isSelected;

        private Escalation(String text, boolean isSelected) {
            this.text = text;
            this.setSelected(isSelected);
        }

        public String toString() {
            return this.text;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }
    }

    public static enum Metric {
        AVERAGE("Average", false),
        MEDIAN("Median", false),
        LINE90("90% Line", false),
        MAXIMUM("Maximum", false),
        MINIMUM("Minimum", false),
        ERRORPRC("Error %", false);

        private final String text;
        private boolean isSelected;

        private Metric(String text, boolean isSelected) {
            this.text = text;
            this.setSelected(isSelected);
        }

        public String toString() {
            return this.text;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }
    }
}

