/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.build;

import com.google.common.base.Throwables;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformancePublisher;
import hudson.plugins.performance.actions.PerformanceProjectAction;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.output.NullOutputStream;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PerformanceTestBuild
extends Builder
implements SimpleBuildStep {
    public static final Logger LOGGER = Logger.getLogger(PerformanceTestBuild.class.getName());
    protected static final String PERFORMANCE_TEST_COMMAND = "bzt";
    protected static final String VIRTUALENV_COMMAND = "virtualenv";
    protected static final String HELP_OPTION = "--help";
    protected static final String VIRTUALENV_PATH_UNIX = "/taurus-venv/bin/";
    protected static final String VIRTUALENV_PATH_WINDOWS = "\\taurus-venv\\Scripts\\";
    protected static final String[] CHECK_BZT_COMMAND = new String[]{"bzt", "--help"};
    protected static final String[] CHECK_VIRTUALENV_COMMAND = new String[]{"virtualenv", "--help"};
    protected static final String[] CREATE_LOCAL_PYTHON_COMMAND_WITH_SYSTEM_PACKAGES_OPTION = new String[]{"virtualenv", "--clear", "--system-site-packages", "taurus-venv"};
    protected static final String[] CREATE_LOCAL_PYTHON_COMMAND = new String[]{"virtualenv", "--clear", "taurus-venv"};
    protected static final String DEFAULT_CONFIG_FILE = "jenkins-report.yml";
    private String params;
    private boolean printDebugOutput = false;
    private boolean alwaysUseVirtualenv = false;
    private boolean useSystemSitePackages = true;
    private boolean generatePerformanceTrend = true;
    private boolean useBztExitCode = true;
    private String bztVersion = "";
    private String workingDirectory = "";
    private String virtualEnvCommand = "";
    @Deprecated
    private transient String workspace = "";

    @DataBoundConstructor
    public PerformanceTestBuild(String params) {
        this.params = params;
    }

    public Object readResolve() {
        if (this.workspace != null && !this.workspace.isEmpty()) {
            this.workingDirectory = this.workspace;
            this.workspace = "";
        }
        return this;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return this.generatePerformanceTrend ? new PerformanceProjectAction((Job<?, ?>)project) : null;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        FilePath virtualenvWorkspace;
        PrintStream logger = listener.getLogger();
        EnvVars envVars = run.getEnvironment(listener);
        this.addPipelineEnvVars(run, envVars);
        try {
            virtualenvWorkspace = this.getVirtualenvWorkspace(run, workspace, logger);
        }
        catch (Exception ex) {
            logger.println("[ERROR] Performance test: " + ex.getMessage());
            run.setResult(Result.FAILURE);
            return;
        }
        boolean isVirtualenvInstallation = false;
        if (!this.alwaysUseVirtualenv && this.isGlobalBztInstalled(workspace, logger, launcher, envVars) || (isVirtualenvInstallation = this.installBztAndCheck(virtualenvWorkspace, logger, launcher, envVars))) {
            FilePath bztWorkingDirectory = this.getBztWorkingDirectory(workspace);
            try {
                bztWorkingDirectory.mkdirs();
            }
            catch (IOException ex) {
                logger.println("Performance test: Cannot create working directory because of error: " + ex.getMessage());
                run.setResult(Result.FAILURE);
                return;
            }
            int testExitCode = this.runPerformanceTest(bztWorkingDirectory, virtualenvWorkspace, logger, launcher, envVars, isVirtualenvInstallation);
            run.setResult(this.useBztExitCode ? this.getBztJobResult(testExitCode) : this.getJobResult(testExitCode));
            if (this.generatePerformanceTrend && run.getResult().isBetterThan(Result.FAILURE)) {
                this.generatePerformanceTrend(bztWorkingDirectory.getRemote(), run, workspace, launcher, listener);
            }
            return;
        }
        run.setResult(Result.FAILURE);
    }

    private void addPipelineEnvVars(Run<?, ?> run, EnvVars envVars) {
        List allActions;
        if (run.getClass().getCanonicalName().startsWith("org.jenkinsci.plugins.workflow") && !(allActions = run.getActions()).isEmpty()) {
            for (Action action : allActions) {
                if (!"org.jenkinsci.plugins.workflow.cps.EnvActionImpl".equals(action.getClass().getCanonicalName())) continue;
                this.addEnvVars(action, envVars);
            }
        }
    }

    private void addEnvVars(Action action, EnvVars envVars) {
        try {
            Class<?> actionClass = action.getClass();
            Method method = actionClass.getMethod("getOverriddenEnvironment", new Class[0]);
            Map map = (Map)method.invoke((Object)action, new Object[0]);
            envVars.overrideAll(map);
        }
        catch (Throwable ex) {
            LOGGER.warning("Failed to add envVars from action: " + action.getClass());
        }
    }

    private FilePath getVirtualenvWorkspace(Run<?, ?> run, FilePath workspace, PrintStream logger) throws Exception {
        return workspace.getRemote().contains(" ") ? this.createTemporaryWorkspace(run, workspace, logger) : workspace;
    }

    private FilePath createTemporaryWorkspace(Run<?, ?> run, FilePath workspace, PrintStream logger) throws Exception {
        logger.println("[WARNING] Performance test: Job workspace contains spaces in path. Virtualenv does not support such path. Creating temporary workspace for virtualenv.");
        File baseTmpDir = new File(System.getProperty("java.io.tmpdir"));
        if (baseTmpDir.getAbsolutePath().contains(" ")) {
            logger.println("[WARNING] Performance test: Temporary folder contains spaces in path.");
            throw new InvalidPathException(baseTmpDir.getAbsolutePath(), "Virtualenv cannot be installed in workspace that contains spaces in path.");
        }
        File tempDir = new File(baseTmpDir.getAbsolutePath(), "perf-test-virtualenv-workspace-" + this.configJobName(run.getParent().getName()));
        FilePath tempWorkspace = new FilePath(workspace.getChannel(), tempDir.getAbsolutePath());
        tempWorkspace.mkdirs();
        return tempWorkspace;
    }

    private String configJobName(String displayName) {
        return displayName.replaceAll(" ", "-");
    }

    protected FilePath getBztWorkingDirectory(FilePath jobWorkspace) {
        return this.workingDirectory != null && !this.workingDirectory.isEmpty() ? (this.isAbsoluteFilePath() ? new FilePath(jobWorkspace.getChannel(), this.workingDirectory) : new FilePath(jobWorkspace, this.workingDirectory)) : jobWorkspace;
    }

    private boolean isAbsoluteFilePath() {
        return new File(this.workingDirectory).isAbsolute();
    }

    protected void generatePerformanceTrend(String path, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        new PerformancePublisher(path + "/aggregate-results.xml", -1, -1, "", 0.0, 0.0, 0.0, 0.0, 0, false, "", false, false, false, false, true, null).perform(run, workspace, launcher, listener);
    }

    private boolean installBztAndCheck(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        return this.installBzt(workspace, logger, launcher, envVars) && this.isVirtualenvBztInstalled(workspace, logger, launcher, envVars);
    }

    private boolean installBzt(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        return this.isVirtualenvInstalled(workspace, logger, launcher, envVars) && this.createVirtualenvAndInstallBzt(workspace, logger, launcher, envVars);
    }

    private boolean createVirtualenvAndInstallBzt(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        return this.createIsolatedPython(workspace, logger, launcher, envVars) && this.installBztInVirtualenv(workspace, logger, launcher, envVars);
    }

    private boolean isGlobalBztInstalled(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        logger.println("Performance test: Checking global bzt installation...");
        boolean result = this.isSuccessCode(this.runCmd(CHECK_BZT_COMMAND, workspace, (OutputStream)new NullOutputStream(), launcher, envVars));
        logger.println(result ? "Performance test: Found global bzt installation." : "Performance test: You don't have global bzt installed on this Jenkins host. Installing it globally will speed up job. Run 'sudo pip install bzt' to install it.");
        return result;
    }

    private boolean isVirtualenvInstalled(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        logger.println("Performance test: Checking virtualenv tool availability...");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean result = this.isSuccessCode(this.runCmd(CHECK_VIRTUALENV_COMMAND, workspace, outputStream, launcher, envVars));
        logger.println(result ? "Performance test: Found virtualenv tool." : "Performance test: No virtualenv found on this Jenkins host. Install it with 'sudo pip install virtualenv'.");
        if (!result || this.printDebugOutput) {
            logger.write(outputStream.toByteArray());
        }
        return result;
    }

    private boolean createIsolatedPython(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        logger.println("Performance test: Creating virtualev at 'taurus-venv'...");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean result = this.isSuccessCode(this.runCmd(this.useSystemSitePackages ? CREATE_LOCAL_PYTHON_COMMAND_WITH_SYSTEM_PACKAGES_OPTION : CREATE_LOCAL_PYTHON_COMMAND, workspace, outputStream, launcher, envVars));
        logger.println(result ? "Performance test: Done creating virtualenv." : "Performance test: Failed to create virtualenv at 'taurus-venv'");
        if (!result || this.printDebugOutput) {
            logger.write(outputStream.toByteArray());
        }
        return result;
    }

    private boolean installBztInVirtualenv(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        logger.println("Performance test: Installing bzt into 'taurus-venv'");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean result = this.isSuccessCode(this.runCmd(this.getBztInstallCommand(workspace), workspace, outputStream, launcher, envVars));
        logger.println(result ? "Performance test: bzt installed successfully." : "Performance test: Failed to install bzt into 'taurus-venv'");
        if (!result || this.printDebugOutput) {
            logger.write(outputStream.toByteArray());
        }
        return result;
    }

    private boolean isVirtualenvBztInstalled(FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        logger.println("Performance test: Checking installed bzt...");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean result = this.isSuccessCode(this.runCmd(this.getBztCheckCommand(workspace), workspace, outputStream, launcher, envVars));
        logger.println(result ? "Performance test: bzt is operational." : "Performance test: Failed to run bzt inside virtualenv.");
        if (!result || this.printDebugOutput) {
            logger.write(outputStream.toByteArray());
        }
        return result;
    }

    private int runPerformanceTest(FilePath bztWorkingDirectory, FilePath workspace, PrintStream logger, Launcher launcher, EnvVars envVars, boolean isVirtualenvInstallation) throws InterruptedException, IOException {
        String[] parsedParams;
        ArrayList<String> testCommand = new ArrayList<String>();
        testCommand.add((isVirtualenvInstallation ? this.getVirtualenvPath(workspace) : "") + PERFORMANCE_TEST_COMMAND);
        try {
            parsedParams = CommandLineUtils.translateCommandline((String)envVars.expand(this.params));
        }
        catch (Exception e) {
            logger.println("Failed parse Taurus parameters");
            e.printStackTrace(logger);
            return 1;
        }
        for (String param : parsedParams) {
            if (param.isEmpty()) continue;
            testCommand.add(param);
        }
        if (this.generatePerformanceTrend) {
            testCommand.add(this.extractDefaultReportToWorkingDirectory(bztWorkingDirectory));
        }
        logger.println("Performance test: run " + Arrays.toString(testCommand.toArray()));
        return this.runCmd(testCommand.toArray(new String[testCommand.size()]), bztWorkingDirectory, logger, launcher, envVars);
    }

    public boolean isSuccessCode(int code) {
        return code == 0;
    }

    public Result getJobResult(int code) {
        if (code == 0) {
            return Result.SUCCESS;
        }
        return Result.FAILURE;
    }

    public Result getBztJobResult(int code) {
        if (code == 0) {
            return Result.SUCCESS;
        }
        if (code == 1) {
            return Result.FAILURE;
        }
        return Result.UNSTABLE;
    }

    private String getVirtualenvPath(FilePath workspace) {
        return workspace.getRemote() + (Functions.isWindows() ? VIRTUALENV_PATH_WINDOWS : VIRTUALENV_PATH_UNIX);
    }

    private String[] getBztInstallCommand(FilePath workspace) throws IOException, InterruptedException {
        return new String[]{this.getVirtualenvPath(workspace) + "pip", "install", this.getInstallCommand(workspace)};
    }

    private String getInstallCommand(FilePath workspace) throws IOException, InterruptedException {
        if (this.bztVersion != null && !this.bztVersion.isEmpty()) {
            return this.isPathToFile(workspace) || this.isURLToFile() ? this.bztVersion : "bzt==" + this.bztVersion;
        }
        return PERFORMANCE_TEST_COMMAND;
    }

    private boolean isURLToFile() {
        try {
            if (this.bztVersion.startsWith("git+")) {
                new URL(this.bztVersion.substring(4));
            } else {
                new URL(this.bztVersion);
            }
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private boolean isPathToFile(FilePath workspace) throws IOException, InterruptedException {
        return new FilePath(workspace.getChannel(), this.bztVersion).exists();
    }

    private String[] getBztCheckCommand(FilePath workspace) {
        return new String[]{this.getVirtualenvPath(workspace) + PERFORMANCE_TEST_COMMAND, HELP_OPTION};
    }

    private String getVirtualEnvCommand(EnvVars envVars) {
        return this.virtualEnvCommand == null || this.virtualEnvCommand.trim().isEmpty() ? VIRTUALENV_COMMAND : envVars.expand(this.virtualEnvCommand);
    }

    public int runCmd(String[] commands, FilePath workspace, OutputStream logger, Launcher launcher, EnvVars envVars) throws InterruptedException, IOException {
        if (commands[0].equals(VIRTUALENV_COMMAND)) {
            commands[0] = this.getVirtualEnvCommand(envVars);
        }
        try {
            return launcher.launch().cmds(commands).envs((Map)envVars).stdout(logger).stderr(logger).pwd(workspace).start().join();
        }
        catch (IOException ex) {
            logger.write(ex.getMessage().getBytes());
            if (this.printDebugOutput) {
                logger.write(Throwables.getStackTraceAsString((Throwable)ex).getBytes());
            }
            return 1;
        }
    }

    protected String extractDefaultReportToWorkingDirectory(FilePath workingDirectory) throws IOException, InterruptedException {
        FilePath defaultConfig = workingDirectory.child(DEFAULT_CONFIG_FILE);
        defaultConfig.copyFrom(((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_CONFIG_FILE));
        return defaultConfig.getRemote();
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public boolean isPrintDebugOutput() {
        return this.printDebugOutput;
    }

    public boolean isAlwaysUseVirtualenv() {
        return this.alwaysUseVirtualenv;
    }

    @DataBoundSetter
    public void setAlwaysUseVirtualenv(boolean alwaysUseVirtualenv) {
        this.alwaysUseVirtualenv = alwaysUseVirtualenv;
    }

    @DataBoundSetter
    public void setPrintDebugOutput(boolean printDebugOutput) {
        this.printDebugOutput = printDebugOutput;
    }

    public boolean isUseSystemSitePackages() {
        return this.useSystemSitePackages;
    }

    @DataBoundSetter
    public void setUseSystemSitePackages(boolean useSystemSitePackages) {
        this.useSystemSitePackages = useSystemSitePackages;
    }

    public boolean isGeneratePerformanceTrend() {
        return this.generatePerformanceTrend;
    }

    @DataBoundSetter
    public void setGeneratePerformanceTrend(boolean generatePerformanceTrend) {
        this.generatePerformanceTrend = generatePerformanceTrend;
    }

    public boolean isUseBztExitCode() {
        return this.useBztExitCode;
    }

    @DataBoundSetter
    public void setUseBztExitCode(boolean useBztExitCode) {
        this.useBztExitCode = useBztExitCode;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    @DataBoundSetter
    public void setWorkspace(String workspace) {
        this.workspace = workspace;
        this.readResolve();
    }

    public String getBztVersion() {
        return this.bztVersion;
    }

    @DataBoundSetter
    public void setBztVersion(String bztVersion) {
        this.bztVersion = bztVersion;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @DataBoundSetter
    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getVirtualEnvCommand() {
        return this.virtualEnvCommand;
    }

    @DataBoundSetter
    public void setVirtualEnvCommand(String virtualEnvCommand) {
        this.virtualEnvCommand = virtualEnvCommand;
    }

    @Symbol(value={"bzt", "performanceTest"})
    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.PerformanceTest_Name();
        }
    }
}

